/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms;

import java.util.Map;
import java.util.Properties;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.BaseLifeCycle;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointComponentContext;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.jms.JmsEndpoint;
import org.apache.servicemix.soap.Context;
import org.apache.servicemix.soap.SoapEndpoint;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.SoapHelper;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.memory.MemoryStoreFactory;

public abstract class AbstractJmsProcessor
implements ExchangeProcessor {
    public static final String STYLE_QUEUE = "queue";
    public static final String STYLE_TOPIC = "topic";
    public static final String CONTENT_TYPE = "MimeContentType";
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected JmsEndpoint endpoint;
    protected Connection connection;
    protected SoapHelper soapHelper;
    protected ComponentContext context;
    protected DeliveryChannel channel;
    protected Session session;
    protected Destination destination;
    protected Destination replyToDestination;
    protected Store store;

    public AbstractJmsProcessor(JmsEndpoint endpoint) throws Exception {
        this.endpoint = endpoint;
        this.soapHelper = new SoapHelper((SoapEndpoint)endpoint);
        this.context = new EndpointComponentContext((Endpoint)endpoint);
        this.channel = this.context.getDeliveryChannel();
    }

    public void start() throws Exception {
        try {
            InitialContext ctx = this.getInitialContext();
            ConnectionFactory connectionFactory = null;
            connectionFactory = this.getConnectionFactory(ctx);
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            this.store = this.endpoint.store != null ? this.endpoint.store : (this.endpoint.storeFactory != null ? this.endpoint.storeFactory.open(this.endpoint.getService().toString() + this.endpoint.getEndpoint()) : new MemoryStoreFactory().open(this.endpoint.getService().toString() + this.endpoint.getEndpoint()));
            this.doStart(ctx);
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    protected void commonDoStartTasks(InitialContext ctx) throws Exception {
        this.channel = this.endpoint.getServiceUnit().getComponent().getComponentContext().getDeliveryChannel();
        this.session = this.connection.createSession(false, 1);
        this.destination = this.endpoint.getDestination();
        if (this.destination == null) {
            if (this.endpoint.getJndiDestinationName() != null) {
                this.destination = (Destination)ctx.lookup(this.endpoint.getJndiDestinationName());
            } else if (this.endpoint.getJmsProviderDestinationName() != null) {
                this.destination = STYLE_QUEUE.equals(this.endpoint.getDestinationStyle()) ? this.session.createQueue(this.endpoint.getJmsProviderDestinationName()) : this.session.createTopic(this.endpoint.getJmsProviderDestinationName());
            } else {
                throw new IllegalStateException("No destination provided");
            }
        }
        if (this.endpoint.getJndiReplyToName() != null) {
            this.replyToDestination = (Destination)ctx.lookup(this.endpoint.getJndiReplyToName());
        } else if (this.endpoint.getJmsProviderReplyToName() != null) {
            this.replyToDestination = this.destination instanceof Queue ? this.session.createQueue(this.endpoint.getJmsProviderReplyToName()) : this.session.createTopic(this.endpoint.getJmsProviderReplyToName());
        }
    }

    protected ConnectionFactory getConnectionFactory(InitialContext ctx) throws NamingException {
        ConnectionFactory connectionFactory = this.endpoint.getConnectionFactory();
        if (connectionFactory == null && this.endpoint.getJndiConnectionFactoryName() != null) {
            connectionFactory = (ConnectionFactory)ctx.lookup(this.endpoint.getJndiConnectionFactoryName());
        }
        if (connectionFactory == null && this.endpoint.getConfiguration().getConnectionFactory() != null) {
            connectionFactory = this.endpoint.getConfiguration().getConnectionFactory();
        }
        if (connectionFactory == null && this.endpoint.getConfiguration().getJndiConnectionFactoryName() != null) {
            connectionFactory = (ConnectionFactory)ctx.lookup(this.endpoint.getConfiguration().getJndiConnectionFactoryName());
        }
        return connectionFactory;
    }

    protected InitialContext getInitialContext() throws NamingException {
        Properties props = new Properties();
        if (this.endpoint.getInitialContextFactory() != null && this.endpoint.getJndiProviderURL() != null) {
            props.put("java.naming.factory.initial", this.endpoint.getInitialContextFactory());
            props.put("java.naming.provider.url", this.endpoint.getJndiProviderURL());
            return new InitialContext(props);
        }
        if (this.endpoint.getConfiguration().getJndiInitialContextFactory() != null && this.endpoint.getConfiguration().getJndiProviderUrl() != null) {
            props.put("java.naming.factory.initial", this.endpoint.getConfiguration().getJndiInitialContextFactory());
            props.put("java.naming.provider.url", this.endpoint.getConfiguration().getJndiProviderUrl());
            return new InitialContext(props);
        }
        BaseLifeCycle lf = (BaseLifeCycle)this.endpoint.getServiceUnit().getComponent().getLifeCycle();
        return lf.getContext().getNamingContext();
    }

    protected Store getStore() {
        return this.store;
    }

    protected void doStart(InitialContext ctx) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        try {
            this.doStop();
            if (this.connection != null) {
                this.connection.close();
            }
        }
        finally {
            this.connection = null;
        }
    }

    protected void doStop() throws Exception {
    }

    protected Context createContext() {
        return this.soapHelper.createContext();
    }

    protected Message fromNMS(NormalizedMessage nm, Session mySession) throws Exception {
        SoapMessage soap = new SoapMessage();
        this.soapHelper.getJBIMarshaler().fromNMS(soap, nm);
        Map headers = (Map)nm.getProperty("javax.jbi.messaging.protocol.headers");
        return this.endpoint.getMarshaler().toJMS(soap, headers, mySession);
    }

    protected MessageExchange toNMS(Message message, Context ctx) throws Exception {
        SoapMessage soap = this.endpoint.getMarshaler().toSOAP(message);
        ctx.setInMessage(soap);
        ctx.setProperty(Message.class.getName(), (Object)message);
        MessageExchange exchange = this.soapHelper.onReceive(ctx);
        return exchange;
    }

    protected Message fromNMSResponse(MessageExchange exchange, Context ctx, Session mySession) throws Exception {
        Message response = null;
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            Exception e = exchange.getError();
            if (e == null) {
                e = new Exception("Unkown error");
            }
            response = this.endpoint.getMarshaler().toJMS(e, mySession);
        } else if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            Fault jbiFault = exchange.getFault();
            if (jbiFault != null) {
                SoapFault fault = new SoapFault(SoapFault.RECEIVER, null, null, null, jbiFault.getContent());
                SoapMessage soapFault = this.soapHelper.onFault(ctx, fault);
                Map headers = (Map)jbiFault.getProperty("javax.jbi.messaging.protocol.headers");
                response = this.endpoint.getMarshaler().toJMS(soapFault, headers, mySession);
            } else {
                NormalizedMessage outMsg = exchange.getMessage("out");
                if (outMsg != null) {
                    SoapMessage out = this.soapHelper.onReply(ctx, outMsg);
                    Map headers = (Map)outMsg.getProperty("javax.jbi.messaging.protocol.headers");
                    response = this.endpoint.getMarshaler().toJMS(out, headers, mySession);
                }
            }
        }
        return response;
    }

    protected Message createMessageFromExchange(Session mySession, MessageExchange exchange) throws Exception {
        NormalizedMessage nm = exchange.getMessage("in");
        Message msg = this.fromNMS(nm, mySession);
        String soapAction = "";
        if (exchange.getOperation() != null) {
            String interFaceName = exchange.getInterfaceName() == null ? "" : exchange.getInterfaceName().getNamespaceURI() + "/" + exchange.getInterfaceName().getLocalPart();
            soapAction = interFaceName + "/" + exchange.getOperation();
        }
        msg.setStringProperty("SoapAction", soapAction);
        msg.setStringProperty("SOAPJMS_soapAction", soapAction);
        return msg;
    }
}

