/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import org.apache.servicemix.jbi.security.auth.AuthenticationService;
import org.apache.servicemix.jbi.security.keystore.KeystoreManager;
import org.apache.servicemix.jms.JmsConfigurationMBean;

public class JmsConfiguration
implements JmsConfigurationMBean {
    public static final String CONFIG_FILE = "component.properties";
    private String rootDir;
    private String componentName = "servicemix-jms";
    private Properties properties = new Properties();
    private String userName;
    private String password;
    private String jndiInitialContextFactory;
    private String jndiProviderUrl;
    private String jndiConnectionFactoryName;
    private String processorName = "multiplexing";
    private transient ConnectionFactory connectionFactory;
    private transient KeystoreManager keystoreManager;
    private transient AuthenticationService authenticationService;
    private String authenticationServiceName = "java:comp/env/smx/AuthenticationService";
    private String keystoreManagerName = "java:comp/env/smx/KeystoreManager";

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public String getAuthenticationServiceName() {
        return this.authenticationServiceName;
    }

    public void setAuthenticationServiceName(String authenticationServiceName) {
        this.authenticationServiceName = authenticationServiceName;
    }

    public KeystoreManager getKeystoreManager() {
        return this.keystoreManager;
    }

    public void setKeystoreManager(KeystoreManager keystoreManager) {
        this.keystoreManager = keystoreManager;
    }

    public String getKeystoreManagerName() {
        return this.keystoreManagerName;
    }

    public void setKeystoreManagerName(String keystoreManagerName) {
        this.keystoreManagerName = keystoreManagerName;
        this.save();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.save();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.save();
    }

    public String getJndiConnectionFactoryName() {
        return this.jndiConnectionFactoryName;
    }

    public void setJndiConnectionFactoryName(String jndiName) {
        this.jndiConnectionFactoryName = jndiName;
        this.save();
    }

    public String getJndiInitialContextFactory() {
        return this.jndiInitialContextFactory;
    }

    public void setJndiInitialContextFactory(String jndiInitialContextFactory) {
        this.jndiInitialContextFactory = jndiInitialContextFactory;
        this.save();
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
        this.save();
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public void setProcessorName(String processorName) {
        this.processorName = processorName;
        this.save();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void save() {
        this.setProperty(this.componentName + ".userName", this.userName);
        this.setProperty(this.componentName + ".password", this.password);
        this.setProperty(this.componentName + ".jndiInitialContextFactory", this.jndiInitialContextFactory);
        this.setProperty(this.componentName + ".jndiProviderUrl", this.jndiProviderUrl);
        this.setProperty(this.componentName + ".jndiName", this.jndiConnectionFactoryName);
        this.setProperty(this.componentName + ".processorName", this.processorName);
        this.setProperty(this.componentName + ".keystoreManagerName", this.keystoreManagerName);
        this.setProperty(this.componentName + ".authenticationServiceName", this.authenticationServiceName);
        if (this.rootDir != null) {
            File f = new File(this.rootDir, CONFIG_FILE);
            try {
                this.properties.store(new FileOutputStream(f), null);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not store component configuration", e);
            }
        }
    }

    protected void setProperty(String name, String value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.setProperty(name, value);
        }
    }

    public boolean load() {
        File f = null;
        InputStream in = null;
        if (this.rootDir != null && !(f = new File(this.rootDir, CONFIG_FILE)).exists()) {
            f = null;
        }
        if (f == null && (in = this.getClass().getClassLoader().getResourceAsStream(CONFIG_FILE)) == null) {
            return false;
        }
        try {
            if (f != null) {
                this.properties.load(new FileInputStream(f));
            } else {
                this.properties.load(in);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load component configuration", e);
        }
        if (this.properties.getProperty(this.componentName + ".userName") != null) {
            this.userName = this.properties.getProperty("userName");
        }
        if (this.properties.getProperty(this.componentName + ".password") != null) {
            this.password = this.properties.getProperty("password");
        }
        if (this.properties.getProperty(this.componentName + ".jndiInitialContextFactory") != null) {
            this.jndiInitialContextFactory = this.properties.getProperty("jndiInitialContextFactory");
        }
        if (this.properties.getProperty(this.componentName + ".jndiProviderUrl") != null) {
            this.jndiProviderUrl = this.properties.getProperty("jndiProviderUrl");
        }
        if (this.properties.getProperty(this.componentName + ".jndiName") != null) {
            this.jndiConnectionFactoryName = this.properties.getProperty("jndiName");
        }
        if (this.properties.getProperty(this.componentName + ".processorName") != null) {
            this.processorName = this.properties.getProperty("processorName");
        }
        if (this.properties.getProperty(this.componentName + ".keystoreManagerName") != null) {
            this.keystoreManagerName = this.properties.getProperty("keystoreManagerName");
        }
        if (this.properties.getProperty(this.componentName + ".authenticationServiceName") != null) {
            this.authenticationServiceName = this.properties.getProperty("authenticationServiceName");
        }
        return true;
    }
}

