/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import javax.resource.ResourceException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.TxUtil;

public class TransactionEnlistingInterceptor
implements ConnectionInterceptor {
    private final ConnectionInterceptor next;
    private final TransactionManager transactionManager;

    public TransactionEnlistingInterceptor(ConnectionInterceptor next, TransactionManager transactionManager) {
        this.next = next;
        this.transactionManager = transactionManager;
    }

    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        this.next.getConnection(connectionInfo);
        try {
            ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
            Transaction transaction = TxUtil.getTransactionIfActive(this.transactionManager);
            if (transaction != null) {
                XAResource xares = mci.getXAResource();
                transaction.enlistResource(xares);
            }
        }
        catch (SystemException e) {
            this.returnConnection(connectionInfo, ConnectionReturnAction.DESTROY);
            throw new ResourceException("Could not get transaction", (Throwable)e);
        }
        catch (RollbackException e) {
            this.next.returnConnection(connectionInfo, ConnectionReturnAction.RETURN_HANDLE);
            throw new ResourceException("Could not enlist resource in rolled back transaction", (Throwable)e);
        }
        catch (Throwable t) {
            this.returnConnection(connectionInfo, ConnectionReturnAction.DESTROY);
            throw new ResourceException("Unknown throwable when trying to enlist connection in tx", t);
        }
    }

    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        try {
            ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
            Transaction transaction = TxUtil.getTransactionIfActive(this.transactionManager);
            if (transaction != null) {
                XAResource xares = mci.getXAResource();
                transaction.delistResource(xares, 0x2000000);
            }
        }
        catch (SystemException e) {
            connectionReturnAction = ConnectionReturnAction.DESTROY;
        }
        catch (IllegalStateException e) {
            connectionReturnAction = ConnectionReturnAction.DESTROY;
        }
        this.next.returnConnection(connectionInfo, connectionReturnAction);
    }

    public void destroy() {
        this.next.destroy();
    }
}

