/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.endpoints;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.namespace.QName;
import org.apache.servicemix.jms.endpoints.JmsConsumerMarshaler;
import org.apache.servicemix.soap.api.InterceptorChain;
import org.apache.servicemix.soap.api.InterceptorProvider;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.api.Policy;
import org.apache.servicemix.soap.api.model.Binding;
import org.apache.servicemix.soap.bindings.soap.SoapFault;
import org.apache.servicemix.soap.bindings.soap.SoapVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsSoapConsumerMarshaler
implements JmsConsumerMarshaler {
    private Binding<?> binding;
    private boolean useJbiWrapper = true;
    private Policy[] policies;
    private boolean rollbackOnError = true;

    public Binding<?> getBinding() {
        return this.binding;
    }

    public void setBinding(Binding<?> binding) {
        this.binding = binding;
    }

    public Policy[] getPolicies() {
        return this.policies;
    }

    public void setPolicies(Policy[] policies) {
        this.policies = policies;
    }

    public boolean isUseJbiWrapper() {
        return this.useJbiWrapper;
    }

    public void setUseJbiWrapper(boolean useJbiWrapper) {
        this.useJbiWrapper = useJbiWrapper;
    }

    public boolean isRollbackOnError() {
        return this.rollbackOnError;
    }

    public void setRollbackOnError(boolean rollbackOnError) {
        this.rollbackOnError = rollbackOnError;
    }

    @Override
    public JmsConsumerMarshaler.JmsContext createContext(javax.jms.Message message) throws Exception {
        return new Context(message);
    }

    @Override
    public MessageExchange createExchange(JmsConsumerMarshaler.JmsContext jmsContext, ComponentContext jbiContext) throws Exception {
        Message msg;
        ((Context)jmsContext).msg = msg = this.binding.createMessage();
        msg.put(ComponentContext.class, (Object)jbiContext);
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        msg.setContent(InputStream.class, (Object)new ByteArrayInputStream(((TextMessage)jmsContext.getMessage()).getText().getBytes()));
        InterceptorChain phase = this.getChain(InterceptorProvider.Phase.ServerIn);
        phase.doIntercept(msg);
        return (MessageExchange)msg.getContent(MessageExchange.class);
    }

    @Override
    public javax.jms.Message createOut(MessageExchange exchange, NormalizedMessage outMsg, Session session, JmsConsumerMarshaler.JmsContext context) throws Exception {
        Message in = ((Context)context).msg;
        Message msg = this.binding.createMessage(in);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        msg.setContent(OutputStream.class, (Object)baos);
        msg.setContent(MessageExchange.class, (Object)exchange);
        msg.setContent(NormalizedMessage.class, (Object)outMsg);
        msg.put(SoapVersion.class, in.get(SoapVersion.class));
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        InterceptorChain phase = this.getChain(InterceptorProvider.Phase.ServerOut);
        phase.doIntercept(msg);
        return session.createTextMessage(baos.toString());
    }

    @Override
    public javax.jms.Message createFault(MessageExchange exchange, Fault fault, Session session, JmsConsumerMarshaler.JmsContext context) throws Exception {
        Message in = ((Context)context).msg;
        Message msg = this.binding.createMessage(in);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        msg.setContent(OutputStream.class, (Object)baos);
        msg.setContent(MessageExchange.class, (Object)exchange);
        msg.setContent(NormalizedMessage.class, (Object)fault);
        msg.put(SoapVersion.class, in.get(SoapVersion.class));
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        InterceptorChain phase = this.getChain(InterceptorProvider.Phase.ServerOutFault);
        QName code = (QName)fault.getProperty("org.apache.servicemix.soap.fault.code");
        String reason = (String)fault.getProperty("org.apache.servicemix.soap.fault.reason");
        SoapFault soapFault = new SoapFault(code, reason, null, null, fault.getContent());
        msg.setContent(Exception.class, (Object)soapFault);
        phase.doIntercept(msg);
        return session.createTextMessage(baos.toString());
    }

    @Override
    public javax.jms.Message createError(MessageExchange exchange, Exception error, Session session, JmsConsumerMarshaler.JmsContext context) throws Exception {
        if (this.rollbackOnError) {
            throw error;
        }
        Message in = ((Context)context).msg;
        Message msg = this.binding.createMessage(in);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        msg.setContent(OutputStream.class, (Object)baos);
        msg.setContent(MessageExchange.class, (Object)exchange);
        msg.put(SoapVersion.class, in.get(SoapVersion.class));
        msg.put((Object)"useJbiWrapper", (Object)this.useJbiWrapper);
        InterceptorChain phase = this.getChain(InterceptorProvider.Phase.ServerOutFault);
        SoapFault soapFault = error instanceof SoapFault ? (SoapFault)error : new SoapFault(error);
        msg.setContent(Exception.class, (Object)soapFault);
        phase.doIntercept(msg);
        return session.createTextMessage(baos.toString());
    }

    protected InterceptorChain getChain(InterceptorProvider.Phase phase) {
        InterceptorChain chain = this.binding.getInterceptorChain(phase);
        if (this.policies != null) {
            for (int i = 0; i < this.policies.length; ++i) {
                chain.add((Iterable)this.policies[i].getInterceptors(phase));
            }
        }
        return chain;
    }

    protected static class Context
    implements JmsConsumerMarshaler.JmsContext,
    Serializable {
        javax.jms.Message message;
        Message msg;

        Context(javax.jms.Message message) {
            this.message = message;
        }

        public javax.jms.Message getMessage() {
            return this.message;
        }
    }
}

