/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jms.standard;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.apache.servicemix.jms.AbstractJmsProcessor;
import org.apache.servicemix.jms.JmsEndpoint;
import org.apache.servicemix.soap.Context;

public class StandardConsumerProcessor
extends AbstractJmsProcessor {
    protected Session session;
    protected Destination destination;
    protected AtomicBoolean running = new AtomicBoolean(false);

    public StandardConsumerProcessor(JmsEndpoint endpoint) throws Exception {
        super(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart(InitialContext ctx) throws Exception {
        this.destination = this.endpoint.getDestination();
        if (this.destination == null) {
            if (this.endpoint.getJndiDestinationName() != null) {
                this.destination = (Destination)ctx.lookup(this.endpoint.getJndiDestinationName());
            } else if (this.endpoint.getJmsProviderDestinationName() == null) {
                throw new IllegalStateException("No destination provided");
            }
        }
        AtomicBoolean atomicBoolean = this.running;
        synchronized (atomicBoolean) {
            this.endpoint.getServiceUnit().getComponent().getExecutor().execute(new Runnable(){

                public void run() {
                    StandardConsumerProcessor.this.poll();
                }
            });
            this.running.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        if (this.running.get()) {
            AtomicBoolean atomicBoolean = this.running;
            synchronized (atomicBoolean) {
                if (this.session != null) {
                    this.session.close();
                }
                this.running.wait();
            }
        }
        this.session = null;
        this.destination = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() {
        AtomicBoolean atomicBoolean = this.running;
        synchronized (atomicBoolean) {
            this.running.set(true);
            this.running.notify();
        }
        try {
            this.session = this.connection.createSession(false, 1);
            if (this.destination == null) {
                this.destination = "queue".equals(this.endpoint.getDestinationStyle()) ? this.session.createQueue(this.endpoint.getJmsProviderDestinationName()) : this.session.createTopic(this.endpoint.getJmsProviderDestinationName());
            }
            MessageConsumer consumer = this.session.createConsumer(this.destination);
            while (this.running.get()) {
                Message message = consumer.receive(1000L);
                if (message == null) continue;
                this.onMessage(message);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
        }
        finally {
            AtomicBoolean atomicBoolean2 = this.running;
            synchronized (atomicBoolean2) {
                this.running.set(false);
                this.running.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            Context context;
            MessageExchange exchange;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received jms message " + message));
            }
            if (!this.channel.sendSync(exchange = this.toNMS(message, context = this.createContext()))) {
                throw new IllegalStateException("Exchange has been aborted");
            }
            MessageProducer producer = null;
            Message response = null;
            try {
                response = this.fromNMSResponse(exchange, context, this.session);
                if (response != null) {
                    producer = this.session.createProducer(message.getJMSReplyTo());
                    if (this.endpoint.isUseMsgIdInResponse()) {
                        response.setJMSCorrelationID(message.getJMSMessageID());
                    } else {
                        response.setJMSCorrelationID(message.getJMSCorrelationID());
                    }
                    producer.send(response);
                }
            }
            finally {
                if (producer != null) {
                    producer.close();
                }
                if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                    exchange.setStatus(ExchangeStatus.DONE);
                    this.channel.send(exchange);
                }
            }
        }
        catch (Throwable e) {
            this.log.error((Object)"Error while handling jms message", e);
        }
    }

    public void process(MessageExchange exchange) throws Exception {
        throw new IllegalStateException();
    }
}

