/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.AbstractContext;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.Visitable;
import org.codehaus.xfire.service.Visitor;

public class ServiceInfo
extends AbstractContext
implements Visitable {
    private Map operations = new HashMap();
    private Map methodToOp = new HashMap();
    private Class serviceClass;
    private QName portType;
    private boolean wrapped;
    private Service service;
    private String documentation;

    public ServiceInfo(QName portType, Class serviceClass) {
        this.portType = portType;
        this.serviceClass = serviceClass;
    }

    public void accept(Visitor visitor) {
        visitor.startService(this);
        Iterator iterator = this.operations.values().iterator();
        while (iterator.hasNext()) {
            OperationInfo operationInfo = (OperationInfo)iterator.next();
            operationInfo.accept(visitor);
        }
        visitor.endService(this);
    }

    public OperationInfo addOperation(String name, Method method) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid name [" + name + "]");
        }
        return this.addOperation(new QName(name), method);
    }

    public OperationInfo addOperation(QName name, Method method) {
        if (name == null) {
            throw new IllegalArgumentException("Invalid name [" + name + "]");
        }
        if (this.operations.containsKey(name)) {
            throw new IllegalArgumentException("An operation with name [" + name + "] already exists in this service");
        }
        OperationInfo operation = new OperationInfo(name, method, this);
        this.addOperation(operation);
        return operation;
    }

    void addOperation(OperationInfo operation) {
        this.operations.put(operation.getName(), operation);
        this.methodToOp.put(operation.getMethod(), operation);
    }

    public OperationInfo getOperation(String name) {
        return (OperationInfo)this.operations.get(name);
    }

    public OperationInfo getOperation(Method m) {
        return (OperationInfo)this.methodToOp.get(m);
    }

    public Collection getOperations() {
        return Collections.unmodifiableCollection(this.operations.values());
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void removeOperation(String name) {
        this.operations.remove(name);
    }

    public void removeOperation(QName name) {
        this.operations.remove(name);
    }

    public QName getPortType() {
        return this.portType;
    }

    public void setPortType(QName portType) {
        this.portType = portType;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }
}

