/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jsr181;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import org.apache.servicemix.common.EndpointDeliveryChannel;
import org.apache.servicemix.common.ManagementSupport;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.common.tools.wsdl.WSDLFlattener;
import org.apache.servicemix.jbi.api.Container;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jsr181.JBIContext;
import org.apache.servicemix.jsr181.Jsr181Component;
import org.apache.servicemix.jsr181.xfire.JbiFaultSerializer;
import org.apache.servicemix.jsr181.xfire.ServiceFactoryHelper;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.attachments.Attachment;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.JavaMailAttachments;
import org.codehaus.xfire.attachments.SimpleAttachment;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.service.invoker.BeanInvoker;
import org.codehaus.xfire.service.invoker.Invoker;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Transport;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Jsr181Endpoint
extends ProviderEndpoint {
    public static final String SOAP_FAULT_CODE = "org.apache.servicemix.soap.fault.code";
    public static final String SOAP_FAULT_SUBCODE = "org.apache.servicemix.soap.fault.subcode";
    public static final String SOAP_FAULT_REASON = "org.apache.servicemix.soap.fault.reason";
    public static final String SOAP_FAULT_NODE = "org.apache.servicemix.soap.fault.node";
    public static final String SOAP_FAULT_ROLE = "org.apache.servicemix.soap.fault.role";
    protected Object pojo;
    protected String pojoClass;
    protected String annotations;
    protected String typeMapping;
    protected String serviceInterface;
    protected String style = "wrapped";
    protected Service xfireService;
    protected Resource wsdlResource;
    protected boolean mtomEnabled;
    protected Map properties;
    protected SourceTransformer transformer = new SourceTransformer();
    private Boolean validationEnabled;

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public Resource getWsdlResource() {
        return this.wsdlResource;
    }

    public void setWsdlResource(Resource wsdlResource) {
        this.wsdlResource = wsdlResource;
    }

    public Object getPojo() {
        return this.pojo;
    }

    public void setPojo(Object pojo) {
        this.pojo = pojo;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public Boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(Boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public Service getXFireService() {
        return this.xfireService;
    }

    public void start() throws Exception {
        super.start();
        this.injectPojo(this.getContext(), this.getContainer());
    }

    public void stop() throws Exception {
        this.injectPojo(null, null);
        super.stop();
    }

    protected void injectPojo(ComponentContext context, Container container) {
        Method mth;
        try {
            mth = this.pojo.getClass().getMethod("setContext", ComponentContext.class);
            mth.invoke(this.pojo, context);
        }
        catch (Exception e) {
            logger.debug("Unable to inject ComponentContext: {}", (Object)e.getMessage());
        }
        try {
            mth = this.pojo.getClass().getMethod("setContainer", Container.class);
            mth.invoke(this.pojo, container);
        }
        catch (Exception e) {
            logger.debug("Unable to inject JBIContainer: {}", (Object)e.getMessage());
        }
    }

    protected Container getContainer() {
        try {
            ComponentContext ctx = this.getServiceUnit().getComponent().getComponentContext();
            Field field = ctx.getClass().getDeclaredField("container");
            field.setAccessible(true);
            return (Container)field.get(ctx);
        }
        catch (Exception e) {
            logger.debug("Unable to retrieve JBIContainer: {}", (Object)e.getMessage());
            return null;
        }
    }

    public void validate() throws DeploymentException {
        try {
            this.registerService();
        }
        catch (Exception e) {
            throw ManagementSupport.failure((String)"deploy", (String)this.getServiceUnit().getComponent().getComponentName(), null, (Throwable)e);
        }
    }

    public void registerService() throws Exception {
        String svcLocalName;
        if (this.pojo == null) {
            if (this.pojoClass == null) {
                throw new IllegalArgumentException("Endpoint must have a non-null pojo or a pojoClass");
            }
            Class<?> cl = Class.forName(this.pojoClass, true, this.getServiceUnit().getConfigurationClassLoader());
            this.pojo = cl.newInstance();
        }
        XFire xfire = this.getXFire();
        ObjectServiceFactory factory = ServiceFactoryHelper.findServiceFactory(xfire, this.pojo.getClass(), this.annotations, this.typeMapping);
        Class<?> serviceClass = this.pojo.getClass();
        if (this.serviceInterface != null) {
            serviceClass = Class.forName(this.serviceInterface, true, this.getServiceUnit().getConfigurationClassLoader());
        }
        this.definition = this.loadDefinition();
        if (this.definition != null) {
            this.updateDescription();
        }
        String string = svcLocalName = this.service != null ? this.service.getLocalPart() : null;
        String svcNamespace = this.interfaceName != null ? this.interfaceName.getNamespaceURI() : (this.service != null ? this.service.getNamespaceURI() : null);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("objectServiceFactory.portType", this.interfaceName);
        if (this.style != null) {
            props.put("objectServiceFactory.style", this.style);
        }
        props.put("objectServiceFactory.use", "literal");
        if (this.serviceInterface != null) {
            props.put("annotations.allow.interface", Boolean.TRUE);
        }
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        this.xfireService = factory.create(serviceClass, svcLocalName, svcNamespace, props);
        this.xfireService.setInvoker((Invoker)new BeanInvoker(this.getPojo()));
        this.xfireService.setFaultSerializer((MessageSerializer)new JbiFaultSerializer());
        this.xfireService.setProperty("mtom-enabled", (Object)Boolean.toString(this.mtomEnabled));
        if (this.validationEnabled != null) {
            if ("jaxb2".equals(this.typeMapping)) {
                this.xfireService.setProperty("jaxb.validation.enabled", (Object)this.validationEnabled.toString());
            } else {
                throw new IllegalArgumentException("Currently you can controll validation only for jaxb2 mapping. " + this.typeMapping + " is not supported.");
            }
        }
        xfire.getServiceRegistry().register(this.xfireService);
        if (this.description == null) {
            this.createDescription();
        }
    }

    protected void createDescription() throws SAXException, IOException, ParserConfigurationException, WSDLException, Exception {
        this.description = this.generateWsdl();
        QName serviceName = this.xfireService.getName();
        QName interfName = this.xfireService.getServiceInfo().getPortType();
        String endpointName = null;
        if (this.service == null) {
            this.service = serviceName;
        } else if (!this.service.equals(serviceName)) {
            logger.warn("The service name defined in the wsdl ({}) does not match the service name defined in the endpoint spec ({}). WSDL description may be unusable.", (Object)serviceName, (Object)this.service);
        }
        if (this.interfaceName == null) {
            this.interfaceName = interfName;
        } else if (!this.interfaceName.equals(interfName)) {
            logger.warn("The interface name defined in the wsdl ({}) does not match the service name defined in the endpoint spec ({}). WSDL description may be unusable.", (Object)interfName, (Object)this.interfaceName);
        }
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        this.definition = reader.readWSDL(null, this.description);
        javax.wsdl.Service svc = this.definition.getService(serviceName);
        if (svc != null && svc.getPorts().values().size() == 1) {
            Port port = (Port)svc.getPorts().values().iterator().next();
            endpointName = port.getName();
            if (this.endpoint == null) {
                this.endpoint = endpointName;
            } else if (!this.endpoint.equals(endpointName)) {
                port.setName(this.endpoint);
                this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
            }
        }
        if (this.endpoint == null) {
            throw new IllegalArgumentException("endpoint name should be provided");
        }
        this.definition = new WSDLFlattener(this.definition).getDefinition(this.interfaceName);
        this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WSDLFactory.newInstance().newWSDLWriter().writeWSDL(this.definition, (OutputStream)baos);
        logger.debug("{}", (Object)baos.toString());
    }

    protected void updateDescription() throws Exception {
        if (this.definition.getServices().size() != 1) {
            throw new IllegalArgumentException("The deployed wsdl defines more than one service");
        }
        javax.wsdl.Service wsdlSvc = (javax.wsdl.Service)this.definition.getServices().values().iterator().next();
        if (this.service == null) {
            this.service = wsdlSvc.getQName();
        } else if (!this.service.equals(wsdlSvc.getQName())) {
            throw new IllegalArgumentException("The name of the Service defined by the deployed wsdl does not match the service name of the jbi endpoint");
        }
        if (wsdlSvc.getPorts().size() != 1) {
            throw new IllegalArgumentException("The Service defined in the deployed wsdl must define exactly one Port");
        }
        Port wsdlPort = (Port)wsdlSvc.getPorts().values().iterator().next();
        if (this.endpoint == null) {
            this.endpoint = wsdlPort.getName();
        } else if (!this.endpoint.equals(wsdlPort.getName())) {
            throw new IllegalArgumentException("The name of the Port defined by the deployed wsdl does not match the endpoint name of the jbi endpoint");
        }
        Binding wsdlBinding = wsdlPort.getBinding();
        if (wsdlBinding == null) {
            throw new IllegalArgumentException("The Port defined in the deployed wsdl does not have any binding");
        }
        PortType wsdlPortType = wsdlBinding.getPortType();
        if (wsdlPortType == null) {
            throw new IllegalArgumentException("The Binding defined in the deployed wsdl does not have reference a PortType");
        }
        if (this.interfaceName == null) {
            this.interfaceName = wsdlPortType.getQName();
        } else if (!this.interfaceName.equals(wsdlPortType.getQName())) {
            throw new IllegalArgumentException("The name of the PortType defined by the deployed wsdl does not match the interface name of the jbi endpoint");
        }
        this.definition = new WSDLFlattener(this.definition).getDefinition(this.interfaceName);
        this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
    }

    protected Definition loadDefinition() throws IOException, WSDLException {
        if (this.wsdlResource != null) {
            URL resource = this.wsdlResource.getURL();
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            return reader.readWSDL(null, resource.toString());
        }
        return null;
    }

    protected Document generateWsdl() throws SAXException, IOException, ParserConfigurationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.getXFire().generateWSDL(this.xfireService.getSimpleName(), (OutputStream)baos);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(new ByteArrayInputStream(baos.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        OperationInfo op;
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        XFire xfire = this.getXFire();
        Service service = this.getXFireService();
        Transport t = xfire.getTransportManager().getTransport("http://java.sun.com/xml/ns/jbi/binding/service+engine");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Channel c = t.createChannel();
        MessageContext ctx = new MessageContext();
        ctx.setXFire(xfire);
        ctx.setService(service);
        ctx.setProperty("urn:xfire:channel:backchannel", (Object)out);
        ctx.setExchange(new org.codehaus.xfire.exchange.MessageExchange(ctx));
        InMessage msg = new InMessage();
        ctx.getExchange().setInMessage(msg);
        if (exchange.getOperation() != null && (op = service.getServiceInfo().getOperation(exchange.getOperation().getLocalPart())) != null) {
            ctx.getExchange().setOperation(op);
        }
        ctx.setCurrentMessage((AbstractMessage)msg);
        NormalizedMessage in = exchange.getMessage("in");
        msg.setXMLStreamReader(this.transformer.toXMLStreamReader(in.getContent()));
        if (in.getAttachmentNames() != null && in.getAttachmentNames().size() > 0) {
            JavaMailAttachments attachments = new JavaMailAttachments();
            for (String name : in.getAttachmentNames()) {
                DataHandler dh = in.getAttachment(name);
                attachments.addPart((Attachment)new SimpleAttachment(name, dh));
            }
            msg.setAttachments((Attachments)attachments);
        }
        JBIContext.setMessageExchange(exchange);
        try {
            c.receive(ctx, msg);
        }
        finally {
            EndpointDeliveryChannel.setEndpoint(null);
        }
        c.close();
        if (exchange instanceof InOut || exchange instanceof InOptionalOut) {
            String charSet;
            if (ctx.getExchange().hasFaultMessage() && ctx.getExchange().getFaultMessage().getBody() != null) {
                charSet = ctx.getExchange().getFaultMessage().getEncoding();
                Fault fault = exchange.getFault();
                if (fault == null) {
                    fault = exchange.createFault();
                    exchange.setFault(fault);
                }
                fault.setContent((Source)new StringSource(out.toString(charSet)));
                XFireFault xFault = (XFireFault)ctx.getExchange().getFaultMessage().getBody();
                fault.setProperty(SOAP_FAULT_CODE, (Object)xFault.getFaultCode());
                fault.setProperty(SOAP_FAULT_REASON, (Object)xFault.getReason());
                fault.setProperty(SOAP_FAULT_ROLE, (Object)xFault.getRole());
                fault.setProperty(SOAP_FAULT_SUBCODE, (Object)xFault.getSubCode());
            } else {
                Attachments attachments;
                charSet = ctx.getOutMessage().getEncoding();
                NormalizedMessage outMsg = exchange.getMessage("out");
                if (outMsg == null) {
                    outMsg = exchange.createMessage();
                    exchange.setMessage(outMsg, "out");
                }
                if ((attachments = ctx.getCurrentMessage().getAttachments()) != null) {
                    Iterator it = attachments.getParts();
                    while (it.hasNext()) {
                        Attachment att = (Attachment)it.next();
                        outMsg.addAttachment(att.getId(), att.getDataHandler());
                    }
                }
                outMsg.setContent((Source)new StringSource(out.toString(charSet)));
            }
            if (exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"))) {
                this.sendSync(exchange);
            } else {
                this.send(exchange);
            }
        } else {
            this.done(exchange);
        }
    }

    public XFire getXFire() {
        Jsr181Component component = (Jsr181Component)this.serviceUnit.getComponent();
        return component.getXFire();
    }

    public String getPojoClass() {
        return this.pojoClass;
    }

    public void setPojoClass(String pojoClass) {
        this.pojoClass = pojoClass;
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(String annotations) {
        this.annotations = annotations;
    }

    public String getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(String typeMapping) {
        this.typeMapping = typeMapping;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }
}

