/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class InterfaceInvocationHandler
implements InvocationHandler {
    private Map attributes = new HashMap();

    InterfaceInvocationHandler() {
    }

    public void writeProperty(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object readProperty(Object key) {
        return this.attributes.get(key);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.getMethod("hashCode", null).equals(method)) {
            return this.proxyHashCode(proxy);
        }
        Class clazz = Object.class;
        Class[] classArray = new Class[1];
        Class clazz2 = classArray[0] = Object.class;
        if (clazz.getMethod("equals", classArray).equals(method)) {
            return this.proxyEquals(proxy, args[0]);
        }
        if (Object.class.getMethod("toString", null).equals(method)) {
            return this.proxyToString(proxy);
        }
        if (this.isGetterMethod(method, args)) {
            return this.doGetter(method, args);
        }
        if (this.isSetterMethod(method, args)) {
            return this.doSetter(method, args);
        }
        throw new IllegalAccessError(method.getName() + " is not delegated.");
    }

    protected boolean isGetterMethod(Method method, Object[] args) {
        if (args != null && args.length > 0) {
            return false;
        }
        String methodName = method.getName();
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return true;
        }
        return methodName.startsWith("is") && methodName.length() > 2;
    }

    protected boolean isSetterMethod(Method method, Object[] args) {
        if (args == null || args.length != 1) {
            return false;
        }
        if (!"void".equals(method.getReturnType().getName())) {
            return false;
        }
        String methodName = method.getName();
        return methodName.startsWith("set") && methodName.length() > 3;
    }

    protected Object doGetter(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        String attrName = null;
        if (methodName.startsWith("get")) {
            attrName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        } else if (methodName.startsWith("is")) {
            attrName = Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
        } else {
            throw new IllegalAccessError(methodName + " is not a valid getter method.");
        }
        return this.readProperty(attrName);
    }

    protected Object doSetter(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        String attrName = null;
        if (!methodName.startsWith("set")) {
            throw new IllegalAccessError(methodName + " is not a valid setter method.");
        }
        attrName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        this.writeProperty(attrName, args[0]);
        return null;
    }

    protected Integer proxyHashCode(Object proxy) {
        return new Integer(System.identityHashCode(proxy));
    }

    protected Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object proxy) {
        return proxy.getClass().getName() + '@' + proxy.hashCode();
    }
}

