/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jsr181;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.common.xbean.XBeanServiceUnit;
import org.apache.servicemix.jsr181.EndpointComponentContext;
import org.apache.servicemix.jsr181.Jsr181Configuration;
import org.apache.servicemix.jsr181.Jsr181ConfigurationMBean;
import org.apache.servicemix.jsr181.Jsr181ExchangeProcessor;
import org.apache.servicemix.jsr181.Jsr181LifeCycle;
import org.apache.servicemix.jsr181.xfire.JbiFaultSerializer;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.DefaultTypeMappingRegistry;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.annotations.commons.CommonsWebAttributes;
import org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.service.invoker.BeanInvoker;
import org.codehaus.xfire.service.invoker.Invoker;
import org.codehaus.xfire.xmlbeans.XmlBeansTypeRegistry;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Jsr181Endpoint
extends Endpoint {
    private static final Map knownTypeMappings;
    private static final Map knownAnnotations;
    protected Object pojo;
    protected String pojoClass;
    protected String annotations;
    protected String typeMapping;
    protected String serviceInterface;
    protected ServiceEndpoint activated;
    protected Service xfireService;
    protected ExchangeProcessor processor = new Jsr181ExchangeProcessor(this);
    protected Resource wsdlResource;
    static /* synthetic */ Class class$javax$jbi$component$ComponentContext;
    static /* synthetic */ Class class$org$codehaus$xfire$transport$TransportManager;

    public Resource getWsdlResource() {
        return this.wsdlResource;
    }

    public void setWsdlResource(Resource wsdlResource) {
        this.wsdlResource = wsdlResource;
    }

    public Object getPojo() {
        return this.pojo;
    }

    public void setPojo(Object pojo) {
        this.pojo = pojo;
    }

    public Service getXFireService() {
        return this.xfireService;
    }

    public MessageExchange.Role getRole() {
        return MessageExchange.Role.PROVIDER;
    }

    public void activate() throws Exception {
        this.logger = this.serviceUnit.getComponent().getLogger();
        ComponentContext ctx = this.serviceUnit.getComponent().getComponentContext();
        this.activated = ctx.activateEndpoint(this.service, this.endpoint);
        this.injectContext(new EndpointComponentContext(ctx, this));
        this.processor.start();
    }

    public void deactivate() throws Exception {
        ServiceEndpoint ep = this.activated;
        this.activated = null;
        this.processor.stop();
        ComponentContext ctx = this.serviceUnit.getComponent().getComponentContext();
        ctx.deactivateEndpoint(ep);
        this.injectContext(null);
    }

    protected void injectContext(ComponentContext context) {
        try {
            Method mth = this.pojo.getClass().getMethod("setContext", class$javax$jbi$component$ComponentContext == null ? (class$javax$jbi$component$ComponentContext = Jsr181Endpoint.class$("javax.jbi.component.ComponentContext")) : class$javax$jbi$component$ComponentContext);
            mth.invoke(this.pojo, context);
        }
        catch (Exception e) {
            this.logger.debug((Object)("Unable to inject ComponentContext: " + e.getMessage()));
        }
    }

    public void registerService() throws Exception {
        String svcLocalName;
        if (this.pojo == null) {
            ClassLoader classLoader = ((XBeanServiceUnit)this.getServiceUnit()).getConfigurationClassLoader();
            Class<?> cl = Class.forName(this.pojoClass, true, classLoader);
            this.pojo = cl.newInstance();
        }
        WebAnnotations wa = null;
        String selectedAnnotations = null;
        if (this.annotations != null) {
            selectedAnnotations = this.annotations;
            if (!this.annotations.equals("none") && (wa = (WebAnnotations)knownAnnotations.get(this.annotations)) == null) {
                throw new Exception("Unrecognized annotations: " + this.annotations);
            }
        } else {
            Iterator it = knownAnnotations.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                WebAnnotations w = (WebAnnotations)entry.getValue();
                if (!w.hasWebServiceAnnotation(this.pojo.getClass())) continue;
                selectedAnnotations = (String)entry.getKey();
                wa = w;
                break;
            }
        }
        TypeMappingRegistry tm = null;
        String selectedTypeMapping = null;
        selectedTypeMapping = this.typeMapping == null ? (wa == null ? "default" : "jaxb2") : this.typeMapping;
        tm = (TypeMappingRegistry)knownTypeMappings.get(selectedTypeMapping);
        if (tm == null) {
            throw new Exception("Unrecognized typeMapping: " + this.typeMapping);
        }
        XFire xfire = this.getXFire();
        ObjectServiceFactory factory = null;
        Class<?> serviceClass = this.pojo.getClass();
        if (this.serviceInterface != null) {
            serviceClass = Class.forName(this.serviceInterface);
        }
        if (wa == null) {
            factory = new ObjectServiceFactory(xfire.getTransportManager(), (BindingProvider)new AegisBindingProvider(tm));
        } else if (selectedAnnotations.equals("java5") && selectedTypeMapping.equals("jaxb2")) {
            try {
                Class<?> clazz = Class.forName("org.codehaus.xfire.jaxws.JAXWSServiceFactory");
                Constructor<?> ct = clazz.getDeclaredConstructor(class$org$codehaus$xfire$transport$TransportManager == null ? (class$org$codehaus$xfire$transport$TransportManager = Jsr181Endpoint.class$("org.codehaus.xfire.transport.TransportManager")) : class$org$codehaus$xfire$transport$TransportManager);
                factory = (ObjectServiceFactory)ct.newInstance(xfire.getTransportManager());
            }
            catch (Exception e) {
                factory = new AnnotationServiceFactory(wa, xfire.getTransportManager(), (BindingProvider)new AegisBindingProvider(tm));
            }
        } else {
            factory = new AnnotationServiceFactory(wa, xfire.getTransportManager(), (BindingProvider)new AegisBindingProvider(tm));
        }
        this.definition = this.loadDefinition();
        if (this.definition != null) {
            if (this.definition.getServices().size() != 1) {
                throw new InvalidParameterException("The deployed wsdl defines more than one service");
            }
            javax.wsdl.Service wsdlSvc = (javax.wsdl.Service)this.definition.getServices().values().iterator().next();
            if (this.service == null) {
                this.service = wsdlSvc.getQName();
            } else if (!this.service.equals(wsdlSvc.getQName())) {
                throw new InvalidParameterException("The name of the Service defined by the deployed wsdl does not match the service name of the jbi endpoint");
            }
            if (wsdlSvc.getPorts().size() != 1) {
                throw new InvalidParameterException("The Service defined in the deployed wsdl must define exactly one Port");
            }
            Port wsdlPort = (Port)wsdlSvc.getPorts().values().iterator().next();
            if (this.endpoint == null) {
                this.endpoint = wsdlPort.getName();
            } else if (!this.endpoint.equals(wsdlPort.getName())) {
                throw new InvalidParameterException("The name of the Port defined by the deployed wsdl does not match the endpoint name of the jbi endpoint");
            }
            Binding wsdlBinding = wsdlPort.getBinding();
            if (wsdlBinding == null) {
                throw new InvalidParameterException("The Port defined in the deployed wsdl does not have any binding");
            }
            PortType wsdlPortType = wsdlBinding.getPortType();
            if (wsdlPortType == null) {
                throw new InvalidParameterException("The Binding defined in the deployed wsdl does not have reference a PortType");
            }
            if (this.interfaceName == null) {
                this.interfaceName = wsdlPortType.getQName();
            } else if (!this.interfaceName.equals(wsdlPortType.getQName())) {
                throw new InvalidParameterException("The name of the PortType defined by the deployed wsdl does not match the interface name of the jbi endpoint");
            }
            this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
        }
        String string = svcLocalName = this.service != null ? this.service.getLocalPart() : null;
        String svcNamespace = this.interfaceName != null ? this.interfaceName.getNamespaceURI() : (this.service != null ? this.service.getNamespaceURI() : null);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("objectServiceFactory.portType", this.interfaceName);
        props.put("objectServiceFactory.style", "wrapped");
        props.put("objectServiceFactory.use", "literal");
        factory.getSoap11Transports().clear();
        factory.getSoap12Transports().clear();
        factory.getSoap11Transports().add("http://java.sun.com/xml/ns/jbi/binding/service+engine");
        this.xfireService = factory.create(serviceClass, svcLocalName, svcNamespace, props);
        this.xfireService.setInvoker((Invoker)new BeanInvoker(this.getPojo()));
        this.xfireService.setFaultSerializer((MessageSerializer)new JbiFaultSerializer(this.getConfiguration()));
        xfire.getServiceRegistry().register(this.xfireService);
        if (this.description == null) {
            this.description = this.generateWsdl();
            if (this.service != null && this.interfaceName != null && !this.service.getNamespaceURI().equals(this.interfaceName.getNamespaceURI())) {
                Port port;
                this.definition = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, this.description);
                javax.wsdl.Service svc = this.definition.getService(new QName(this.interfaceName.getNamespaceURI(), this.service.getLocalPart()));
                Port port2 = port = svc != null && svc.getPorts().size() == 1 ? (Port)svc.getPorts().values().iterator().next() : null;
                if (port != null) {
                    if (this.endpoint == null) {
                        this.endpoint = port.getName();
                    }
                    this.definition.removeBinding(port.getBinding().getQName());
                    this.definition.removeService(svc.getQName());
                    this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
                }
            }
            if (this.logger.isTraceEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                WSDLFactory.newInstance().newWSDLWriter().writeWSDL(this.definition, (OutputStream)baos);
                this.logger.trace((Object)baos.toString());
            }
            QName serviceName = this.xfireService.getName();
            QName interfName = this.xfireService.getServiceInfo().getPortType();
            String endpointName = null;
            if (this.service == null) {
                this.service = serviceName;
            } else if (!this.service.equals(serviceName)) {
                this.logger.warn((Object)("The service name defined in the wsdl (" + serviceName + ") does not match the service name defined in the endpoint spec (" + this.service + "). WSDL description may be unusable."));
            }
            if (this.interfaceName == null) {
                this.interfaceName = interfName;
            } else if (!this.interfaceName.equals(interfName)) {
                this.logger.warn((Object)("The interface name defined in the wsdl (" + interfName + ") does not match the service name defined in the endpoint spec (" + this.interfaceName + "). WSDL description may be unusable."));
            }
            this.definition = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, this.description);
            javax.wsdl.Service svc = this.definition.getService(serviceName);
            if (svc != null && svc.getPorts().values().size() == 1) {
                Port port = (Port)svc.getPorts().values().iterator().next();
                endpointName = port.getName();
                if (this.endpoint == null) {
                    this.endpoint = endpointName;
                } else if (!this.endpoint.equals(endpointName)) {
                    port.setName(this.endpoint);
                    this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
                }
            }
            if (this.endpoint == null) {
                throw new IllegalArgumentException("endpoint name should be provided");
            }
        }
    }

    protected Definition loadDefinition() throws IOException, WSDLException {
        if (this.wsdlResource != null) {
            URL resource = this.wsdlResource.getURL();
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            return reader.readWSDL(null, resource.toString());
        }
        return null;
    }

    protected Document generateWsdl() throws SAXException, IOException, ParserConfigurationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.getXFire().generateWSDL(this.xfireService.getSimpleName(), (OutputStream)baos);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(baos.toByteArray()));
        return doc;
    }

    public XFire getXFire() {
        Jsr181LifeCycle jsr181LifeCycle = (Jsr181LifeCycle)this.serviceUnit.getComponent().getLifeCycle();
        XFire xfire = jsr181LifeCycle.getXFire();
        return xfire;
    }

    public Jsr181ConfigurationMBean getConfiguration() {
        Jsr181LifeCycle jsr181LifeCycle = (Jsr181LifeCycle)this.serviceUnit.getComponent().getLifeCycle();
        Jsr181Configuration configuration = jsr181LifeCycle.getConfiguration();
        return configuration;
    }

    public String getPojoClass() {
        return this.pojoClass;
    }

    public void setPojoClass(String pojoClass) {
        this.pojoClass = pojoClass;
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(String annotations) {
        this.annotations = annotations;
    }

    public String getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(String typeMapping) {
        this.typeMapping = typeMapping;
    }

    public ExchangeProcessor getProcessor() {
        return this.processor;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class<?> cl;
        knownTypeMappings = new HashMap();
        knownTypeMappings.put("default", new DefaultTypeMappingRegistry(true));
        knownTypeMappings.put("xmlbeans", new XmlBeansTypeRegistry());
        try {
            cl = Class.forName("org.codehaus.xfire.jaxb2.JaxbTypeRegistry");
            Object tr = cl.newInstance();
            knownTypeMappings.put("jaxb2", tr);
        }
        catch (Throwable e) {
            // empty catch block
        }
        knownAnnotations = new HashMap();
        knownAnnotations.put("jsr181", new Jsr181WebAnnotations());
        knownAnnotations.put("commons", new CommonsWebAttributes());
        try {
            cl = Class.forName("org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations");
            Object wa = cl.newInstance();
            knownAnnotations.put("java5", wa);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

