/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jsr181;

import javax.jbi.management.DeploymentException;
import org.apache.servicemix.common.AbstractDeployer;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.xbean.AbstractXBeanDeployer;
import org.apache.servicemix.common.xbean.XBeanServiceUnit;
import org.apache.servicemix.jsr181.Jsr181Endpoint;

public class Jsr181XBeanDeployer
extends AbstractXBeanDeployer {
    public Jsr181XBeanDeployer(BaseComponent component) {
        super(component);
    }

    protected boolean validate(Endpoint endpoint) throws DeploymentException {
        if (!(endpoint instanceof Jsr181Endpoint)) {
            throw this.failure("deploy", "Endpoint should be a Jsr181 endpoint", null);
        }
        Jsr181Endpoint ep = (Jsr181Endpoint)endpoint;
        if (ep.getPojo() == null && ep.getPojoClass() == null) {
            throw this.failure("deploy", "Endpoint must have a non-null pojo or a pojoClass", null);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = ((XBeanServiceUnit)ep.getServiceUnit()).getConfigurationClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            if (((AbstractDeployer)this).logger.isDebugEnabled()) {
                ((AbstractDeployer)this).logger.debug((Object)("Registering endpoint with context classloader " + cl));
            }
            ep.registerService();
        }
        catch (Exception e) {
            throw this.failure("deploy", "Could not register endpoint", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        return true;
    }
}

