/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jsr181.xfire;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.client.XFireProxyFactory;
import org.w3c.dom.Document;

public class JbiProxy {
    protected XFire xfire;
    protected ComponentContext context;
    protected QName interfaceName;
    protected QName serviceName;
    protected String endpointName;
    protected Object proxy;
    protected Class serviceClass;
    protected Definition description;
    protected ServiceEndpoint endpoint;

    public static Object create(XFire xfire, ComponentContext context, QName interfaceName, QName serviceName, String endpointName, Class serviceClass) throws Exception {
        JbiProxy p = new JbiProxy(xfire, context, serviceClass, interfaceName, serviceName, endpointName);
        return p.getProxy();
    }

    public JbiProxy(XFire xfire, ComponentContext context, Class serviceClass, Definition description) throws Exception {
        this.xfire = xfire;
        this.context = context;
        this.serviceClass = serviceClass;
        this.description = description;
    }

    public JbiProxy(XFire xfire, ComponentContext context, Class serviceClass, QName interfaceName, QName serviceName, String endpointName) throws Exception {
        this.xfire = xfire;
        this.context = context;
        this.interfaceName = interfaceName;
        this.serviceName = serviceName;
        this.endpointName = endpointName;
        this.serviceClass = serviceClass;
    }

    public Object getProxy() throws Exception {
        if (this.proxy == null) {
            JBIClient client = new JBIClient(this.xfire, this.getDescription(), this.serviceClass);
            if (this.interfaceName != null) {
                client.getService().setProperty("jbi.interface", (Object)this.interfaceName);
            }
            if (this.serviceName != null) {
                client.getService().setProperty("jbi.service", (Object)this.serviceName);
            }
            if (this.endpoint != null) {
                client.getService().setProperty("jbi.endpoint", (Object)this.endpoint);
            }
            XFireProxyFactory xpf = new XFireProxyFactory(this.xfire);
            this.proxy = xpf.create((Client)client);
        }
        return this.proxy;
    }

    public Definition getDescription() throws Exception {
        if (this.description == null) {
            ServiceEndpoint[] endpoints = this.getEndpoints();
            if (endpoints == null || endpoints.length == 0) {
                throw new IllegalStateException("No endpoints found for interface " + this.interfaceName + ", serviceName " + this.serviceName + " and endpoint " + this.endpointName);
            }
            ServiceEndpoint endpoint = this.chooseEndpoint(endpoints);
            if (endpoint == null) {
                throw new IllegalStateException("No suitable endpoint found");
            }
            if (this.serviceName != null && this.endpointName != null) {
                this.endpoint = endpoint;
            }
            Document doc = this.context.getEndpointDescriptor(endpoint);
            this.description = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, doc);
        }
        return this.description;
    }

    protected ServiceEndpoint[] getEndpoints() throws JBIException {
        ServiceEndpoint[] endpoints;
        if (this.endpointName != null && this.serviceName != null) {
            ServiceEndpoint endpoint = this.context.getEndpoint(this.serviceName, this.endpointName);
            if (endpoint == null) {
                endpoints = new ServiceEndpoint[]{};
            } else {
                this.endpoint = endpoint;
                endpoints = new ServiceEndpoint[]{endpoint};
            }
        } else if (this.serviceName != null) {
            endpoints = this.context.getEndpointsForService(this.serviceName);
        } else if (this.interfaceName != null) {
            endpoints = this.context.getEndpoints(this.interfaceName);
        } else {
            throw new IllegalStateException("One of interfaceName or serviceName should be provided");
        }
        return endpoints;
    }

    protected ServiceEndpoint chooseEndpoint(ServiceEndpoint[] endpoints) throws JBIException {
        for (int i = 0; i < endpoints.length; ++i) {
            if (this.context.getEndpointDescriptor(endpoints[i]) == null) continue;
            return endpoints[i];
        }
        return null;
    }

    protected static class JBIClient
    extends Client {
        public JBIClient(XFire xfire, Definition description, Class serviceClass) throws Exception {
            this.setXFire(xfire);
            this.initFromDefinition("http://java.sun.com/xml/ns/jbi/binding/service+engine", description, serviceClass);
        }
    }
}

