/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jsr181.xfire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jbi.component.ComponentContext;
import javax.xml.namespace.QName;
import org.apache.servicemix.client.DefaultServiceMixClient;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jsr181.Jsr181LifeCycle;
import org.apache.servicemix.jsr181.xfire.JbiProxy;
import org.codehaus.xfire.XFire;
import org.springframework.beans.factory.FactoryBean;

public class JbiProxyFactoryBean
implements FactoryBean {
    private JBIContainer container;
    private Class type;
    private Object proxy;
    private InvocationHandler jbiInvocationHandler;
    private QName service;
    private QName interfaceName;
    private String endpoint;

    public Object getObject() throws Exception {
        if (this.proxy == null) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    private Object createProxy() throws Exception {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.type}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                InvocationHandler next = JbiProxyFactoryBean.this.getJBIInvocationHandler();
                return next.invoke(proxy, method, args);
            }
        });
    }

    private synchronized InvocationHandler getJBIInvocationHandler() throws Exception {
        if (this.jbiInvocationHandler == null) {
            DefaultServiceMixClient client = new DefaultServiceMixClient(this.container);
            ComponentContext context = client.getContext();
            XFire xfire = Jsr181LifeCycle.createXFire(context);
            Object o = JbiProxy.create(xfire, context, this.interfaceName, this.service, this.endpoint, this.type);
            this.jbiInvocationHandler = Proxy.getInvocationHandler(o);
        }
        return this.jbiInvocationHandler;
    }

    public Class getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public JBIContainer getContainer() {
        return this.container;
    }

    public void setContainer(JBIContainer container) {
        this.container = container;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpointName) {
        this.endpoint = endpointName;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }
}

