/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jsr181;

import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;

public class EndpointDeliveryChannel
implements DeliveryChannel {
    private static ThreadLocal<Endpoint> endpoint = new ThreadLocal();
    private final DeliveryChannel channel;

    public EndpointDeliveryChannel(DeliveryChannel channel) {
        this.channel = channel;
    }

    public MessageExchange accept() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public MessageExchange accept(long timeout) throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public void close() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public MessageExchangeFactory createExchangeFactory() {
        return this.channel.createExchangeFactory();
    }

    public MessageExchangeFactory createExchangeFactory(QName interfaceName) {
        return this.channel.createExchangeFactory(interfaceName);
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint ep) {
        return this.channel.createExchangeFactory(ep);
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName serviceName) {
        return this.channel.createExchangeFactoryForService(serviceName);
    }

    public void send(MessageExchange exchange) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            throw new UnsupportedOperationException("Asynchronous send of active exchanges are not supported");
        }
        this.prepare(exchange);
        this.channel.send(exchange);
    }

    public boolean sendSync(MessageExchange exchange, long timeout) throws MessagingException {
        this.prepare(exchange);
        return this.channel.sendSync(exchange, timeout);
    }

    public boolean sendSync(MessageExchange exchange) throws MessagingException {
        this.prepare(exchange);
        return this.channel.sendSync(exchange);
    }

    protected void prepare(MessageExchange exchange) throws MessagingException {
        Endpoint ep = endpoint.get();
        if (ep != null && exchange.getStatus() == ExchangeStatus.ACTIVE && exchange.getRole() == MessageExchange.Role.CONSUMER) {
            ServiceMixComponent comp = ep.getServiceUnit().getComponent();
            comp.prepareConsumerExchange(exchange, ep);
        }
    }

    public static void setEndpoint(Endpoint ep) {
        endpoint.set(ep);
    }
}

