/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jsr181.xfire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.servicemix.jbi.jaxp.StAXSourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jbi.messaging.MessageExchangeSupport;
import org.apache.servicemix.jsr181.JBIContext;
import org.apache.servicemix.jsr181.xfire.JbiTransport;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.soap.AbstractSoapBinding;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.transport.Transport;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.transform.JDOMResult;

public class JbiChannel
extends AbstractChannel {
    public static final String JBI_INTERFACE_NAME = "jbi.interface";
    public static final String JBI_SERVICE_NAME = "jbi.service";
    public static final String JBI_ENDPOINT = "jbi.endpoint";
    public static final String JBI_SECURITY_PROPAGATATION = "jbi.security.propagation";
    private static ThreadLocal<StAXSourceTransformer> transformer = new ThreadLocal();

    public JbiChannel(String uri, JbiTransport transport) {
        this.setTransport((Transport)transport);
        this.setUri(uri);
    }

    protected static StAXSourceTransformer getTransformer() {
        StAXSourceTransformer t = transformer.get();
        if (t == null) {
            t = new StAXSourceTransformer();
            transformer.set(t);
        }
        return t;
    }

    public void open() throws Exception {
    }

    public void send(MessageContext context, OutMessage message) throws XFireException {
        if ("urn:xfire:channel:backchannel".equals(message.getUri())) {
            OutputStream out = (OutputStream)context.getProperty("urn:xfire:channel:backchannel");
            if (out != null) {
                try {
                    XMLStreamWriter writer = JbiChannel.getTransformer().getOutputFactory().createXMLStreamWriter(out, message.getEncoding());
                    message.getSerializer().writeMessage(message, writer, context);
                    writer.close();
                }
                catch (XMLStreamException e) {
                    throw new XFireException("Error closing output stream", (Throwable)e);
                }
                return;
            }
        } else {
            try {
                DeliveryChannel channel = ((JbiTransport)this.getTransport()).getContext().getDeliveryChannel();
                MessageExchangeFactory factory = channel.createExchangeFactory();
                URI mep = null;
                mep = context.getExchange().getOperation().getOutputMessage() != null ? MessageExchangeSupport.IN_OUT : (context.getExchange().getOperation().getFaults().size() > 0 ? MessageExchangeSupport.ROBUST_IN_ONLY : MessageExchangeSupport.IN_ONLY);
                MessageExchange me = factory.createExchange(mep);
                me.setInterfaceName((QName)context.getService().getProperty(JBI_INTERFACE_NAME));
                me.setOperation(context.getExchange().getOperation().getQName());
                me.setService((QName)context.getService().getProperty(JBI_SERVICE_NAME));
                me.setEndpoint((ServiceEndpoint)context.getService().getProperty(JBI_ENDPOINT));
                NormalizedMessage msg = me.createMessage();
                me.setMessage(msg, "in");
                if (Boolean.TRUE.equals(context.getService().getProperty(JBI_SECURITY_PROPAGATATION))) {
                    NormalizedMessage oldMsg;
                    MessageExchange oldMe = JBIContext.getMessageExchange();
                    NormalizedMessage normalizedMessage = oldMsg = oldMe != null ? oldMe.getMessage("in") : null;
                    if (oldMsg != null) {
                        msg.setSecuritySubject(oldMsg.getSecuritySubject());
                    }
                }
                me.setOperation(context.getExchange().getOperation().getQName());
                msg.setContent(this.getContent(context, message));
                if (!channel.sendSync(me)) {
                    throw new XFireException("Unable to send jbi exchange: sendSync returned false");
                }
                if (me.getStatus() == ExchangeStatus.ERROR) {
                    if (me.getError() != null) {
                        throw new XFireFault((Throwable)me.getError(), XFireFault.RECEIVER);
                    }
                    throw new XFireFault("Unkown Error", XFireFault.RECEIVER);
                }
                if (me.getStatus() == ExchangeStatus.ACTIVE) {
                    if (me.getFault() != null) {
                        JDOMResult result = new JDOMResult();
                        String str = JbiChannel.getTransformer().contentToString((NormalizedMessage)me.getFault());
                        JbiChannel.getTransformer().toResult((Source)new StringSource(str), (Result)result);
                        Element e = result.getDocument().getRootElement();
                        e = (Element)e.clone();
                        me.setStatus(ExchangeStatus.DONE);
                        channel.send(me);
                        XFireFault xfireFault = new XFireFault(str, XFireFault.RECEIVER);
                        xfireFault.getDetail().addContent((Content)e);
                        throw xfireFault;
                    }
                    if (me.getMessage("out") != null) {
                        Source outSrc = me.getMessage("out").getContent();
                        InMessage inMessage = new InMessage(JbiChannel.getTransformer().toXMLStreamReader(outSrc), this.getUri());
                        this.getEndpoint().onReceive(context, inMessage);
                        me.setStatus(ExchangeStatus.DONE);
                        channel.send(me);
                    }
                }
            }
            catch (XFireException e) {
                throw e;
            }
            catch (Exception e) {
                throw new XFireException("Error sending jbi exchange", (Throwable)e);
            }
        }
    }

    protected Source getContent(MessageContext context, OutMessage message) throws XMLStreamException, IOException, XFireException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        XMLStreamWriter writer = JbiChannel.getTransformer().getOutputFactory().createXMLStreamWriter(outStream, message.getEncoding());
        MessageSerializer serializer = context.getOutMessage().getSerializer();
        if (serializer == null) {
            AbstractSoapBinding binding = (AbstractSoapBinding)context.getBinding();
            if (binding == null) {
                throw new XFireException("Couldn't find the binding!");
            }
            serializer = AbstractSoapBinding.getSerializer((String)binding.getStyle(), (String)binding.getUse());
        }
        serializer.writeMessage(message, writer, context);
        writer.close();
        outStream.close();
        return new StreamSource(new ByteArrayInputStream(outStream.toByteArray()));
    }
}

