/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jsr181;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointComponentContext;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.common.ManagementSupport;
import org.apache.servicemix.common.tools.wsdl.WSDLFlattener;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jsr181.Jsr181Component;
import org.apache.servicemix.jsr181.Jsr181ExchangeProcessor;
import org.apache.servicemix.jsr181.xfire.JbiFaultSerializer;
import org.apache.servicemix.jsr181.xfire.ServiceFactoryHelper;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.service.invoker.BeanInvoker;
import org.codehaus.xfire.service.invoker.Invoker;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Jsr181Endpoint
extends Endpoint {
    protected Object pojo;
    protected String pojoClass;
    protected String annotations;
    protected String typeMapping;
    protected String serviceInterface;
    protected String style = "wrapped";
    protected ServiceEndpoint activated;
    protected Service xfireService;
    protected ExchangeProcessor processor = new Jsr181ExchangeProcessor(this);
    protected Resource wsdlResource;
    protected boolean mtomEnabled;
    protected Map properties;
    private Boolean validationEnabled;

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public Resource getWsdlResource() {
        return this.wsdlResource;
    }

    public void setWsdlResource(Resource wsdlResource) {
        this.wsdlResource = wsdlResource;
    }

    public Object getPojo() {
        return this.pojo;
    }

    public void setPojo(Object pojo) {
        this.pojo = pojo;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public Boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(Boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public Service getXFireService() {
        return this.xfireService;
    }

    public MessageExchange.Role getRole() {
        return MessageExchange.Role.PROVIDER;
    }

    public void activate() throws Exception {
        this.logger = this.serviceUnit.getComponent().getLogger();
        ComponentContext ctx = this.serviceUnit.getComponent().getComponentContext();
        this.activated = ctx.activateEndpoint(this.service, this.endpoint);
        this.injectPojo((ComponentContext)new EndpointComponentContext((Endpoint)this), this.getContainer());
        this.processor.start();
    }

    public void deactivate() throws Exception {
        ServiceEndpoint ep = this.activated;
        this.activated = null;
        this.processor.stop();
        ComponentContext ctx = this.serviceUnit.getComponent().getComponentContext();
        ctx.deactivateEndpoint(ep);
        this.injectPojo(null, null);
    }

    protected void injectPojo(ComponentContext context, JBIContainer container) {
        Method mth;
        try {
            mth = this.pojo.getClass().getMethod("setContext", ComponentContext.class);
            mth.invoke(this.pojo, context);
        }
        catch (Exception e) {
            this.logger.debug((Object)("Unable to inject ComponentContext: " + e.getMessage()));
        }
        try {
            mth = this.pojo.getClass().getMethod("setContainer", JBIContainer.class);
            mth.invoke(this.pojo, container);
        }
        catch (Exception e) {
            this.logger.debug((Object)("Unable to inject JBIContainer: " + e.getMessage()));
        }
    }

    protected JBIContainer getContainer() {
        try {
            ComponentContext ctx = this.getServiceUnit().getComponent().getComponentContext();
            Field field = ctx.getClass().getDeclaredField("container");
            field.setAccessible(true);
            return (JBIContainer)field.get(ctx);
        }
        catch (Exception e) {
            this.logger.debug((Object)("Unable to retrieve JBIContainer: " + e.getMessage()));
            return null;
        }
    }

    public void validate() throws DeploymentException {
        try {
            this.registerService();
        }
        catch (Exception e) {
            throw ManagementSupport.failure((String)"deploy", (String)this.getServiceUnit().getComponent().getComponentName(), null, (Throwable)e);
        }
    }

    public void registerService() throws Exception {
        String svcLocalName;
        if (this.pojo == null) {
            if (this.pojoClass == null) {
                throw new IllegalArgumentException("Endpoint must have a non-null pojo or a pojoClass");
            }
            Class<?> cl = Class.forName(this.pojoClass, true, this.getServiceUnit().getConfigurationClassLoader());
            this.pojo = cl.newInstance();
        }
        XFire xfire = this.getXFire();
        ObjectServiceFactory factory = ServiceFactoryHelper.findServiceFactory(xfire, this.pojo.getClass(), this.annotations, this.typeMapping);
        Class<?> serviceClass = this.pojo.getClass();
        if (this.serviceInterface != null) {
            serviceClass = Class.forName(this.serviceInterface, true, this.getServiceUnit().getConfigurationClassLoader());
        }
        this.definition = this.loadDefinition();
        if (this.definition != null) {
            this.updateDescription();
        }
        String string = svcLocalName = this.service != null ? this.service.getLocalPart() : null;
        String svcNamespace = this.interfaceName != null ? this.interfaceName.getNamespaceURI() : (this.service != null ? this.service.getNamespaceURI() : null);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("objectServiceFactory.portType", this.interfaceName);
        if (this.style != null) {
            props.put("objectServiceFactory.style", this.style);
        }
        props.put("objectServiceFactory.use", "literal");
        if (this.serviceInterface != null) {
            props.put("annotations.allow.interface", Boolean.TRUE);
        }
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        this.xfireService = factory.create(serviceClass, svcLocalName, svcNamespace, props);
        this.xfireService.setInvoker((Invoker)new BeanInvoker(this.getPojo()));
        this.xfireService.setFaultSerializer((MessageSerializer)new JbiFaultSerializer());
        this.xfireService.setProperty("mtom-enabled", (Object)Boolean.toString(this.mtomEnabled));
        if (this.validationEnabled != null) {
            if ("jaxb2".equals(this.typeMapping)) {
                this.xfireService.setProperty("jaxb.validation.enabled", (Object)this.validationEnabled.toString());
            } else {
                throw new IllegalArgumentException("Currently you can controll validation only for jaxb2 mapping. " + this.typeMapping + " is not supported.");
            }
        }
        xfire.getServiceRegistry().register(this.xfireService);
        if (this.description == null) {
            this.createDescription();
        }
    }

    protected void createDescription() throws SAXException, IOException, ParserConfigurationException, WSDLException, Exception {
        this.description = this.generateWsdl();
        QName serviceName = this.xfireService.getName();
        QName interfName = this.xfireService.getServiceInfo().getPortType();
        String endpointName = null;
        if (this.service == null) {
            this.service = serviceName;
        } else if (!this.service.equals(serviceName)) {
            this.logger.warn((Object)("The service name defined in the wsdl (" + serviceName + ") does not match the service name defined in the endpoint spec (" + this.service + "). WSDL description may be unusable."));
        }
        if (this.interfaceName == null) {
            this.interfaceName = interfName;
        } else if (!this.interfaceName.equals(interfName)) {
            this.logger.warn((Object)("The interface name defined in the wsdl (" + interfName + ") does not match the service name defined in the endpoint spec (" + this.interfaceName + "). WSDL description may be unusable."));
        }
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        this.definition = reader.readWSDL(null, this.description);
        javax.wsdl.Service svc = this.definition.getService(serviceName);
        if (svc != null && svc.getPorts().values().size() == 1) {
            Port port = (Port)svc.getPorts().values().iterator().next();
            endpointName = port.getName();
            if (this.endpoint == null) {
                this.endpoint = endpointName;
            } else if (!this.endpoint.equals(endpointName)) {
                port.setName(this.endpoint);
                this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
            }
        }
        if (this.endpoint == null) {
            throw new IllegalArgumentException("endpoint name should be provided");
        }
        this.definition = new WSDLFlattener(this.definition).getDefinition(this.interfaceName);
        this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
        if (this.logger.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            WSDLFactory.newInstance().newWSDLWriter().writeWSDL(this.definition, (OutputStream)baos);
            this.logger.debug((Object)baos.toString());
        }
    }

    protected void updateDescription() throws Exception {
        if (this.definition.getServices().size() != 1) {
            throw new IllegalArgumentException("The deployed wsdl defines more than one service");
        }
        javax.wsdl.Service wsdlSvc = (javax.wsdl.Service)this.definition.getServices().values().iterator().next();
        if (this.service == null) {
            this.service = wsdlSvc.getQName();
        } else if (!this.service.equals(wsdlSvc.getQName())) {
            throw new IllegalArgumentException("The name of the Service defined by the deployed wsdl does not match the service name of the jbi endpoint");
        }
        if (wsdlSvc.getPorts().size() != 1) {
            throw new IllegalArgumentException("The Service defined in the deployed wsdl must define exactly one Port");
        }
        Port wsdlPort = (Port)wsdlSvc.getPorts().values().iterator().next();
        if (this.endpoint == null) {
            this.endpoint = wsdlPort.getName();
        } else if (!this.endpoint.equals(wsdlPort.getName())) {
            throw new IllegalArgumentException("The name of the Port defined by the deployed wsdl does not match the endpoint name of the jbi endpoint");
        }
        Binding wsdlBinding = wsdlPort.getBinding();
        if (wsdlBinding == null) {
            throw new IllegalArgumentException("The Port defined in the deployed wsdl does not have any binding");
        }
        PortType wsdlPortType = wsdlBinding.getPortType();
        if (wsdlPortType == null) {
            throw new IllegalArgumentException("The Binding defined in the deployed wsdl does not have reference a PortType");
        }
        if (this.interfaceName == null) {
            this.interfaceName = wsdlPortType.getQName();
        } else if (!this.interfaceName.equals(wsdlPortType.getQName())) {
            throw new IllegalArgumentException("The name of the PortType defined by the deployed wsdl does not match the interface name of the jbi endpoint");
        }
        this.definition = new WSDLFlattener(this.definition).getDefinition(this.interfaceName);
        this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
    }

    protected Definition loadDefinition() throws IOException, WSDLException {
        if (this.wsdlResource != null) {
            URL resource = this.wsdlResource.getURL();
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            return reader.readWSDL(null, resource.toString());
        }
        return null;
    }

    protected Document generateWsdl() throws SAXException, IOException, ParserConfigurationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.getXFire().generateWSDL(this.xfireService.getSimpleName(), (OutputStream)baos);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(new ByteArrayInputStream(baos.toByteArray()));
    }

    public XFire getXFire() {
        Jsr181Component component = (Jsr181Component)this.serviceUnit.getComponent();
        return component.getXFire();
    }

    public String getPojoClass() {
        return this.pojoClass;
    }

    public void setPojoClass(String pojoClass) {
        this.pojoClass = pojoClass;
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(String annotations) {
        this.annotations = annotations;
    }

    public String getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(String typeMapping) {
        this.typeMapping = typeMapping;
    }

    public ExchangeProcessor getProcessor() {
        return this.processor;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }
}

