/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jsr181.xfire;

import javax.jbi.component.ComponentContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jsr181.xfire.JbiChannel;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.handler.LocateBindingHandler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.soap.SoapTransport;
import org.codehaus.xfire.soap.handler.SoapBodyHandler;
import org.codehaus.xfire.transport.AbstractTransport;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.ChannelEndpoint;
import org.codehaus.xfire.transport.DefaultEndpoint;
import org.codehaus.xfire.wsdl11.WSDL11Transport;

public class JbiTransport
extends AbstractTransport
implements WSDL11Transport,
SoapTransport {
    public static final String JBI_BINDING = "http://java.sun.com/xml/ns/jbi/binding/service+engine";
    private static final Log LOG = LogFactory.getLog(JbiTransport.class);
    private static final String URI_PREFIX = "urn:xfire:transport:jbi:";
    private ComponentContext context;

    public JbiTransport(ComponentContext context) {
        this.addInHandler((Handler)new LocateBindingHandler());
        this.addInHandler((Handler)new SoapBodyHandler());
        this.context = context;
    }

    public String getName() {
        return "JBI";
    }

    public String getServiceURL(Service service) {
        return "jbi://" + service.getName();
    }

    protected Channel createNewChannel(String uri) {
        LOG.debug((Object)("Creating new channel for uri: " + uri));
        JbiChannel c = new JbiChannel(uri, this);
        c.setEndpoint((ChannelEndpoint)new DefaultEndpoint());
        return c;
    }

    protected String getUriPrefix() {
        return URI_PREFIX;
    }

    public String[] getSupportedBindings() {
        return new String[]{JBI_BINDING};
    }

    public String[] getKnownUriSchemes() {
        return new String[]{"jbi://"};
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        return o instanceof JbiTransport;
    }

    public int hashCode() {
        return JbiTransport.class.hashCode();
    }
}

