/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.util.ArrayList;

public class InvalidAttributeTargetError
extends Error {
    public InvalidAttributeTargetError(String attributeClass, String element, int targetFlags) {
        super("Attributes of type " + attributeClass + " can't be applied to " + element + ". " + "They can only be applied to: " + InvalidAttributeTargetError.flagsToString(targetFlags));
    }

    private static final String flagsToString(int flags) {
        ArrayList<String> targetNames = new ArrayList<String>();
        if ((flags & 1) > 0) {
            targetNames.add("CLASS");
        }
        if ((flags & 2) > 0) {
            targetNames.add("FIELD");
        }
        if ((flags & 4) > 0) {
            targetNames.add("METHOD");
        }
        if ((flags & 8) > 0) {
            targetNames.add("CONSTRUCTOR");
        }
        if ((flags & 0x10) > 0) {
            targetNames.add("METHOD_PARAMETER");
        }
        if ((flags & 0x20) > 0) {
            targetNames.add("CONSTRUCTOR_PARAMETER");
        }
        if ((flags & 0x40) > 0) {
            targetNames.add("RETURN");
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < targetNames.size()) {
            sb.append(targetNames.get(i));
            if (i < targetNames.size() - 1) {
                sb.append(" | ");
            }
            ++i;
        }
        return sb.toString();
    }
}

