/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.ManagementSupport;
import org.apache.servicemix.common.ServiceUnit;

public class BaseServiceUnitManager
implements ServiceUnitManager {
    protected final transient Log logger;
    protected BaseComponent component;
    protected Deployer[] deployers;
    protected boolean persistent;

    public BaseServiceUnitManager(BaseComponent component, Deployer[] deployers) {
        this(component, deployers, false);
    }

    public BaseServiceUnitManager(BaseComponent component, Deployer[] deployers, boolean persistent) {
        this.component = component;
        this.logger = component.logger;
        this.deployers = deployers;
        this.persistent = persistent;
    }

    public synchronized String deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Deploying service unit");
            }
            if (serviceUnitName == null || serviceUnitName.length() == 0) {
                throw new IllegalArgumentException("serviceUnitName should be non null and non empty");
            }
            if (this.getServiceUnit(serviceUnitName) != null) {
                throw this.failure("deploy", "Service Unit '" + serviceUnitName + "' is already deployed", null);
            }
            ServiceUnit su = this.doDeploy(serviceUnitName, serviceUnitRootPath);
            if (su == null) {
                throw this.failure("deploy", "Unable to find suitable deployer for Service Unit '" + serviceUnitName + "'", null);
            }
            this.component.getRegistry().registerServiceUnit(su);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service unit deployed");
            }
            return this.createSuccessMessage("deploy");
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.failure("deploy", "Unable to deploy service unit", e);
        }
    }

    protected ServiceUnit doDeploy(String serviceUnitName, String serviceUnitRootPath) throws Exception {
        for (int i = 0; i < this.deployers.length; ++i) {
            if (!this.deployers[i].canDeploy(serviceUnitName, serviceUnitRootPath)) continue;
            return this.deployers[i].deploy(serviceUnitName, serviceUnitRootPath);
        }
        return null;
    }

    public synchronized void init(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Initializing service unit");
            }
            if (serviceUnitName == null || serviceUnitName.length() == 0) {
                throw new IllegalArgumentException("serviceUnitName should be non null and non empty");
            }
            if (this.getServiceUnit(serviceUnitName) == null) {
                if (!this.persistent) {
                    ServiceUnit su = this.doDeploy(serviceUnitName, serviceUnitRootPath);
                    if (su == null) {
                        throw this.failure("deploy", "Unable to find suitable deployer for Service Unit '" + serviceUnitName + "'", null);
                    }
                    this.component.getRegistry().registerServiceUnit(su);
                } else {
                    throw this.failure("init", "Service Unit '" + serviceUnitName + "' is not deployed", null);
                }
            }
            this.doInit(serviceUnitName, serviceUnitRootPath);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service unit initialized");
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.failure("init", "Unable to init service unit", e);
        }
    }

    protected void doInit(String serviceUnitName, String serviceUnitRootPath) throws Exception {
    }

    public synchronized void start(String serviceUnitName) throws DeploymentException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Starting service unit");
            }
            if (serviceUnitName == null || serviceUnitName.length() == 0) {
                throw new IllegalArgumentException("serviceUnitName should be non null and non empty");
            }
            ServiceUnit su = this.getServiceUnit(serviceUnitName);
            if (su == null) {
                throw this.failure("start", "Service Unit '" + serviceUnitName + "' is not deployed", null);
            }
            if (!"Stopped".equals(su.getCurrentState()) && !"Shutdown".equals(su.getCurrentState())) {
                throw this.failure("start", "ServiceUnit should be in a SHUTDOWN or STOPPED state", null);
            }
            su.start();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service unit started");
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.failure("start", "Unable to start service unit", e);
        }
    }

    public synchronized void stop(String serviceUnitName) throws DeploymentException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Stopping service unit");
            }
            if (serviceUnitName == null || serviceUnitName.length() == 0) {
                throw new IllegalArgumentException("serviceUnitName should be non null and non empty");
            }
            ServiceUnit su = this.getServiceUnit(serviceUnitName);
            if (su == null) {
                throw this.failure("stop", "Service Unit '" + serviceUnitName + "' is not deployed", null);
            }
            if (!"Started".equals(su.getCurrentState())) {
                throw this.failure("stop", "ServiceUnit should be in a SHUTDOWN state", null);
            }
            su.stop();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service unit stopped");
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.failure("stop", "Unable to stop service unit", e);
        }
    }

    public synchronized void shutDown(String serviceUnitName) throws DeploymentException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Shutting down service unit");
            }
            if (serviceUnitName == null || serviceUnitName.length() == 0) {
                throw new IllegalArgumentException("serviceUnitName should be non null and non empty");
            }
            ServiceUnit su = this.getServiceUnit(serviceUnitName);
            if (su == null) {
                throw this.failure("shutDown", "Service Unit '" + serviceUnitName + "' is not deployed", null);
            }
            su.shutDown();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service unit shut down");
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.failure("shutDown", "Unable to shutdown service unit", e);
        }
    }

    public synchronized String undeploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Undeploying service unit");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Shutting down service unit");
            }
            if (serviceUnitName == null || serviceUnitName.length() == 0) {
                throw new IllegalArgumentException("serviceUnitName should be non null and non empty");
            }
            ServiceUnit su = this.getServiceUnit(serviceUnitName);
            if (su == null) {
                throw this.failure("undeploy", "Service Unit '" + serviceUnitName + "' is not deployed", null);
            }
            if (!"Shutdown".equals(su.getCurrentState())) {
                throw this.failure("undeploy", "ServiceUnit should be in a SHUTDOWN state", null);
            }
            this.doUndeploy(su);
            this.component.getRegistry().unregisterServiceUnit(su);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Service unit undeployed");
            }
            return this.createSuccessMessage("undeploy");
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.failure("undeploy", "Unable to undeploy service unit", e);
        }
    }

    protected void doUndeploy(ServiceUnit su) throws Exception {
        for (int i = 0; i < this.deployers.length; ++i) {
            if (!this.deployers[i].canDeploy(su.getName(), su.getRootPath())) continue;
            this.deployers[i].undeploy(su);
            return;
        }
        throw this.failure("undeploy", "Unable to find suitable deployer for Service Unit '" + su.getName() + "'", null);
    }

    protected DeploymentException failure(String task, String info, Exception e) throws DeploymentException {
        ManagementSupport.Message msg = new ManagementSupport.Message();
        msg.setComponent(this.component.getComponentName());
        msg.setTask(task);
        msg.setResult("FAILED");
        msg.setType("ERROR");
        msg.setException(e);
        msg.setMessage(info);
        return new DeploymentException(ManagementSupport.createComponentMessage(msg));
    }

    protected String createSuccessMessage(String task) {
        ManagementSupport.Message msg = new ManagementSupport.Message();
        msg.setComponent(this.component.getComponentName());
        msg.setTask(task);
        msg.setResult("SUCCESS");
        return ManagementSupport.createComponentMessage(msg);
    }

    protected ServiceUnit getServiceUnit(String name) {
        return this.component.getRegistry().getServiceUnit(name);
    }
}

