/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.tools.wsdl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.tools.wsdl.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SchemaCollection {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$common$tools$wsdl$SchemaCollection == null ? (class$org$apache$servicemix$common$tools$wsdl$SchemaCollection = SchemaCollection.class$("org.apache.servicemix.common.tools.wsdl.SchemaCollection")) : class$org$apache$servicemix$common$tools$wsdl$SchemaCollection));
    private Map schemas;
    private URI baseUri;
    static /* synthetic */ Class class$org$apache$servicemix$common$tools$wsdl$SchemaCollection;

    public SchemaCollection() {
        this(null);
    }

    public SchemaCollection(URI baseUri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing schema collection with baseUri: " + baseUri));
        }
        this.baseUri = baseUri;
        this.schemas = new HashMap();
    }

    public Schema getSchema(String namespaceURI) {
        return (Schema)this.schemas.get(namespaceURI);
    }

    public void read(Element elem, URI sourceUri) throws Exception {
        Schema schema = new Schema();
        schema.setSourceUri(sourceUri);
        schema.setRoot(elem);
        schema.setNamespace(elem.getAttribute("targetNamespace"));
        this.schemas.put(schema.getNamespace(), schema);
        this.handleImports(schema);
    }

    public void read(String location, URI baseUri) throws Exception {
        URI loc;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading schema at '" + location + "' with baseUri '" + baseUri + "'"));
        }
        if (baseUri == null) {
            baseUri = this.baseUri;
        }
        if (baseUri != null) {
            loc = SchemaCollection.resolve(baseUri, location);
            if (!loc.isAbsolute()) {
                throw new IllegalArgumentException("Unable to resolve '" + loc.toString() + "' relative to '" + baseUri + "'");
            }
        } else {
            loc = new URI(location);
            if (!loc.isAbsolute()) {
                throw new IllegalArgumentException("Location '" + loc.toString() + "' is not absolute and no baseUri specified");
            }
        }
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(loc.toURL().openStream());
        inputSource.setSystemId(loc.toString());
        this.read(inputSource);
    }

    public void read(InputSource inputSource) throws Exception {
        DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
        docFac.setNamespaceAware(true);
        DocumentBuilder builder = docFac.newDocumentBuilder();
        Document doc = builder.parse(inputSource);
        this.read(doc.getDocumentElement(), inputSource.getSystemId() != null ? new URI(inputSource.getSystemId()) : null);
    }

    protected void handleImports(Schema schema) throws Exception {
        NodeList children = schema.getRoot().getChildNodes();
        ArrayList<Element> imports = new ArrayList<Element>();
        for (int i = 0; i < children.getLength(); ++i) {
            Element ce;
            Node child = children.item(i);
            if (!(child instanceof Element) || !"http://www.w3.org/2001/XMLSchema".equals((ce = (Element)child).getNamespaceURI()) || !"import".equals(ce.getLocalName())) continue;
            imports.add(ce);
        }
        Iterator iter = imports.iterator();
        while (iter.hasNext()) {
            String location;
            Element ce = (Element)iter.next();
            String namespace = ce.getAttribute("namespace");
            if (this.schemas.get(namespace) == null && (location = ce.getAttribute("schemaLocation")) != null && !"".equals(location)) {
                this.read(location, schema.getSourceUri());
            }
            schema.addImport(namespace);
            schema.getRoot().removeChild(ce);
        }
    }

    protected static URI resolve(URI base, String location) {
        if ("jar".equals(base.getScheme())) {
            String str = base.toString();
            String[] parts = str.split("!");
            parts[1] = URI.create(parts[1]).resolve(location).toString();
            return URI.create(parts[0] + "!" + parts[1]);
        }
        return base.resolve(location);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

