/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.tools.wsdl;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.tools.wsdl.Schema;
import org.apache.servicemix.common.tools.wsdl.SchemaCollection;

public class WSDLFlattener {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$common$tools$wsdl$WSDLFlattener == null ? (class$org$apache$servicemix$common$tools$wsdl$WSDLFlattener = WSDLFlattener.class$("org.apache.servicemix.common.tools.wsdl.WSDLFlattener")) : class$org$apache$servicemix$common$tools$wsdl$WSDLFlattener));
    private Definition definition;
    private SchemaCollection schemas;
    private Map flattened;
    private boolean initialized;
    static /* synthetic */ Class class$org$apache$servicemix$common$tools$wsdl$WSDLFlattener;

    public WSDLFlattener() {
        this(null, null);
    }

    public WSDLFlattener(Definition definition) {
        this(definition, null);
    }

    public WSDLFlattener(Definition definition, SchemaCollection schemas) {
        this.definition = definition;
        this.flattened = new HashMap();
        this.schemas = schemas;
    }

    public void initialize() throws Exception {
        if (!this.initialized) {
            if (this.schemas == null) {
                URI uri = null;
                if (this.definition.getDocumentBaseURI() != null) {
                    uri = URI.create(this.definition.getDocumentBaseURI());
                }
                this.schemas = new SchemaCollection(uri);
            }
            this.parseSchemas(this.definition);
            this.initialized = true;
        }
    }

    public Definition getDefinition(QName portType) throws Exception {
        Definition def = (Definition)this.flattened.get(portType);
        if (def == null) {
            def = this.flattenDefinition(portType);
            this.flattened.put(portType, def);
        }
        return def;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public SchemaCollection getSchemas() throws Exception {
        return this.schemas;
    }

    public void setSchemas(SchemaCollection schemas) {
        this.schemas = schemas;
    }

    private Definition flattenDefinition(QName name) throws Exception {
        this.initialize();
        Definition flat = WSDLFactory.newInstance().newDefinition();
        flat.setTargetNamespace(name.getNamespaceURI());
        this.addNamespaces(flat, this.definition);
        PortType defPort = this.definition.getPortType(name);
        PortType flatPort = flat.createPortType();
        flatPort.setQName(defPort.getQName());
        flatPort.setUndefined(false);
        Iterator itOper = defPort.getOperations().iterator();
        while (itOper.hasNext()) {
            Operation defOper = (Operation)itOper.next();
            Operation flatOper = flat.createOperation();
            flatOper.setName(defOper.getName());
            flatOper.setStyle(defOper.getStyle());
            flatOper.setUndefined(false);
            if (defOper.getInput() != null) {
                Input flatInput = flat.createInput();
                flatInput.setName(defOper.getInput().getName());
                if (defOper.getInput().getMessage() != null) {
                    Message flatInputMsg = this.copyMessage(defOper.getInput().getMessage(), flat);
                    flatInput.setMessage(flatInputMsg);
                    flat.addMessage(flatInputMsg);
                }
                flatOper.setInput(flatInput);
            }
            if (defOper.getOutput() != null) {
                Output flatOutput = flat.createOutput();
                flatOutput.setName(defOper.getOutput().getName());
                if (defOper.getOutput().getMessage() != null) {
                    Message flatOutputMsg = this.copyMessage(defOper.getOutput().getMessage(), flat);
                    flatOutput.setMessage(flatOutputMsg);
                    flat.addMessage(flatOutputMsg);
                }
                flatOper.setOutput(flatOutput);
            }
            Iterator itFault = defOper.getFaults().values().iterator();
            while (itFault.hasNext()) {
                Fault defFault = (Fault)itFault.next();
                Fault flatFault = flat.createFault();
                flatFault.setName(defFault.getName());
                if (defFault.getMessage() != null) {
                    Message flatFaultMsg = this.copyMessage(defFault.getMessage(), flat);
                    flatFault.setMessage(flatFaultMsg);
                    flat.addMessage(flatFaultMsg);
                }
                flatOper.addFault(flatFault);
            }
            flatPort.addOperation(flatOper);
        }
        HashSet<String> namespaces = new HashSet<String>();
        Iterator itMsg = flat.getMessages().values().iterator();
        while (itMsg.hasNext()) {
            Message msg = (Message)itMsg.next();
            Iterator itPart = msg.getParts().values().iterator();
            while (itPart.hasNext()) {
                Part part = (Part)itPart.next();
                QName elemName = part.getElementName();
                if (elemName == null) continue;
                namespaces.add(elemName.getNamespaceURI());
                Schema schema = this.schemas.getSchema(elemName.getNamespaceURI());
                if (schema.getImports() == null) continue;
                Iterator iter = schema.getImports().iterator();
                while (iter.hasNext()) {
                    String ns = (String)iter.next();
                    namespaces.add(ns);
                }
            }
        }
        if (namespaces.size() > 0) {
            Types types = flat.createTypes();
            Iterator iter = namespaces.iterator();
            while (iter.hasNext()) {
                String ns = (String)iter.next();
                SchemaImpl imp = new SchemaImpl();
                imp.setElement(this.schemas.getSchema(ns).getRoot());
                imp.setElementType(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
                types.addExtensibilityElement((ExtensibilityElement)imp);
            }
            flat.setTypes(types);
        }
        flat.addPortType(flatPort);
        return flat;
    }

    private void parseSchemas(Definition def) throws Exception {
        if (def.getTypes() != null && def.getTypes().getExtensibilityElements() != null) {
            Iterator iter = def.getTypes().getExtensibilityElements().iterator();
            while (iter.hasNext()) {
                ExtensibilityElement element = (ExtensibilityElement)iter.next();
                if (!(element instanceof javax.wsdl.extensions.schema.Schema)) continue;
                javax.wsdl.extensions.schema.Schema schema = (javax.wsdl.extensions.schema.Schema)element;
                Iterator itImp = schema.getImports().values().iterator();
                while (itImp.hasNext()) {
                    Collection imps = (Collection)itImp.next();
                    Iterator itSi = imps.iterator();
                    while (itSi.hasNext()) {
                        SchemaImport imp = (SchemaImport)itSi.next();
                        this.schemas.read(imp.getSchemaLocationURI(), null);
                    }
                }
            }
        }
        if (def.getImports() != null) {
            Iterator itImp = def.getImports().values().iterator();
            while (itImp.hasNext()) {
                Collection imps = (Collection)itImp.next();
                Iterator iter = imps.iterator();
                while (iter.hasNext()) {
                    Import imp = (Import)iter.next();
                    this.parseSchemas(imp.getDefinition());
                }
            }
        }
    }

    private void addNamespaces(Definition flat, Definition def) {
        Iterator itImport = def.getImports().values().iterator();
        while (itImport.hasNext()) {
            List defImports = (List)itImport.next();
            Iterator iter = defImports.iterator();
            while (iter.hasNext()) {
                Import defImport = (Import)iter.next();
                this.addNamespaces(flat, defImport.getDefinition());
            }
        }
        Iterator itNs = def.getNamespaces().keySet().iterator();
        while (itNs.hasNext()) {
            String key = (String)itNs.next();
            String val = def.getNamespace(key);
            flat.addNamespace(key, val);
        }
    }

    private Message copyMessage(Message defMessage, Definition flat) {
        Message flatMsg = flat.createMessage();
        flatMsg.setUndefined(false);
        if (defMessage.getQName() != null) {
            flatMsg.setQName(new QName(flat.getTargetNamespace(), defMessage.getQName().getLocalPart()));
        }
        Iterator itPart = defMessage.getParts().values().iterator();
        while (itPart.hasNext()) {
            Part defPart = (Part)itPart.next();
            Part flatPart = flat.createPart();
            flatPart.setName(defPart.getName());
            flatPart.setElementName(defPart.getElementName());
            flatMsg.addPart(flatPart);
        }
        return flatMsg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

