/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.lwcontainer;

import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.common.endpoints.AbstractEndpoint;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.xbean.spring.context.impl.NamespaceHelper;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;

public class LwContainerExtra
extends AbstractEndpoint {
    private Map components;
    private Map endpoints;
    private EventListener[] listeners;
    private BaseSystemService[] services;
    private IdGenerator idGenerator = new IdGenerator();
    private Map<Object, Component> endpointToComponent = new IdentityHashMap<Object, Component>();

    public LwContainerExtra(Map components, Map endpoints, EventListener[] listeners, BaseSystemService[] services) {
        this.service = new QName("http://servicemix.apache.org/lwcontainer", "extra");
        this.endpoint = this.idGenerator.generateSanitizedId();
        this.components = components;
        this.endpoints = endpoints;
        this.listeners = listeners;
        this.services = services;
    }

    public void activate() throws Exception {
        if (this.components != null) {
            for (Map.Entry e : this.components.entrySet()) {
                if (!(e.getKey() instanceof String)) {
                    throw new JBIException("Component must have a non null string name");
                }
                if (!(e.getValue() instanceof Component)) {
                    throw new JBIException("Component is not a known component");
                }
                String name = (String)e.getKey();
                this.getContainer().activateComponent((Component)e.getValue(), name);
                this.getContainer().getComponent(name).init();
            }
        }
        if (this.endpoints != null) {
            this.initEndpoints();
        }
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.getContainer().addListener(this.listeners[i]);
            }
        }
        if (this.services != null) {
            for (int i = 0; i < this.services.length; ++i) {
                this.services[i].init(this.getContainer());
                this.services[i].start();
            }
        }
    }

    public void deactivate() throws Exception {
        if (this.endpoints != null) {
            for (Map.Entry e : this.endpoints.entrySet()) {
                List l = (List)e.getValue();
                for (Object endpoint : l) {
                    Component c = this.endpointToComponent.remove(endpoint);
                    ((DefaultComponent)c).removeEndpoint((Endpoint)endpoint);
                }
            }
        }
        if (this.components != null) {
            for (Map.Entry e : this.components.entrySet()) {
                String name = (String)e.getKey();
                this.getContainer().deactivateComponent(name);
            }
        }
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                this.getContainer().removeListener(this.listeners[i]);
            }
        }
        if (this.services != null) {
            for (int i = 0; i < this.services.length; ++i) {
                this.services[i].stop();
                this.services[i].shutDown();
            }
        }
    }

    public ExchangeProcessor getProcessor() {
        return null;
    }

    public MessageExchange.Role getRole() {
        return null;
    }

    private void initEndpoints() throws Exception {
        if (this.components == null) {
            this.components = new LinkedHashMap();
        }
        Method getEndpointClassesMethod = DefaultComponent.class.getDeclaredMethod("getEndpointClasses", null);
        getEndpointClassesMethod.setAccessible(true);
        for (Map.Entry e : this.endpoints.entrySet()) {
            String key = (String)e.getKey();
            List l = (List)e.getValue();
            for (Object endpoint : l) {
                Component c = null;
                if (key.length() > 0) {
                    Component comp = (Component)this.components.get(key);
                    if (comp == null) {
                        throw new JBIException("Could not find component '" + key + "' specified for endpoint");
                    }
                    c = comp;
                } else {
                    for (Component comp : this.components.values()) {
                        Class[] endpointClasses = (Class[])getEndpointClassesMethod.invoke((Object)comp, null);
                        if (!this.isKnownEndpoint(endpoint, endpointClasses)) continue;
                        c = comp;
                        break;
                    }
                    if (c == null && (c = this.getComponentForEndpoint(getEndpointClassesMethod, endpoint)) == null) {
                        throw new JBIException("Unable to find a component for endpoint class: " + endpoint.getClass());
                    }
                }
                ((DefaultComponent)c).addEndpoint((Endpoint)endpoint);
                this.endpointToComponent.put(endpoint, c);
            }
        }
    }

    private Component getComponentForEndpoint(Method getEndpointClassesMethod, Object endpoint) throws Exception {
        Properties namespaces = PropertiesLoaderUtils.loadAllProperties((String)"META-INF/spring.handlers");
        for (String string : namespaces.keySet()) {
            Class compClass;
            Component comp;
            Class[] endpointClasses;
            String uri = NamespaceHelper.createDiscoveryPathName((String)string);
            Properties props = PropertiesLoaderUtils.loadAllProperties((String)uri);
            String compClassName = props.getProperty("component");
            if (compClassName == null || !this.isKnownEndpoint(endpoint, endpointClasses = (Class[])getEndpointClassesMethod.invoke((Object)(comp = (Component)BeanUtils.instantiateClass((Class)(compClass = ClassUtils.forName((String)compClassName)))), null))) continue;
            String name = this.chooseComponentName(comp);
            this.getContainer().activateComponent(comp, name);
            this.components.put(name, comp);
            return comp;
        }
        return null;
    }

    private String chooseComponentName(Object c) {
        String className = c.getClass().getName();
        if (className.startsWith("org.apache.servicemix.")) {
            int idx1 = className.lastIndexOf(46);
            int idx0 = className.lastIndexOf(46, idx1 - 1);
            String name = "servicemix-" + className.substring(idx0 + 1, idx1);
            return name + "-" + this.createComponentID();
        }
        return this.createComponentID();
    }

    private boolean isKnownEndpoint(Object endpoint, Class[] knownClasses) {
        if (knownClasses != null) {
            for (int i = 0; i < knownClasses.length; ++i) {
                if (!knownClasses[i].isInstance(endpoint)) continue;
                return true;
            }
        }
        return false;
    }

    private JBIContainer getContainer() {
        ComponentContext context = this.getServiceUnit().getComponent().getComponentContext();
        if (context instanceof ComponentContextImpl) {
            return ((ComponentContextImpl)context).getContainer();
        }
        throw new IllegalStateException("LwContainer component can only be deployed in ServiceMix");
    }

    protected String createComponentID() {
        return this.idGenerator.generateId();
    }

    public void process(MessageExchange exchange) throws Exception {
        this.getProcessor().process(exchange);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }
}

