/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.lwcontainer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.jbi.management.DeploymentException;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.xbean.AbstractXBeanDeployer;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.SpringServiceUnitContainer;
import org.apache.servicemix.lwcontainer.LwContainerEndpoint;
import org.apache.servicemix.lwcontainer.LwContainerExtra;
import org.springframework.context.support.AbstractXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LwContainerXBeanDeployer
extends AbstractXBeanDeployer {
    public LwContainerXBeanDeployer(BaseComponent component) {
        super((ServiceMixComponent)component);
    }

    protected String getXBeanFile() {
        return "servicemix";
    }

    protected Collection<Endpoint> getServices(AbstractXmlApplicationContext applicationContext) throws Exception {
        try {
            ArrayList<Endpoint> services = new ArrayList<Endpoint>();
            Map containers = applicationContext.getBeansOfType(SpringServiceUnitContainer.class);
            for (SpringServiceUnitContainer suContainer : containers.values()) {
                ActivationSpec[] specs = suContainer.getActivationSpecs();
                if (specs != null) {
                    for (int i = 0; i < specs.length; ++i) {
                        services.add((Endpoint)new LwContainerEndpoint(specs[i]));
                    }
                }
                if (suContainer.getComponents() == null && suContainer.getEndpoints() == null && suContainer.getListeners() == null && suContainer.getServices() == null) continue;
                services.add((Endpoint)new LwContainerExtra(suContainer.getComponents(), suContainer.getEndpoints(), suContainer.getListeners(), suContainer.getServices()));
            }
            return services;
        }
        catch (Exception e) {
            throw new RuntimeException("Can not find 'jbi' bean", e);
        }
    }

    protected void validate(ServiceUnit su) throws DeploymentException {
    }
}

