/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.mail;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import javax.xml.transform.Source;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.mail.MailEndpointType;
import org.apache.servicemix.mail.marshaler.AbstractMailMarshaler;
import org.apache.servicemix.mail.marshaler.DefaultMailMarshaler;
import org.apache.servicemix.mail.utils.IgnoreList;
import org.apache.servicemix.mail.utils.MailConnectionConfiguration;
import org.apache.servicemix.mail.utils.MailUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSenderEndpoint
extends ProviderEndpoint
implements MailEndpointType {
    private final Logger logger = LoggerFactory.getLogger(MailSenderEndpoint.class);
    private AbstractMailMarshaler marshaler = new DefaultMailMarshaler();
    private MailConnectionConfiguration config;
    private String customTrustManagers;
    private String connection;
    private String sender;
    private String receiver;
    private boolean debugMode;
    private Map<String, String> customProperties = new HashMap<String, String>();
    private IgnoreList ignoreMessageProperties = new IgnoreList();

    public void validate() throws DeploymentException {
        super.validate();
        if (this.config == null || this.connection == null) {
            throw new DeploymentException("No valid connection uri provided.");
        }
    }

    protected void processInOnly(MessageExchange exchange, NormalizedMessage in) throws Exception {
        if (exchange.getStatus() != ExchangeStatus.DONE && exchange.getStatus() != ExchangeStatus.ERROR) {
            if (exchange.getFault() != null) {
                exchange.setStatus(ExchangeStatus.DONE);
                this.getChannel().send(exchange);
            } else {
                try {
                    this.sendMail(exchange, in);
                }
                catch (MessagingException mex) {
                    this.logger.error("Error sending mail...", (Throwable)mex);
                    throw mex;
                }
                finally {
                    this.marshaler.cleanUpResources(exchange.getExchangeId());
                }
            }
        }
    }

    protected void processInOut(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        if (exchange.getStatus() != ExchangeStatus.DONE && exchange.getStatus() != ExchangeStatus.ERROR) {
            if (exchange.getFault() != null) {
                exchange.setStatus(ExchangeStatus.DONE);
                this.getChannel().send(exchange);
            } else {
                try {
                    this.sendMail(exchange, in);
                    out.setContent((Source)new StringSource("<ack />"));
                }
                catch (MessagingException mex) {
                    this.logger.error("Error sending mail...", (Throwable)mex);
                    throw mex;
                }
                finally {
                    this.marshaler.cleanUpResources(exchange.getExchangeId());
                }
            }
        }
    }

    private String getUsername(NormalizedMessage in) {
        if (in.getProperty("org.apache.servicemix.mail.username") != null) {
            return (String)in.getProperty("org.apache.servicemix.mail.username");
        }
        return this.config.getUsername();
    }

    private String getPassword(NormalizedMessage in) {
        if (in.getProperty("org.apache.servicemix.mail.password") != null) {
            return (String)in.getProperty("org.apache.servicemix.mail.password");
        }
        return this.config.getPassword();
    }

    private String getProtocol(NormalizedMessage in) {
        if (in.getProperty("org.apache.servicemix.mail.protocol") != null) {
            return (String)in.getProperty("org.apache.servicemix.mail.protocol");
        }
        return this.config.getProtocol();
    }

    private String getHost(NormalizedMessage in) {
        if (in.getProperty("org.apache.servicemix.mail.host") != null) {
            return (String)in.getProperty("org.apache.servicemix.mail.host");
        }
        return this.config.getHost();
    }

    private int getPort(NormalizedMessage in) {
        if (in.getProperty("org.apache.servicemix.mail.port") != null) {
            return (Integer)in.getProperty("org.apache.servicemix.mail.port");
        }
        return this.config.getPort();
    }

    private void sendMail(MessageExchange exchange, NormalizedMessage in) throws Exception {
        Properties props = MailUtils.getPropertiesForProtocol(this.config, this.customTrustManagers);
        props.put("mail.debug", this.isDebugMode() ? "true" : "false");
        String user = this.getUsername(in);
        String passwd = this.getPassword(in);
        String protocol = this.getProtocol(in);
        String host = this.getHost(in);
        int port = this.getPort(in);
        this.applyCustomProperties(props);
        Session session = Session.getInstance((Properties)props, (Authenticator)this.config.getAuthenticator(user, passwd));
        session.setDebug(this.debugMode);
        Transport transport = session.getTransport(protocol);
        transport.connect(host, port, user, passwd);
        MimeMessage msg = new MimeMessage(session);
        this.handleIgnoreProperties(in);
        this.marshaler.convertJBIToMail(msg, exchange, in, this.sender, this.receiver);
        transport.sendMessage((Message)msg, msg.getAllRecipients());
        transport.close();
    }

    private void handleIgnoreProperties(NormalizedMessage in) {
        if (this.getIgnoreMessageProperties() != null && this.getIgnoreMessageProperties().size() > 0) {
            for (String key : this.getIgnoreMessageProperties()) {
                if (in.getProperty(key) == null) continue;
                in.setProperty(key, null);
            }
        }
    }

    private void applyCustomProperties(Properties props) {
        if (this.customProperties != null) {
            props.putAll(this.customProperties);
        }
    }

    public AbstractMailMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(AbstractMailMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
        try {
            this.config = MailUtils.configure(this.connection);
        }
        catch (ParseException ex) {
            this.logger.error("The configured connection uri is invalid", (Throwable)ex);
        }
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public String getCustomTrustManagers() {
        return this.customTrustManagers;
    }

    public void setCustomTrustManagers(String customTrustManagers) {
        this.customTrustManagers = customTrustManagers;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    public IgnoreList getIgnoreMessageProperties() {
        return this.ignoreMessageProperties;
    }

    public void setIgnoreMessageProperties(IgnoreList ignoreMessageProperties) {
        this.ignoreMessageProperties = ignoreMessageProperties;
    }
}

