/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.prevayler;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.SimpleStep;
import com.opensymphony.workflow.spi.SimpleWorkflowEntry;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import com.opensymphony.workflow.spi.prevayler.QueryLogic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WorkflowSystem
implements WorkflowStore,
Serializable {
    private HashMap _currentStepsCache = new HashMap();
    private HashMap _entryCache = new HashMap();
    private HashMap _historyStepsCache = new HashMap();
    private HashMap _propertySetCache = new HashMap();
    private transient QueryLogic _queryLogic = new QueryLogic(this);
    private long _globalEntryId = 1L;
    private long _globalStepId = 1L;

    public void setEntryState(long entryId, int state) throws StoreException {
        SimpleWorkflowEntry entry = (SimpleWorkflowEntry)this.findEntry(entryId);
        entry.setState(state);
    }

    public PropertySet getPropertySet(long entryId) throws StoreException {
        PropertySet ps = (PropertySet)this._propertySetCache.get(new Long(entryId));
        if (ps == null) {
            ps = PropertySetManager.getInstance((String)"serializable", null);
            this._propertySetCache.put(new Long(entryId), ps);
        }
        return ps;
    }

    public Step createCurrentStep(long entryId, int stepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) throws StoreException {
        long id = this._globalStepId++;
        SimpleStep step = new SimpleStep(id, entryId, stepId, 0, owner, startDate, dueDate, null, status, previousIds, null);
        ArrayList<SimpleStep> currentSteps = (ArrayList<SimpleStep>)this._currentStepsCache.get(new Long(entryId));
        if (currentSteps == null) {
            currentSteps = new ArrayList<SimpleStep>();
            this._currentStepsCache.put(new Long(entryId), currentSteps);
        }
        currentSteps.add(step);
        return step;
    }

    public WorkflowEntry createEntry(String workflowName) throws StoreException {
        long id = this._globalEntryId++;
        SimpleWorkflowEntry entry = new SimpleWorkflowEntry(id, workflowName, 0);
        this._entryCache.put(new Long(id), entry);
        return entry;
    }

    public List findCurrentSteps(long entryId) throws StoreException {
        ArrayList currentSteps = (ArrayList)this._currentStepsCache.get(new Long(entryId));
        if (currentSteps == null) {
            currentSteps = new ArrayList();
            this._currentStepsCache.put(new Long(entryId), currentSteps);
        }
        return currentSteps;
    }

    public WorkflowEntry findEntry(long entryId) throws StoreException {
        return (WorkflowEntry)this._entryCache.get(new Long(entryId));
    }

    public List findHistorySteps(long entryId) throws StoreException {
        ArrayList historySteps = (ArrayList)this._historyStepsCache.get(new Long(entryId));
        if (historySteps == null) {
            historySteps = new ArrayList();
            this._historyStepsCache.put(new Long(entryId), historySteps);
        }
        return historySteps;
    }

    public void init(Map props) throws StoreException {
    }

    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) throws StoreException {
        List currentSteps = (List)this._currentStepsCache.get(new Long(step.getEntryId()));
        Iterator iterator = currentSteps.iterator();
        while (iterator.hasNext()) {
            SimpleStep theStep = (SimpleStep)iterator.next();
            if (theStep.getId() != step.getId()) continue;
            theStep.setStatus(status);
            theStep.setActionId(actionId);
            theStep.setFinishDate(finishDate);
            theStep.setCaller(caller);
            return theStep;
        }
        return null;
    }

    public void moveToHistory(Step step) throws StoreException {
        List currentSteps = (List)this._currentStepsCache.get(new Long(step.getEntryId()));
        ArrayList<SimpleStep> historySteps = (ArrayList<SimpleStep>)this._historyStepsCache.get(new Long(step.getEntryId()));
        if (historySteps == null) {
            historySteps = new ArrayList<SimpleStep>();
            this._historyStepsCache.put(new Long(step.getEntryId()), historySteps);
        }
        SimpleStep simpleStep = (SimpleStep)step;
        Iterator iterator = currentSteps.iterator();
        while (iterator.hasNext()) {
            Step currentStep = (Step)iterator.next();
            if (simpleStep.getId() != currentStep.getId()) continue;
            iterator.remove();
            historySteps.add(simpleStep);
            break;
        }
    }

    public List query(WorkflowQuery query) throws StoreException {
        ArrayList<Long> results = new ArrayList<Long>();
        Iterator iterator = this._entryCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            Long entryId = (Long)mapEntry.getKey();
            if (!this._queryLogic.query(entryId, query)) continue;
            results.add(entryId);
        }
        return results;
    }

    public List query(WorkflowExpressionQuery query) throws StoreException {
        ArrayList<Long> results = new ArrayList<Long>();
        Iterator iterator = this._entryCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            Long entryId = (Long)mapEntry.getKey();
            if (!this._queryLogic.query(entryId, query)) continue;
            results.add(entryId);
        }
        return results;
    }
}

