/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DTDEntityResolver;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.JoinDescriptor;
import com.opensymphony.workflow.loader.RegisterDescriptor;
import com.opensymphony.workflow.loader.SplitDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.ValidationHelper;
import com.opensymphony.workflow.loader.WorkflowLoader;
import com.opensymphony.workflow.loader.XMLUtil;
import com.opensymphony.workflow.util.Validatable;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WorkflowDescriptor
extends AbstractDescriptor
implements Validatable {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String DOCTYPE_DECL = "<!DOCTYPE workflow PUBLIC \"-//OpenSymphony Group//DTD OSWorkflow 2.7//EN\" \"http://www.opensymphony.com/osworkflow/workflow_2_7.dtd\">";
    protected List commonActionsList = new ArrayList();
    protected List globalActions = new ArrayList();
    protected List initialActions = new ArrayList();
    protected List joins = new ArrayList();
    protected List registers = new ArrayList();
    protected List splits = new ArrayList();
    protected List steps = new ArrayList();
    protected Map commonActions = new HashMap();
    protected Map metaAttributes = new HashMap();
    protected Map timerFunctions = new HashMap();

    public WorkflowDescriptor() {
    }

    public WorkflowDescriptor(Element root) {
        this.init(root);
    }

    public ActionDescriptor getAction(int id) {
        Iterator iterator = this.globalActions.iterator();
        while (iterator.hasNext()) {
            ActionDescriptor actionDescriptor = (ActionDescriptor)iterator.next();
            if (actionDescriptor.getId() != id) continue;
            return actionDescriptor;
        }
        iterator = this.steps.iterator();
        while (iterator.hasNext()) {
            StepDescriptor stepDescriptor = (StepDescriptor)iterator.next();
            ActionDescriptor actionDescriptor = stepDescriptor.getAction(id);
            if (actionDescriptor == null) continue;
            return actionDescriptor;
        }
        return null;
    }

    public Map getCommonActions() {
        return this.commonActions;
    }

    public List getGlobalActions() {
        return this.globalActions;
    }

    public ActionDescriptor getInitialAction(int id) {
        Iterator iterator = this.initialActions.iterator();
        while (iterator.hasNext()) {
            ActionDescriptor actionDescriptor = (ActionDescriptor)iterator.next();
            if (actionDescriptor.getId() != id) continue;
            return actionDescriptor;
        }
        return null;
    }

    public List getInitialActions() {
        return this.initialActions;
    }

    public JoinDescriptor getJoin(int id) {
        Iterator iterator = this.joins.iterator();
        while (iterator.hasNext()) {
            JoinDescriptor joinDescriptor = (JoinDescriptor)iterator.next();
            if (joinDescriptor.getId() != id) continue;
            return joinDescriptor;
        }
        return null;
    }

    public List getJoins() {
        return this.joins;
    }

    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    public List getRegisters() {
        return this.registers;
    }

    public SplitDescriptor getSplit(int id) {
        Iterator iterator = this.splits.iterator();
        while (iterator.hasNext()) {
            SplitDescriptor splitDescriptor = (SplitDescriptor)iterator.next();
            if (splitDescriptor.getId() != id) continue;
            return splitDescriptor;
        }
        return null;
    }

    public List getSplits() {
        return this.splits;
    }

    public StepDescriptor getStep(int id) {
        Iterator iterator = this.steps.iterator();
        while (iterator.hasNext()) {
            StepDescriptor step = (StepDescriptor)iterator.next();
            if (step.getId() != id) continue;
            return step;
        }
        return null;
    }

    public List getSteps() {
        return this.steps;
    }

    public FunctionDescriptor setTriggerFunction(int id, FunctionDescriptor descriptor) {
        return this.timerFunctions.put(new Integer(id), descriptor);
    }

    public FunctionDescriptor getTriggerFunction(int id) {
        return (FunctionDescriptor)this.timerFunctions.get(new Integer(id));
    }

    public Map getTriggerFunctions() {
        return this.timerFunctions;
    }

    public void addCommonAction(ActionDescriptor descriptor) {
        this.addAction(this.commonActions, descriptor);
        this.addAction(this.commonActionsList, descriptor);
    }

    public void addGlobalAction(ActionDescriptor descriptor) {
        this.addAction(this.globalActions, descriptor);
    }

    public void addInitialAction(ActionDescriptor descriptor) {
        this.addAction(this.initialActions, descriptor);
    }

    public void addJoin(JoinDescriptor descriptor) {
        if (this.getJoin(descriptor.getId()) != null) {
            throw new IllegalArgumentException("Join with id " + descriptor.getId() + " already exists");
        }
        this.joins.add(descriptor);
    }

    public void addSplit(SplitDescriptor descriptor) {
        if (this.getSplit(descriptor.getId()) != null) {
            throw new IllegalArgumentException("Split with id " + descriptor.getId() + " already exists");
        }
        this.splits.add(descriptor);
    }

    public void addStep(StepDescriptor descriptor) {
        if (this.getStep(descriptor.getId()) != null) {
            throw new IllegalArgumentException("Step with id " + descriptor.getId() + " already exists");
        }
        this.steps.add(descriptor);
    }

    public boolean removeAction(ActionDescriptor actionToRemove) {
        Iterator iterator = this.getGlobalActions().iterator();
        while (iterator.hasNext()) {
            ActionDescriptor actionDescriptor = (ActionDescriptor)iterator.next();
            if (actionDescriptor.getId() != actionToRemove.getId()) continue;
            this.getGlobalActions().remove(actionDescriptor);
            return true;
        }
        iterator = this.getSteps().iterator();
        while (iterator.hasNext()) {
            StepDescriptor stepDescriptor = (StepDescriptor)iterator.next();
            ActionDescriptor actionDescriptor = stepDescriptor.getAction(actionToRemove.getId());
            if (actionDescriptor == null) continue;
            stepDescriptor.getActions().remove(actionDescriptor);
            return true;
        }
        return false;
    }

    public void validate() throws InvalidWorkflowDescriptorException {
        ValidationHelper.validate(this.getRegisters());
        ValidationHelper.validate(this.getTriggerFunctions().values());
        ValidationHelper.validate(this.getGlobalActions());
        ValidationHelper.validate(this.getInitialActions());
        ValidationHelper.validate(this.getCommonActions().values());
        ValidationHelper.validate(this.getSteps());
        ValidationHelper.validate(this.getSplits());
        ValidationHelper.validate(this.getJoins());
        HashSet<Integer> actions = new HashSet<Integer>();
        Iterator i = this.globalActions.iterator();
        while (i.hasNext()) {
            ActionDescriptor action = (ActionDescriptor)i.next();
            actions.add(new Integer(action.getId()));
        }
        i = this.getSteps().iterator();
        while (i.hasNext()) {
            StepDescriptor step = (StepDescriptor)i.next();
            Iterator j = step.getActions().iterator();
            while (j.hasNext()) {
                ActionDescriptor action = (ActionDescriptor)j.next();
                if (this.getCommonActions().containsKey(new Integer(action.getId())) || actions.add(new Integer(action.getId()))) continue;
                throw new InvalidWorkflowDescriptorException("Duplicate occurance of action ID " + action.getId() + " found in step " + step.getId());
            }
        }
        this.validateDTD();
    }

    public void writeXML(PrintWriter out, int indent) {
        int i;
        ActionDescriptor action;
        int i2;
        XMLUtil.printIndent(out, indent++);
        out.println("<workflow>");
        Iterator iter = this.metaAttributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            XMLUtil.printIndent(out, indent);
            out.print("<meta name=\"");
            out.print(entry.getKey());
            out.print("\">");
            out.print(entry.getValue());
            out.println("</meta>");
        }
        if (this.registers.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<registers>");
            for (int i3 = 0; i3 < this.registers.size(); ++i3) {
                RegisterDescriptor register = (RegisterDescriptor)this.registers.get(i3);
                register.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</registers>");
        }
        XMLUtil.printIndent(out, indent++);
        out.println("<initial-actions>");
        for (i2 = 0; i2 < this.initialActions.size(); ++i2) {
            action = (ActionDescriptor)this.initialActions.get(i2);
            action.writeXML(out, indent);
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</initial-actions>");
        if (this.globalActions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<global-actions>");
            for (i2 = 0; i2 < this.globalActions.size(); ++i2) {
                action = (ActionDescriptor)this.globalActions.get(i2);
                action.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</global-actions>");
        }
        if (this.commonActions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<common-actions>");
            Iterator commonActionsItr = this.getCommonActions().values().iterator();
            while (commonActionsItr.hasNext()) {
                action = (ActionDescriptor)commonActionsItr.next();
                action.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</common-actions>");
        }
        XMLUtil.printIndent(out, indent++);
        out.println("<steps>");
        for (i = 0; i < this.steps.size(); ++i) {
            StepDescriptor step = (StepDescriptor)this.steps.get(i);
            step.writeXML(out, indent);
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</steps>");
        if (this.splits.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<splits>");
            for (i = 0; i < this.splits.size(); ++i) {
                SplitDescriptor split = (SplitDescriptor)this.splits.get(i);
                split.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</splits>");
        }
        if (this.joins.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            out.println("<joins>");
            for (i = 0; i < this.joins.size(); ++i) {
                JoinDescriptor join = (JoinDescriptor)this.joins.get(i);
                join.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</joins>");
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</workflow>");
    }

    protected void init(Element root) {
        Element joinsElement;
        Element timerFunctionsElement;
        Element commonActionsElement;
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("meta")) continue;
            Element meta = (Element)child;
            String value = XMLUtil.getText(meta);
            this.metaAttributes.put(meta.getAttribute("name"), value);
        }
        Element r = XMLUtil.getChildElement(root, "registers");
        if (r != null) {
            List registers = XMLUtil.getChildElements(r, "register");
            for (int i = 0; i < registers.size(); ++i) {
                Element register = (Element)registers.get(i);
                RegisterDescriptor registerDescriptor = new RegisterDescriptor(register);
                registerDescriptor.setParent(this);
                this.registers.add(registerDescriptor);
            }
        }
        Element intialActionsElement = XMLUtil.getChildElement(root, "initial-actions");
        List initialActions = XMLUtil.getChildElements(intialActionsElement, "action");
        for (int i = 0; i < initialActions.size(); ++i) {
            Element initialAction = (Element)initialActions.get(i);
            ActionDescriptor actionDescriptor = new ActionDescriptor(initialAction);
            actionDescriptor.setParent(this);
            this.initialActions.add(actionDescriptor);
        }
        Element globalActionsElement = XMLUtil.getChildElement(root, "global-actions");
        if (globalActionsElement != null) {
            List globalActions = XMLUtil.getChildElements(globalActionsElement, "action");
            for (int i = 0; i < globalActions.size(); ++i) {
                Element globalAction = (Element)globalActions.get(i);
                ActionDescriptor actionDescriptor = new ActionDescriptor(globalAction);
                actionDescriptor.setParent(this);
                this.globalActions.add(actionDescriptor);
            }
        }
        if ((commonActionsElement = XMLUtil.getChildElement(root, "common-actions")) != null) {
            List commonActions = XMLUtil.getChildElements(commonActionsElement, "action");
            for (int i = 0; i < commonActions.size(); ++i) {
                Element commonAction = (Element)commonActions.get(i);
                ActionDescriptor actionDescriptor = new ActionDescriptor(commonAction);
                actionDescriptor.setParent(this);
                this.addCommonAction(actionDescriptor);
            }
        }
        if ((timerFunctionsElement = XMLUtil.getChildElement(root, "trigger-functions")) != null) {
            List timerFunctions = XMLUtil.getChildElements(timerFunctionsElement, "trigger-function");
            for (int i = 0; i < timerFunctions.size(); ++i) {
                Element timerFunction = (Element)timerFunctions.get(i);
                Integer id = new Integer(timerFunction.getAttribute("id"));
                FunctionDescriptor function = new FunctionDescriptor(XMLUtil.getChildElement(timerFunction, "function"));
                function.setParent(this);
                this.timerFunctions.put(id, function);
            }
        }
        Element stepsElement = XMLUtil.getChildElement(root, "steps");
        List steps = XMLUtil.getChildElements(stepsElement, "step");
        for (int i = 0; i < steps.size(); ++i) {
            Element step = (Element)steps.get(i);
            StepDescriptor stepDescriptor = new StepDescriptor(step, this);
            this.steps.add(stepDescriptor);
        }
        Element splitsElement = XMLUtil.getChildElement(root, "splits");
        if (splitsElement != null) {
            List split = XMLUtil.getChildElements(splitsElement, "split");
            for (int i = 0; i < split.size(); ++i) {
                Element s = (Element)split.get(i);
                SplitDescriptor splitDescriptor = new SplitDescriptor(s);
                splitDescriptor.setParent(this);
                this.splits.add(splitDescriptor);
            }
        }
        if ((joinsElement = XMLUtil.getChildElement(root, "joins")) != null) {
            List join = XMLUtil.getChildElements(joinsElement, "join");
            for (int i = 0; i < join.size(); ++i) {
                Element s = (Element)join.get(i);
                JoinDescriptor joinDescriptor = new JoinDescriptor(s);
                joinDescriptor.setParent(this);
                this.joins.add(joinDescriptor);
            }
        }
    }

    private void addAction(Object actionsCollectionOrMap, ActionDescriptor descriptor) {
        if (this.getAction(descriptor.getId()) != null) {
            throw new IllegalArgumentException("action with id " + descriptor.getId() + " already exists for this step.");
        }
        if (actionsCollectionOrMap instanceof Map) {
            ((Map)actionsCollectionOrMap).put(new Integer(descriptor.getId()), descriptor);
        } else {
            ((Collection)actionsCollectionOrMap).add(descriptor);
        }
    }

    private void validateDTD() throws InvalidWorkflowDescriptorException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        writer.println(XML_HEADER);
        writer.println(DOCTYPE_DECL);
        this.writeXML(writer, 0);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new DTDEntityResolver());
            WorkflowLoader.AllExceptionsErrorHandler errorHandler = new WorkflowLoader.AllExceptionsErrorHandler();
            db.setErrorHandler(errorHandler);
            db.parse(new InputSource(new StringReader(sw.toString())));
            if (errorHandler.getExceptions().size() > 0) {
                throw new InvalidWorkflowDescriptorException(errorHandler.getExceptions().toString());
            }
        }
        catch (InvalidWorkflowDescriptorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidWorkflowDescriptorException(e.toString());
        }
    }
}

