/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.jdbc;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.Expression;
import com.opensymphony.workflow.query.FieldExpression;
import com.opensymphony.workflow.query.NestedExpression;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.SimpleStep;
import com.opensymphony.workflow.spi.SimpleWorkflowEntry;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCWorkflowStore
implements WorkflowStore {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$workflow$spi$jdbc$JDBCWorkflowStore == null ? (class$com$opensymphony$workflow$spi$jdbc$JDBCWorkflowStore = JDBCWorkflowStore.class$("com.opensymphony.workflow.spi.jdbc.JDBCWorkflowStore")) : class$com$opensymphony$workflow$spi$jdbc$JDBCWorkflowStore));
    protected DataSource ds;
    protected String currentPrevTable;
    protected String currentTable;
    protected String entryId;
    protected String entryName;
    protected String entrySequence;
    protected String entryState;
    protected String entryTable;
    protected String historyPrevTable;
    protected String historyTable;
    protected String stepActionId;
    protected String stepCaller;
    protected String stepDueDate;
    protected String stepEntryId;
    protected String stepFinishDate;
    protected String stepId;
    protected String stepOwner;
    protected String stepPreviousId;
    protected String stepSequence;
    protected String stepStartDate;
    protected String stepStatus;
    protected String stepStepId;
    protected boolean closeConnWhenDone = false;
    static /* synthetic */ Class class$com$opensymphony$workflow$spi$jdbc$JDBCWorkflowStore;

    public void setEntryState(long id, int state) throws StoreException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            String sql = "UPDATE " + this.entryTable + " SET " + this.entryState + " = ? WHERE " + this.entryId + " = ?";
            ps = conn.prepareStatement(sql);
            ps.setInt(1, state);
            ps.setLong(2, id);
            ps.executeUpdate();
            this.cleanup(conn, ps, null);
        }
        catch (SQLException e) {
            try {
                throw new StoreException("Unable to update state for workflow instance #" + id + " to " + state, e);
            }
            catch (Throwable throwable) {
                this.cleanup(conn, ps, null);
                throw throwable;
            }
        }
    }

    public PropertySet getPropertySet(long entryId) {
        HashMap<String, String> args = new HashMap<String, String>(1);
        args.put("globalKey", "osff_" + entryId);
        return PropertySetManager.getInstance((String)"jdbc", args);
    }

    public Step createCurrentStep(long entryId, int wfStepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) throws StoreException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            long id = this.createCurrentStep(conn, entryId, wfStepId, owner, startDate, dueDate, status);
            this.addPreviousSteps(conn, id, previousIds);
            SimpleStep simpleStep = new SimpleStep(id, entryId, wfStepId, 0, owner, startDate, dueDate, null, status, previousIds, null);
            return simpleStep;
        }
        catch (SQLException e) {
            throw new StoreException("Unable to create current step for workflow instance #" + entryId, e);
        }
        finally {
            this.cleanup(conn, null, null);
        }
    }

    public WorkflowEntry createEntry(String workflowName) throws StoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            String sql = "INSERT INTO " + this.entryTable + " (" + this.entryId + ", " + this.entryName + ", " + this.entryState + ") VALUES (?,?,?)";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing SQL statement: " + sql));
            }
            stmt = conn.prepareStatement(sql);
            long id = this.getNextEntrySequence(conn);
            stmt.setLong(1, id);
            stmt.setString(2, workflowName);
            stmt.setInt(3, 0);
            stmt.executeUpdate();
            SimpleWorkflowEntry simpleWorkflowEntry = new SimpleWorkflowEntry(id, workflowName, 0);
            this.cleanup(conn, stmt, null);
            return simpleWorkflowEntry;
        }
        catch (SQLException e) {
            try {
                throw new StoreException("Error creating new workflow instance", e);
            }
            catch (Throwable throwable) {
                this.cleanup(conn, stmt, null);
                throw throwable;
            }
        }
    }

    public List findCurrentSteps(long entryId) throws StoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rset = null;
        PreparedStatement stmt2 = null;
        try {
            conn = this.getConnection();
            String sql = "SELECT " + this.stepId + ", " + this.stepStepId + ", " + this.stepActionId + ", " + this.stepOwner + ", " + this.stepStartDate + ", " + this.stepDueDate + ", " + this.stepFinishDate + ", " + this.stepStatus + ", " + this.stepCaller + " FROM " + this.currentTable + " WHERE " + this.stepEntryId + " = ?";
            String sql2 = "SELECT " + this.stepPreviousId + " FROM " + this.currentPrevTable + " WHERE " + this.stepId + " = ?";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing SQL statement: " + sql));
            }
            stmt = conn.prepareStatement(sql);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing SQL statement: " + sql2));
            }
            stmt2 = conn.prepareStatement(sql2);
            stmt.setLong(1, entryId);
            rset = stmt.executeQuery();
            ArrayList<SimpleStep> currentSteps = new ArrayList<SimpleStep>();
            while (rset.next()) {
                long id = rset.getLong(1);
                int stepId = rset.getInt(2);
                int actionId = rset.getInt(3);
                String owner = rset.getString(4);
                Timestamp startDate = rset.getTimestamp(5);
                Timestamp dueDate = rset.getTimestamp(6);
                Timestamp finishDate = rset.getTimestamp(7);
                String status = rset.getString(8);
                String caller = rset.getString(9);
                ArrayList<Long> prevIdsList = new ArrayList<Long>();
                stmt2.setLong(1, id);
                ResultSet rs = stmt2.executeQuery();
                while (rs.next()) {
                    long prevId = rs.getLong(1);
                    prevIdsList.add(new Long(prevId));
                }
                long[] prevIds = new long[prevIdsList.size()];
                int i = 0;
                Iterator iterator = prevIdsList.iterator();
                while (iterator.hasNext()) {
                    Long aLong = (Long)iterator.next();
                    prevIds[i] = aLong;
                    ++i;
                }
                SimpleStep step = new SimpleStep(id, entryId, stepId, actionId, owner, startDate, dueDate, finishDate, status, prevIds, caller);
                currentSteps.add(step);
            }
            ArrayList<SimpleStep> arrayList = currentSteps;
            Object var27_27 = null;
            this.cleanup(null, stmt2, null);
            this.cleanup(conn, stmt, rset);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new StoreException("Unable to locate current steps for workflow instance #" + entryId, e);
            }
            catch (Throwable throwable) {
                Object var27_28 = null;
                this.cleanup(null, stmt2, null);
                this.cleanup(conn, stmt, rset);
                throw throwable;
            }
        }
    }

    public WorkflowEntry findEntry(long theEntryId) throws StoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            conn = this.getConnection();
            String sql = "SELECT " + this.entryName + ", " + this.entryState + " FROM " + this.entryTable + " WHERE " + this.entryId + " = ?";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing SQL statement: " + sql));
            }
            stmt = conn.prepareStatement(sql);
            stmt.setLong(1, theEntryId);
            rset = stmt.executeQuery();
            rset.next();
            String workflowName = rset.getString(1);
            int state = rset.getInt(2);
            SimpleWorkflowEntry simpleWorkflowEntry = new SimpleWorkflowEntry(theEntryId, workflowName, state);
            this.cleanup(conn, stmt, rset);
            return simpleWorkflowEntry;
        }
        catch (SQLException e) {
            try {
                throw new StoreException("Error finding workflow instance #" + this.entryId);
            }
            catch (Throwable throwable) {
                this.cleanup(conn, stmt, rset);
                throw throwable;
            }
        }
    }

    public List findHistorySteps(long entryId) throws StoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        PreparedStatement stmt2 = null;
        ResultSet rset = null;
        try {
            conn = this.getConnection();
            String sql = "SELECT " + this.stepId + ", " + this.stepStepId + ", " + this.stepActionId + ", " + this.stepOwner + ", " + this.stepStartDate + ", " + this.stepDueDate + ", " + this.stepFinishDate + ", " + this.stepStatus + ", " + this.stepCaller + " FROM " + this.historyTable + " WHERE " + this.stepEntryId + " = ? ORDER BY " + this.stepId + " DESC";
            String sql2 = "SELECT " + this.stepPreviousId + " FROM " + this.historyPrevTable + " WHERE " + this.stepId + " = ?";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing SQL statement: " + sql));
            }
            stmt = conn.prepareStatement(sql);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing SQL statement: " + sql2));
            }
            stmt2 = conn.prepareStatement(sql2);
            stmt.setLong(1, entryId);
            rset = stmt.executeQuery();
            ArrayList<SimpleStep> currentSteps = new ArrayList<SimpleStep>();
            while (rset.next()) {
                long id = rset.getLong(1);
                int stepId = rset.getInt(2);
                int actionId = rset.getInt(3);
                String owner = rset.getString(4);
                Timestamp startDate = rset.getTimestamp(5);
                Timestamp dueDate = rset.getTimestamp(6);
                Timestamp finishDate = rset.getTimestamp(7);
                String status = rset.getString(8);
                String caller = rset.getString(9);
                ArrayList<Long> prevIdsList = new ArrayList<Long>();
                stmt2.setLong(1, id);
                ResultSet rs = stmt2.executeQuery();
                while (rs.next()) {
                    long prevId = rs.getLong(1);
                    prevIdsList.add(new Long(prevId));
                }
                long[] prevIds = new long[prevIdsList.size()];
                int i = 0;
                Iterator iterator = prevIdsList.iterator();
                while (iterator.hasNext()) {
                    Long aLong = (Long)iterator.next();
                    prevIds[i] = aLong;
                    ++i;
                }
                SimpleStep step = new SimpleStep(id, entryId, stepId, actionId, owner, startDate, dueDate, finishDate, status, prevIds, caller);
                currentSteps.add(step);
            }
            ArrayList<SimpleStep> arrayList = currentSteps;
            Object var27_27 = null;
            this.cleanup(null, stmt2, null);
            this.cleanup(conn, stmt, rset);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new StoreException("Unable to locate history steps for workflow instance #" + entryId, e);
            }
            catch (Throwable throwable) {
                Object var27_28 = null;
                this.cleanup(null, stmt2, null);
                this.cleanup(conn, stmt, rset);
                throw throwable;
            }
        }
    }

    public void init(Map props) throws StoreException {
        this.entrySequence = this.getInitProperty(props, "entry.sequence", "SELECT nextVal('seq_os_wfentry')");
        this.stepSequence = this.getInitProperty(props, "step.sequence", "SELECT nextVal('seq_os_currentsteps')");
        this.entryTable = this.getInitProperty(props, "entry.table", "OS_WFENTRY");
        this.entryId = this.getInitProperty(props, "entry.id", "ID");
        this.entryName = this.getInitProperty(props, "entry.name", "NAME");
        this.entryState = this.getInitProperty(props, "entry.state", "STATE");
        this.historyTable = this.getInitProperty(props, "history.table", "OS_HISTORYSTEP");
        this.currentTable = this.getInitProperty(props, "current.table", "OS_CURRENTSTEP");
        this.currentPrevTable = this.getInitProperty(props, "currentPrev.table", "OS_CURRENTSTEP_PREV");
        this.historyPrevTable = this.getInitProperty(props, "historyPrev.table", "OS_HISTORYSTEP_PREV");
        this.stepId = this.getInitProperty(props, "step.id", "ID");
        this.stepEntryId = this.getInitProperty(props, "step.entryId", "ENTRY_ID");
        this.stepStepId = this.getInitProperty(props, "step.stepId", "STEP_ID");
        this.stepActionId = this.getInitProperty(props, "step.actionId", "ACTION_ID");
        this.stepOwner = this.getInitProperty(props, "step.owner", "OWNER");
        this.stepCaller = this.getInitProperty(props, "step.caller", "CALLER");
        this.stepStartDate = this.getInitProperty(props, "step.startDate", "START_DATE");
        this.stepFinishDate = this.getInitProperty(props, "step.finishDate", "FINISH_DATE");
        this.stepDueDate = this.getInitProperty(props, "step.dueDate", "DUE_DATE");
        this.stepStatus = this.getInitProperty(props, "step.status", "STATUS");
        this.stepPreviousId = this.getInitProperty(props, "step.previousId", "PREVIOUS_ID");
        String jndi = (String)props.get("datasource");
        if (jndi != null) {
            try {
                this.ds = (DataSource)this.lookup(jndi);
                if (this.ds == null) {
                    this.ds = (DataSource)new InitialContext().lookup(jndi);
                }
            }
            catch (Exception e) {
                throw new StoreException("Error looking up DataSource at " + jndi, e);
            }
        }
    }

    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) throws StoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            String sql = "UPDATE " + this.currentTable + " SET " + this.stepStatus + " = ?, " + this.stepActionId + " = ?, " + this.stepFinishDate + " = ?, " + this.stepCaller + " = ? WHERE " + this.stepId + " = ?";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing SQL statement: " + sql));
            }
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, status);
            stmt.setInt(2, actionId);
            stmt.setTimestamp(3, new Timestamp(finishDate.getTime()));
            stmt.setString(4, caller);
            stmt.setLong(5, step.getId());
            stmt.executeUpdate();
            SimpleStep theStep = (SimpleStep)step;
            theStep.setActionId(actionId);
            theStep.setFinishDate(finishDate);
            theStep.setStatus(status);
            theStep.setCaller(caller);
            SimpleStep simpleStep = theStep;
            this.cleanup(conn, stmt, null);
            return simpleStep;
        }
        catch (SQLException e) {
            try {
                throw new StoreException("Unable to mark step finished for #" + step.getEntryId(), e);
            }
            catch (Throwable throwable) {
                this.cleanup(conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void moveToHistory(Step step) throws StoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            String sql = "INSERT INTO " + this.historyTable + " (" + this.stepId + "," + this.stepEntryId + ", " + this.stepStepId + ", " + this.stepActionId + ", " + this.stepOwner + ", " + this.stepStartDate + ", " + this.stepFinishDate + ", " + this.stepStatus + ", " + this.stepCaller + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing SQL statement: " + sql));
            }
            stmt = conn.prepareStatement(sql);
            stmt.setLong(1, step.getId());
            stmt.setLong(2, step.getEntryId());
            stmt.setInt(3, step.getStepId());
            stmt.setInt(4, step.getActionId());
            stmt.setString(5, step.getOwner());
            stmt.setTimestamp(6, new Timestamp(step.getStartDate().getTime()));
            if (step.getFinishDate() != null) {
                stmt.setTimestamp(7, new Timestamp(step.getFinishDate().getTime()));
            } else {
                stmt.setNull(7, 93);
            }
            stmt.setString(8, step.getStatus());
            stmt.setString(9, step.getCaller());
            stmt.executeUpdate();
            long[] previousIds = step.getPreviousStepIds();
            if (previousIds != null && previousIds.length > 0) {
                sql = "INSERT INTO " + this.historyPrevTable + " (" + this.stepId + ", " + this.stepPreviousId + ") VALUES (?, ?)";
                log.debug((Object)("Executing SQL statement: " + sql));
                this.cleanup(null, stmt, null);
                stmt = conn.prepareStatement(sql);
                for (int i = 0; i < previousIds.length; ++i) {
                    long previousId = previousIds[i];
                    stmt.setLong(1, step.getId());
                    stmt.setLong(2, previousId);
                    stmt.executeUpdate();
                }
            }
            sql = "DELETE FROM " + this.currentPrevTable + " WHERE " + this.stepId + " = ?";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing SQL statement: " + sql));
            }
            this.cleanup(null, stmt, null);
            stmt = conn.prepareStatement(sql);
            stmt.setLong(1, step.getId());
            stmt.executeUpdate();
            sql = "DELETE FROM " + this.currentTable + " WHERE " + this.stepId + " = ?";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing SQL statement: " + sql));
            }
            this.cleanup(null, stmt, null);
            stmt = conn.prepareStatement(sql);
            stmt.setLong(1, step.getId());
            stmt.executeUpdate();
            this.cleanup(conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new StoreException("Unable to move current step to history step for #" + step.getEntryId(), e);
            }
            catch (Throwable throwable) {
                this.cleanup(conn, stmt, null);
                throw throwable;
            }
        }
    }

    public List query(WorkflowExpressionQuery query) throws StoreException {
        Expression expression = query.getExpression();
        StringBuffer sel = new StringBuffer();
        ArrayList values = new ArrayList();
        String columnName = null;
        columnName = expression.isNested() ? this.buildNested((NestedExpression)expression, sel, values) : this.buildSimple((FieldExpression)expression, sel, values);
        if (query.getSortOrder() != 0) {
            sel.append(" ORDER BY ");
            sel.append(this.fieldName(query.getOrderBy()));
            if (query.getSortOrder() == 1) {
                sel.append(" ASC");
            } else {
                sel.append(" DESC");
            }
        }
        List results = this.doExpressionQuery(sel.toString(), columnName, values);
        return results;
    }

    public List query(WorkflowQuery query) throws StoreException {
        ArrayList<Long> results = new ArrayList<Long>();
        int qtype = query.getType();
        if (qtype == 0 && query.getLeft() != null) {
            qtype = query.getLeft().getType();
        }
        String table = qtype == 2 ? this.currentTable : this.historyTable;
        String sel = "SELECT DISTINCT(" + this.stepEntryId + ") FROM " + table + " WHERE ";
        sel = sel + this.queryWhere(query);
        if (log.isDebugEnabled()) {
            log.debug((Object)sel);
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sel);
            while (rs.next()) {
                Long id = new Long(rs.getLong(this.stepEntryId));
                results.add(id);
            }
            this.cleanup(conn, stmt, rs);
        }
        catch (SQLException ex) {
            try {
                throw new StoreException("SQL Exception in query: " + ex.getMessage());
            }
            catch (Throwable throwable) {
                this.cleanup(conn, stmt, rs);
                throw throwable;
            }
        }
        return results;
    }

    protected Connection getConnection() throws SQLException {
        this.closeConnWhenDone = true;
        return this.ds.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextEntrySequence(Connection c) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing SQL statement: " + this.entrySequence));
        }
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            long id;
            stmt = c.prepareStatement(this.entrySequence);
            rset = stmt.executeQuery();
            rset.next();
            long l = id = rset.getLong(1);
            this.cleanup(null, stmt, rset);
            return l;
        }
        catch (Throwable throwable) {
            this.cleanup(null, stmt, rset);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNextStepSequence(Connection c) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing SQL statement: " + this.stepSequence));
        }
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            long id;
            stmt = c.prepareStatement(this.stepSequence);
            rset = stmt.executeQuery();
            rset.next();
            long l = id = rset.getLong(1);
            this.cleanup(null, stmt, rset);
            return l;
        }
        catch (Throwable throwable) {
            this.cleanup(null, stmt, rset);
            throw throwable;
        }
    }

    protected void addPreviousSteps(Connection conn, long id, long[] previousIds) throws SQLException {
        if (previousIds != null && previousIds.length > 0 && (previousIds.length != 1 || previousIds[0] != 0L)) {
            String sql = "INSERT INTO " + this.currentPrevTable + " (" + this.stepId + ", " + this.stepPreviousId + ") VALUES (?, ?)";
            log.debug((Object)("Executing SQL statement: " + sql));
            PreparedStatement stmt = conn.prepareStatement(sql);
            for (int i = 0; i < previousIds.length; ++i) {
                long previousId = previousIds[i];
                stmt.setLong(1, id);
                stmt.setLong(2, previousId);
                stmt.executeUpdate();
            }
            this.cleanup(null, stmt, null);
        }
    }

    protected void cleanup(Connection connection, Statement statement, ResultSet result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (SQLException ex) {
                log.error((Object)"Error closing resultset", (Throwable)ex);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                log.error((Object)"Error closing statement", (Throwable)ex);
            }
        }
        if (connection != null && this.closeConnWhenDone) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                log.error((Object)"Error closing connection", (Throwable)ex);
            }
        }
    }

    protected long createCurrentStep(Connection conn, long entryId, int wfStepId, String owner, Date startDate, Date dueDate, String status) throws SQLException {
        String sql = "INSERT INTO " + this.currentTable + " (" + this.stepId + "," + this.stepEntryId + ", " + this.stepStepId + ", " + this.stepActionId + ", " + this.stepOwner + ", " + this.stepStartDate + ", " + this.stepDueDate + ", " + this.stepFinishDate + ", " + this.stepStatus + ", " + this.stepCaller + " ) VALUES (?, ?, ?, null, ?, ?, ?, null, ?, null)";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing SQL statement: " + sql));
        }
        PreparedStatement stmt = conn.prepareStatement(sql);
        long id = this.getNextStepSequence(conn);
        stmt.setLong(1, id);
        stmt.setLong(2, entryId);
        stmt.setInt(3, wfStepId);
        stmt.setString(4, owner);
        stmt.setTimestamp(5, new Timestamp(startDate.getTime()));
        if (dueDate != null) {
            stmt.setTimestamp(6, new Timestamp(dueDate.getTime()));
        } else {
            stmt.setNull(6, 93);
        }
        stmt.setString(7, status);
        stmt.executeUpdate();
        this.cleanup(null, stmt, null);
        return id;
    }

    private String getInitProperty(Map props, String strName, String strDefault) {
        Object o = props.get(strName);
        if (o == null) {
            return strDefault;
        }
        return (String)o;
    }

    private String buildNested(NestedExpression nestedExpression, StringBuffer sel, List values) {
        sel.append("SELECT DISTINCT(");
        sel.append(this.entryId);
        sel.append(") FROM ");
        sel.append(this.entryTable);
        for (int i = 0; i < nestedExpression.getExpressionCount(); ++i) {
            Expression expression = nestedExpression.getExpression(i);
            if (i == 0) {
                sel.append(" WHERE ");
            } else if (nestedExpression.getExpressionOperator() == 6) {
                sel.append(" AND ");
            } else {
                sel.append(" OR ");
            }
            if (expression.isNegate()) {
                sel.append(" NOT ");
            }
            sel.append(this.entryId);
            sel.append(" IN (");
            if (expression.isNested()) {
                this.buildNested((NestedExpression)nestedExpression.getExpression(i), sel, values);
            } else {
                FieldExpression sub = (FieldExpression)nestedExpression.getExpression(i);
                this.buildSimple(sub, sel, values);
            }
            sel.append(")");
        }
        return this.entryId;
    }

    private String buildSimple(FieldExpression fieldExpression, StringBuffer sel, List values) {
        String columnName;
        String table;
        if (fieldExpression.getContext() == 2) {
            table = this.currentTable;
            columnName = this.stepEntryId;
        } else if (fieldExpression.getContext() == 1) {
            table = this.historyTable;
            columnName = this.stepEntryId;
        } else {
            table = this.entryTable;
            columnName = this.entryId;
        }
        sel.append("SELECT DISTINCT(");
        sel.append(columnName);
        sel.append(") FROM ");
        sel.append(table);
        sel.append(" WHERE ");
        this.queryComparison(fieldExpression, sel, values);
        return columnName;
    }

    private List doExpressionQuery(String sel, String columnName, List values) throws StoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sel);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Long> results = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sel);
            if (!values.isEmpty()) {
                for (int i = 1; i <= values.size(); ++i) {
                    stmt.setObject(i, values.get(i - 1));
                }
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long id = new Long(rs.getLong(columnName));
                results.add(id);
            }
            ArrayList<Long> id = results;
            this.cleanup(conn, stmt, rs);
            return id;
        }
        catch (SQLException ex) {
            try {
                throw new StoreException("SQL Exception in query: " + ex.getMessage());
            }
            catch (Throwable throwable) {
                this.cleanup(conn, stmt, rs);
                throw throwable;
            }
        }
    }

    private static String escape(String s) {
        StringBuffer sb = new StringBuffer(s);
        char[] chars = s.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\'': {
                    sb.insert(i, '\'');
                    ++i;
                    continue block4;
                }
                case '\\': {
                    sb.insert(i, '\\');
                    ++i;
                }
            }
        }
        return sb.toString();
    }

    private String fieldName(int field) {
        switch (field) {
            case 4: {
                return this.stepActionId;
            }
            case 6: {
                return this.stepCaller;
            }
            case 3: {
                return this.stepFinishDate;
            }
            case 1: {
                return this.stepOwner;
            }
            case 2: {
                return this.stepStartDate;
            }
            case 5: {
                return this.stepStepId;
            }
            case 7: {
                return this.stepStatus;
            }
            case 9: {
                return this.entryState;
            }
            case 8: {
                return this.entryName;
            }
        }
        return "1";
    }

    private Object lookup(String location) throws NamingException {
        InitialContext context = new InitialContext();
        try {
            return context.lookup(location);
        }
        catch (NamingException e) {
            return context.lookup("java:comp/env/" + location);
        }
    }

    private String queryComparison(WorkflowQuery query) {
        String left;
        String oper;
        Object value = query.getValue();
        int operator = query.getOperator();
        int field = query.getField();
        switch (operator) {
            case 1: {
                oper = " = ";
                break;
            }
            case 5: {
                oper = " <> ";
                break;
            }
            case 3: {
                oper = " > ";
                break;
            }
            case 2: {
                oper = " < ";
                break;
            }
            default: {
                oper = " = ";
            }
        }
        switch (field) {
            case 4: {
                left = this.stepActionId;
                break;
            }
            case 6: {
                left = this.stepCaller;
                break;
            }
            case 3: {
                left = this.stepFinishDate;
                break;
            }
            case 1: {
                left = this.stepOwner;
                break;
            }
            case 2: {
                left = this.stepStartDate;
                break;
            }
            case 5: {
                left = this.stepStepId;
                break;
            }
            case 7: {
                left = this.stepStatus;
                break;
            }
            default: {
                left = "1";
            }
        }
        String right = value != null ? "'" + JDBCWorkflowStore.escape(value.toString()) + "'" : "null";
        return left + oper + right;
    }

    private void queryComparison(FieldExpression expression, StringBuffer sel, List values) {
        String oper;
        Object value = expression.getValue();
        int operator = expression.getOperator();
        int field = expression.getField();
        switch (operator) {
            case 1: {
                if (value == null) {
                    oper = " IS ";
                    break;
                }
                oper = " = ";
                break;
            }
            case 5: {
                if (value == null) {
                    oper = " IS NOT ";
                    break;
                }
                oper = " <> ";
                break;
            }
            case 3: {
                oper = " > ";
                break;
            }
            case 2: {
                oper = " < ";
                break;
            }
            default: {
                oper = " = ";
            }
        }
        String left = this.fieldName(field);
        String right = "?";
        switch (field) {
            case 3: {
                values.add(new Timestamp(((Date)value).getTime()));
                break;
            }
            case 2: {
                values.add(new Timestamp(((Date)value).getTime()));
                break;
            }
            default: {
                if (value == null) {
                    right = "null";
                    break;
                }
                values.add(value);
            }
        }
        sel.append(left);
        sel.append(oper);
        sel.append(right);
    }

    private String queryWhere(WorkflowQuery query) {
        if (query.getLeft() == null) {
            return this.queryComparison(query);
        }
        int operator = query.getOperator();
        WorkflowQuery left = query.getLeft();
        WorkflowQuery right = query.getRight();
        switch (operator) {
            case 6: {
                return "(" + this.queryWhere(left) + " AND " + this.queryWhere(right) + ")";
            }
            case 7: {
                return "(" + this.queryWhere(left) + " OR " + this.queryWhere(right) + ")";
            }
            case 8: {
                return "(" + this.queryWhere(left) + " XOR " + this.queryWhere(right) + ")";
            }
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

