/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.osworkflow;

import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.InvalidRoleException;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.basic.BasicWorkflow;
import com.opensymphony.workflow.config.Configuration;
import com.opensymphony.workflow.config.DefaultConfiguration;
import java.util.Map;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.RobustInOnly;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.osworkflow.OSWorkflowEndpoint;

public class OSWorkflow
extends Thread {
    public static final String KEY_EXCHANGE = "exchange";
    public static final String KEY_IN_MESSAGE = "in-message";
    public static final String KEY_ENDPOINT = "endpoint";
    public static final String KEY_CALLER = "caller";
    public static final String KEY_ASYNC_PROCESSING = "asynchronous";
    private static Log log = LogFactory.getLog(OSWorkflow.class);
    private Workflow osWorkflowInstance;
    private String caller;
    private String osWorkflowName;
    private Map map;
    private int action = -1;
    private long workflowId = -1L;
    private boolean finished;
    private boolean aborted;
    private OSWorkflowEndpoint endpoint;
    private MessageExchange exchange;

    public OSWorkflow(OSWorkflowEndpoint ep, String workflowName, int action, Map map, String caller, MessageExchange exchange) {
        super(workflowName);
        this.setDaemon(true);
        this.endpoint = ep;
        this.osWorkflowName = workflowName;
        this.osWorkflowInstance = null;
        this.action = action;
        this.map = map;
        this.caller = caller;
        this.exchange = exchange;
        this.map.put(KEY_ENDPOINT, this.endpoint);
        this.map.put(KEY_CALLER, this.caller);
        this.map.put(KEY_IN_MESSAGE, this.exchange.getMessage("in"));
        this.map.put(KEY_EXCHANGE, this.exchange);
        this.map.put(KEY_ASYNC_PROCESSING, this.exchange instanceof InOnly || this.exchange instanceof RobustInOnly);
    }

    private long createWorkflow() throws InvalidRoleException, InvalidInputException, WorkflowException {
        this.osWorkflowInstance = new BasicWorkflow(this.caller);
        DefaultConfiguration config = new DefaultConfiguration();
        this.osWorkflowInstance.setConfiguration((Configuration)config);
        long wfId = this.osWorkflowInstance.initialize(this.osWorkflowName, this.action, this.map);
        return wfId;
    }

    public void run() {
        this.endpoint.preWorkflow();
        log.debug((Object)"Starting workflow...");
        log.debug((Object)("Name:       " + this.osWorkflowName));
        log.debug((Object)("Action:     " + this.action));
        log.debug((Object)("Caller:     " + this.caller));
        log.debug((Object)("Map:        " + this.map));
        while (!this.finished && !this.aborted) {
            int[] availableActions;
            if (this.osWorkflowInstance == null) {
                try {
                    this.workflowId = this.createWorkflow();
                }
                catch (Exception ex) {
                    log.error((Object)"Error creating the workflow", (Throwable)ex);
                    this.aborted = true;
                    break;
                }
            }
            if ((availableActions = this.osWorkflowInstance.getAvailableActions(this.workflowId, this.map)).length == 0) {
                log.debug((Object)"No more actions. Workflow is finished...");
                this.finished = true;
                continue;
            }
            int nextAction = availableActions[0];
            log.debug((Object)("call action " + nextAction));
            try {
                this.osWorkflowInstance.doAction(this.workflowId, nextAction, this.map);
            }
            catch (InvalidInputException iiex) {
                log.error((Object)iiex);
                this.aborted = true;
            }
            catch (WorkflowException wfex) {
                log.error((Object)wfex);
                this.aborted = true;
            }
        }
        log.debug((Object)"Stopping workflow...");
        log.debug((Object)("Name:       " + this.osWorkflowName));
        log.debug((Object)("Action:     " + this.action));
        log.debug((Object)("Caller:     " + this.caller));
        log.debug((Object)("Map:        " + this.map));
        log.debug((Object)("WorkflowId: " + this.workflowId));
        log.debug((Object)("End state:  " + (this.finished ? "Finished" : "Aborted")));
        this.endpoint.postWorkflow();
    }
}

