/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.osworkflow;

import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.InstallationContext;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class OSWorkflowBootstrap
implements Bootstrap {
    protected InstallationContext context;
    protected ObjectName mbeanName;

    public ObjectName getExtensionMBeanName() {
        return this.mbeanName;
    }

    protected Object getExtensionMBean() throws Exception {
        return null;
    }

    protected ObjectName createExtensionMBeanName() throws Exception {
        return this.context.getContext().getMBeanNames().createCustomComponentMBeanName("bootstrap");
    }

    public void init(InstallationContext installContext) throws JBIException {
        try {
            this.context = installContext;
            this.doInit();
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling init", (Throwable)e);
        }
    }

    protected void doInit() throws Exception {
        Object mbean = this.getExtensionMBean();
        if (mbean != null) {
            this.mbeanName = this.createExtensionMBeanName();
            MBeanServer server = this.context.getContext().getMBeanServer();
            if (server == null) {
                throw new JBIException("null mBeanServer");
            }
            if (server.isRegistered(this.mbeanName)) {
                server.unregisterMBean(this.mbeanName);
            }
            server.registerMBean(mbean, this.mbeanName);
        }
    }

    public void cleanUp() throws JBIException {
        try {
            this.doCleanUp();
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling cleanUp", (Throwable)e);
        }
    }

    protected void doCleanUp() throws Exception {
        if (this.mbeanName != null) {
            MBeanServer server = this.context.getContext().getMBeanServer();
            if (server == null) {
                throw new JBIException("null mBeanServer");
            }
            if (server.isRegistered(this.mbeanName)) {
                server.unregisterMBean(this.mbeanName);
            }
        }
    }

    public void onInstall() throws JBIException {
        try {
            this.doOnInstall();
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling onInstall", (Throwable)e);
        }
    }

    protected void doOnInstall() throws Exception {
    }

    public void onUninstall() throws JBIException {
        try {
            this.doOnUninstall();
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling onUninstall", (Throwable)e);
        }
    }

    protected void doOnUninstall() throws Exception {
    }
}

