/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.osworkflow;

import java.util.HashMap;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.osworkflow.OSWorkflow;
import org.apache.servicemix.osworkflow.WorkflowManager;

public class OSWorkflowEndpoint
extends Endpoint
implements ExchangeProcessor {
    private static final long TIME_OUT = 30000L;
    private ServiceEndpoint activated;
    private DeliveryChannel channel;
    private MessageExchangeFactory exchangeFactory;
    private String workflowName;
    private String caller;
    private int action;

    public MessageExchange.Role getRole() {
        return MessageExchange.Role.PROVIDER;
    }

    public void activate() throws Exception {
        this.logger = this.serviceUnit.getComponent().getLogger();
        ComponentContext ctx = this.getServiceUnit().getComponent().getComponentContext();
        this.channel = ctx.getDeliveryChannel();
        this.exchangeFactory = this.channel.createExchangeFactory();
        this.activated = ctx.activateEndpoint(this.service, this.endpoint);
        this.start();
    }

    public void deactivate() throws Exception {
        this.stop();
        ServiceEndpoint ep = this.activated;
        this.activated = null;
        ComponentContext ctx = this.getServiceUnit().getComponent().getComponentContext();
        ctx.deactivateEndpoint(ep);
    }

    public ExchangeProcessor getProcessor() {
        return this;
    }

    public void validate() throws DeploymentException {
    }

    public void start() throws Exception {
        WorkflowManager.getInstance();
    }

    public void stop() {
        WorkflowManager.getInstance().prepareShutdown(true);
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange == null) {
            return;
        }
        if (exchange.getRole() == MessageExchange.Role.CONSUMER) {
            this.onConsumerExchange(exchange);
        } else if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            this.onProviderExchange(exchange);
        } else {
            throw new MessagingException("OSWorkflowEndpoint.onMessageExchange(): Unknown role: " + exchange.getRole());
        }
    }

    protected void onConsumerExchange(MessageExchange exchange) throws MessagingException {
        if (exchange.getMessage("out") != null) {
            exchange.setStatus(ExchangeStatus.DONE);
            this.channel.send(exchange);
        } else if (exchange.getFault() != null) {
            exchange.setStatus(ExchangeStatus.DONE);
            this.channel.send(exchange);
        } else {
            throw new MessagingException("OSWorkflowEndpoint.onConsumerExchange(): Consumer exchange is ACTIVE, but no out or fault is provided");
        }
    }

    protected void onProviderExchange(MessageExchange exchange) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        if (exchange.getFault() != null) {
            exchange.setStatus(ExchangeStatus.DONE);
            this.channel.send(exchange);
        } else {
            NormalizedMessage in = exchange.getMessage("in");
            if (in == null) {
                throw new MessagingException("OSWorkflowEndpoint.onProviderExchange(): Exchange has no IN message");
            }
            OSWorkflow osWorkflow = new OSWorkflow(this, this.workflowName, this.action, new HashMap(), this.caller, exchange);
            if (exchange instanceof InOnly || exchange instanceof RobustInOnly) {
                try {
                    WorkflowManager.getInstance().executeWorkflow(osWorkflow);
                }
                catch (Exception ex) {
                    this.logger.error((Object)ex);
                }
            } else {
                try {
                    osWorkflow.start();
                    osWorkflow.join();
                }
                catch (Exception ex) {
                    this.logger.error((Object)ex);
                }
            }
        }
    }

    public DeliveryChannel getChannel() {
        return this.channel;
    }

    public MessageExchangeFactory getMessageExchangeFactory() {
        return this.exchangeFactory;
    }

    public boolean sendMessage(QName service, Source source) throws MessagingException {
        InOnly inOnly = this.channel.createExchangeFactoryForService(service).createInOnlyExchange();
        NormalizedMessage msg = inOnly.createMessage();
        msg.setContent(source);
        inOnly.setInMessage(msg);
        if (this.channel.sendSync((MessageExchange)inOnly)) {
            return inOnly.getStatus() == ExchangeStatus.DONE;
        }
        return false;
    }

    public Source sendRequest(QName service, Source source) throws MessagingException {
        InOut inOut = this.channel.createExchangeFactoryForService(service).createInOutExchange();
        NormalizedMessage msg = inOut.createMessage();
        msg.setContent(source);
        inOut.setInMessage(msg);
        if (this.channel.sendSync((MessageExchange)inOut)) {
            SourceTransformer sourceTransformer = new SourceTransformer();
            try {
                DOMSource result = sourceTransformer.toDOMSource(inOut.getOutMessage().getContent());
                inOut.setStatus(ExchangeStatus.DONE);
                this.channel.send((MessageExchange)inOut);
                return result;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public MessageExchange sendRawInOutRequest(QName service, Source source) throws MessagingException {
        InOut inOut = this.channel.createExchangeFactoryForService(service).createInOutExchange();
        NormalizedMessage msg = inOut.createMessage();
        msg.setContent(source);
        inOut.setInMessage(msg);
        if (this.channel.sendSync((MessageExchange)inOut)) {
            return inOut;
        }
        return null;
    }

    public MessageExchange getNewExchange(QName qname, boolean inOut) throws MessagingException {
        Object exchange = null;
        exchange = inOut ? this.channel.createExchangeFactoryForService(qname).createInOutExchange() : this.channel.createExchangeFactoryForService(qname).createInOnlyExchange();
        return exchange;
    }

    public void done(MessageExchange ex) throws MessagingException {
        ex.setStatus(ExchangeStatus.DONE);
        this.channel.send(ex);
    }

    public void send(MessageExchange ex, boolean sync) throws MessagingException {
        if (sync) {
            this.channel.sendSync(ex, 30000L);
        } else {
            this.channel.send(ex);
        }
    }

    public void fail(MessageExchange ex) throws MessagingException {
        ex.setStatus(ExchangeStatus.ERROR);
        this.channel.send(ex);
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public String getCaller() {
        return this.caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public void preWorkflow() {
    }

    public void postWorkflow() {
    }
}

