/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.osworkflow;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class WorkflowManager {
    private static final int WORKER_COUNT = 30;
    private static WorkflowManager manager;
    private ExecutorService executor = Executors.newFixedThreadPool(30);

    private WorkflowManager() {
    }

    public static synchronized WorkflowManager getInstance() {
        if (manager == null) {
            manager = new WorkflowManager();
        }
        return manager;
    }

    public void executeWorkflow(Runnable r) {
        this.executor.execute(r);
    }

    public void prepareShutdown(boolean firstFinishRunningTasks) {
        if (firstFinishRunningTasks) {
            this.executor.shutdown();
        } else {
            this.executor.shutdownNow();
        }
    }
}

