/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.quartz;

import java.util.List;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.quartz.QuartzEndpoint;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzComponent
extends DefaultComponent {
    private QuartzEndpoint[] endpoints;
    private Scheduler scheduler;
    private SchedulerFactory factory;

    public SchedulerFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SchedulerFactory factory) {
        this.factory = factory;
    }

    public QuartzEndpoint[] getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(QuartzEndpoint[] endpoints) {
        this.endpoints = endpoints;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected List getConfiguredEndpoints() {
        return QuartzComponent.asList((Object[])this.endpoints);
    }

    protected Class[] getEndpointClasses() {
        return new Class[]{QuartzEndpoint.class};
    }

    public void doInit() throws Exception {
        if (this.scheduler == null) {
            if (this.factory == null) {
                this.factory = new StdSchedulerFactory();
            }
            this.scheduler = this.factory.getScheduler();
        }
        this.scheduler.getContext().setAllowsTransientData(true);
        this.scheduler.getContext().put((Object)this.getComponentName(), (Object)this);
        super.doInit();
    }

    public void doStart() throws Exception {
        this.scheduler.start();
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
        this.scheduler.standby();
    }

    public void doShutDown() throws Exception {
        super.doShutDown();
        this.scheduler.shutdown();
        this.scheduler = null;
    }
}

