/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.quartz.support;

import org.apache.servicemix.quartz.QuartzComponent;
import org.apache.servicemix.quartz.QuartzEndpoint;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;

public class ServiceMixJob
implements Job {
    public static final String COMPONENT_NAME = "org.apache.servicemix.quartz.ComponentName";
    public static final String ENDPOINT_NAME = "org.apache.servicemix.quartz.EndpointName";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            String componentName = (String)context.getJobDetail().getJobDataMap().get((Object)COMPONENT_NAME);
            if (componentName == null) {
                throw new JobExecutionException("No property 'org.apache.servicemix.quartz.ComponentName' defined. Bad job data map");
            }
            QuartzComponent component = (QuartzComponent)((Object)context.getScheduler().getContext().get((Object)componentName));
            if (component == null) {
                throw new JobExecutionException("No quartz JBI component available for key: " + componentName + "." + " Bad job data map");
            }
            String endpointName = (String)context.getJobDetail().getJobDataMap().get((Object)ENDPOINT_NAME);
            if (endpointName == null) {
                throw new JobExecutionException("No property 'org.apache.servicemix.quartz.EndpointName' defined. Bad job data map");
            }
            QuartzEndpoint endpoint = (QuartzEndpoint)component.getRegistry().getEndpoint(endpointName);
            if (endpoint == null) {
                throw new JobExecutionException("No quartz JBI endpoint available for key: " + endpointName + "." + " Bad job data map");
            }
            endpoint.onJobExecute(context);
        }
        catch (SchedulerException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }
}

