/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.quartz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.endpoints.ConsumerEndpoint;
import org.apache.servicemix.quartz.QuartzComponent;
import org.apache.servicemix.quartz.support.DefaultQuartzMarshaler;
import org.apache.servicemix.quartz.support.JobDetailBean;
import org.apache.servicemix.quartz.support.QuartzMarshaler;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzEndpoint
extends ConsumerEndpoint {
    private Trigger trigger;
    private List<Trigger> triggers;
    private Map<String, Calendar> calendars;
    private JobDetail jobDetail;
    private QuartzMarshaler marshaler = new DefaultQuartzMarshaler();

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public Map<String, Calendar> getCalendars() {
        return this.calendars;
    }

    public void setCalendars(Map<String, Calendar> calendars) {
        this.calendars = calendars;
    }

    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    public void setJobDetail(JobDetail job) {
        this.jobDetail = job;
    }

    public QuartzMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(QuartzMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getLocationURI() {
        return null;
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            throw new IllegalStateException("Unexpected ACTIVE exchange: " + exchange);
        }
    }

    public void onJobExecute(JobExecutionContext context) throws JobExecutionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Firing Quartz Job with context: " + context));
        }
        try {
            InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
            NormalizedMessage message = exchange.createMessage();
            this.getMarshaler().populateNormalizedMessage(message, context);
            exchange.setInMessage(message);
            this.configureExchangeTarget((MessageExchange)exchange);
            this.send((MessageExchange)exchange);
        }
        catch (MessagingException e) {
            throw new JobExecutionException((Exception)((Object)e));
        }
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.trigger instanceof JobDetailAwareTrigger) {
            if (this.jobDetail != null) {
                throw new DeploymentException("jobDetail can not be set on endpoint and trigger at the same time");
            }
            this.jobDetail = ((JobDetailAwareTrigger)this.trigger).getJobDetail();
        }
        if (this.jobDetail == null) {
            JobDetailBean j = new JobDetailBean();
            j.setName(EndpointSupport.getKey((Endpoint)this));
            this.jobDetail = j;
        }
        if (this.triggers == null) {
            this.triggers = new ArrayList<Trigger>();
        }
        if (this.trigger != null && this.triggers != null && this.triggers.size() > 0) {
            throw new DeploymentException("trigger and triggers can not be set at the same time");
        }
        if (this.trigger != null) {
            this.triggers.add(this.trigger);
        }
        if (this.calendars == null) {
            this.calendars = new HashMap<String, Calendar>();
        }
        for (Trigger t : this.triggers) {
            if (t.getCalendarName() != null && this.calendars.get(t.getCalendarName()) == null) {
                throw new DeploymentException("Trigger references an unknown calendar " + t.getCalendarName());
            }
            t.setJobName(this.jobDetail.getName());
            t.setJobGroup(this.jobDetail.getGroup());
            t.setName(this.jobDetail.getName() + " - " + t.getName());
        }
    }

    public void start() throws Exception {
        QuartzComponent component = (QuartzComponent)this.getServiceUnit().getComponent();
        Scheduler scheduler = component.getScheduler();
        this.jobDetail.getJobDataMap().put("org.apache.servicemix.quartz.ComponentName", component.getComponentName());
        this.jobDetail.getJobDataMap().put("org.apache.servicemix.quartz.EndpointName", EndpointSupport.getKey((Endpoint)this));
        for (Map.Entry<String, Calendar> e : this.getCalendars().entrySet()) {
            scheduler.addCalendar(e.getKey(), e.getValue(), true, true);
        }
        scheduler.addJob(this.getJobDetail(), true);
        for (Trigger trg : this.getTriggers()) {
            boolean triggerExists;
            boolean bl = triggerExists = scheduler.getTrigger(trg.getName(), trg.getGroup()) != null;
            if (!triggerExists) {
                try {
                    scheduler.scheduleJob(trg);
                }
                catch (ObjectAlreadyExistsException ex) {
                    scheduler.rescheduleJob(trg.getName(), trg.getGroup(), trg);
                }
                continue;
            }
            scheduler.rescheduleJob(trg.getName(), trg.getGroup(), trg);
        }
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
        Scheduler scheduler = ((QuartzComponent)this.getServiceUnit().getComponent()).getScheduler();
        for (Trigger trigger : this.getTriggers()) {
            scheduler.unscheduleJob(trigger.getName(), trigger.getGroup());
        }
        scheduler.deleteJob(this.getJobDetail().getName(), this.getJobDetail().getGroup());
        for (Map.Entry entry : this.getCalendars().entrySet()) {
            scheduler.deleteCalendar((String)entry.getKey());
        }
    }
}

