/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.quartz.support;

import java.util.Map;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.servicemix.components.util.MarshalerSupport;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.apache.servicemix.quartz.support.QuartzMarshaler;
import org.apache.servicemix.quartz.support.ServiceMixJob;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultQuartzMarshaler
extends MarshalerSupport
implements QuartzMarshaler {
    public void populateNormalizedMessage(NormalizedMessage message, JobExecutionContext context) throws JobExecutionException, MessagingException {
        JobDetail detail = context.getJobDetail();
        JobDataMap dataMap = detail.getJobDataMap();
        for (Map.Entry entry : dataMap.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals(ServiceMixJob.COMPONENT_NAME) || key.equals(ServiceMixJob.ENDPOINT_NAME)) continue;
            Object value = entry.getValue();
            message.setProperty(key, value);
        }
        try {
            Document document = this.getTransformer().createDocument();
            Element root = document.createElement("timer");
            document.appendChild(root);
            DOMUtil.addChildElement((Element)root, (String)"name", (Object)detail.getName());
            DOMUtil.addChildElement((Element)root, (String)"group", (Object)detail.getGroup());
            DOMUtil.addChildElement((Element)root, (String)"fullname", (Object)detail.getFullName());
            DOMUtil.addChildElement((Element)root, (String)"description", (Object)detail.getDescription());
            DOMUtil.addChildElement((Element)root, (String)"fireTime", (Object)context.getFireTime());
            message.setContent((Source)new DOMSource(document));
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException("Failed to create content: " + e, (Throwable)e);
        }
    }
}

