/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.util;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import jnr.ffi.mapper.AbstractDataConverter;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.ToNativeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumMapper
extends AbstractDataConverter<Enum, Integer> {
    private final Class<? extends Enum> enumClass;
    private final int[] intValues;
    private final long[] longValues;
    private final Map<Number, Enum> reverseLookupMap = new HashMap<Number, Enum>();

    private EnumMapper(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
        EnumSet<? extends Enum> enums = EnumSet.allOf(enumClass);
        this.intValues = new int[enums.size()];
        this.longValues = new long[enums.size()];
        Method intValueMethod = EnumMapper.getNumberValueMethod(enumClass, Integer.TYPE);
        Method longValueMethod = EnumMapper.getNumberValueMethod(enumClass, Long.TYPE);
        for (Enum enum_ : enums) {
            Number value2;
            if (longValueMethod != null) {
                Number value22 = EnumMapper.reflectedNumberValue(enum_, longValueMethod);
            } else {
                value2 = intValueMethod != null ? (Number)EnumMapper.reflectedNumberValue(enum_, intValueMethod) : (Number)enum_.ordinal();
            }
            this.intValues[enum_.ordinal()] = value2.intValue();
            this.longValues[enum_.ordinal()] = value2.longValue();
            this.reverseLookupMap.put(value2, enum_);
        }
    }

    @Override
    public Enum fromNative(Integer nativeValue, FromNativeContext context) {
        return this.valueOf(nativeValue);
    }

    @Override
    public Class<Integer> nativeType() {
        return Integer.class;
    }

    @Override
    public Integer toNative(Enum value2, ToNativeContext context) {
        return this.intValue(this.enumClass.cast(value2));
    }

    public static EnumMapper getInstance(Class<? extends Enum> enumClass) {
        EnumMapper mapper = (EnumMapper)StaticDataHolder.MAPPERS.get(enumClass);
        if (mapper != null) {
            return mapper;
        }
        return EnumMapper.addMapper(enumClass);
    }

    private static synchronized EnumMapper addMapper(Class<? extends Enum> enumClass) {
        EnumMapper mapper = new EnumMapper(enumClass);
        IdentityHashMap<Class<? extends Enum>, EnumMapper> tmp = new IdentityHashMap<Class<? extends Enum>, EnumMapper>(StaticDataHolder.MAPPERS);
        tmp.put(enumClass, mapper);
        StaticDataHolder.MAPPERS = tmp;
        return mapper;
    }

    private static Method getNumberValueMethod(Class c, Class numberClass) {
        try {
            Method m = c.getDeclaredMethod(numberClass.getSimpleName() + "Value", new Class[0]);
            return m != null && numberClass == m.getReturnType() ? m : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Number reflectedNumberValue(Enum e, Method m) {
        try {
            return (Number)m.invoke((Object)e, new Object[0]);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public final int intValue(Enum value2) {
        if (value2.getClass() != this.enumClass) {
            throw new IllegalArgumentException("enum class mismatch, " + value2.getClass());
        }
        return this.intValues[value2.ordinal()];
    }

    public final long longValue(Enum value2) {
        if (value2.getClass() != this.enumClass) {
            throw new IllegalArgumentException("enum class mismatch, " + value2.getClass());
        }
        return this.longValues[value2.ordinal()];
    }

    public Enum valueOf(int value2) {
        return this.reverseLookup(value2);
    }

    public Enum valueOf(long value2) {
        return this.reverseLookup(value2);
    }

    public Enum valueOf(Number value2) {
        return this.reverseLookup(value2);
    }

    private Enum reverseLookup(Number value2) {
        Enum e = this.reverseLookupMap.get(value2);
        return e != null ? e : this.badValue(value2);
    }

    private Enum badValue(Number value2) {
        try {
            return Enum.valueOf(this.enumClass, "__UNKNOWN_NATIVE_VALUE");
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("No known Enum mapping for value " + value2 + " of type " + this.enumClass.getName());
        }
    }

    public static interface IntegerEnum {
        public int intValue();
    }

    private static final class StaticDataHolder {
        private static volatile Map<Class<? extends Enum>, EnumMapper> MAPPERS = Collections.emptyMap();

        private StaticDataHolder() {
        }
    }
}

