/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class StoreLocalVarInstr
extends Instr {
    private IRScope scope;
    private Operand value;
    private LocalVariable lvar;

    public StoreLocalVarInstr(Operand value2, IRScope scope, LocalVariable lvar) {
        super(Operation.BINDING_STORE);
        this.lvar = lvar;
        this.value = value2;
        this.scope = scope;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.value};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.value = this.value.getSimplifiedOperand(valueMap, force);
    }

    public LocalVariable getLocalVar() {
        return this.lvar;
    }

    @Override
    public String toString() {
        return "store_lvar(" + this.value + ", " + this.scope.getName() + ", " + this.lvar + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new StoreLocalVarInstr(this.value.cloneForInlining(ii), this.scope, (LocalVariable)this.lvar.cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        Object varValue = this.value.retrieve(context, self, currDynScope, temp);
        currDynScope.setValue((IRubyObject)varValue, this.lvar.getLocation(), this.lvar.getScopeDepth());
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.StoreLocalVarInstr(this);
    }

    public Operand getValue() {
        return this.value;
    }
}

