/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.signature.SignatureReader;
import org.jruby.org.objectweb.asm.signature.SignatureVisitor;
import org.jruby.org.objectweb.asm.util.Printer;
import org.jruby.org.objectweb.asm.util.Textifiable;
import org.jruby.org.objectweb.asm.util.TraceClassVisitor;
import org.jruby.org.objectweb.asm.util.TraceSignatureVisitor;

public class Textifier
extends Printer {
    public static final int INTERNAL_NAME = 0;
    public static final int FIELD_DESCRIPTOR = 1;
    public static final int FIELD_SIGNATURE = 2;
    public static final int METHOD_DESCRIPTOR = 3;
    public static final int METHOD_SIGNATURE = 4;
    public static final int CLASS_SIGNATURE = 5;
    public static final int TYPE_DECLARATION = 6;
    public static final int CLASS_DECLARATION = 7;
    public static final int PARAMETERS_DECLARATION = 8;
    public static final int HANDLE_DESCRIPTOR = 9;
    protected String tab = "  ";
    protected String tab2 = "    ";
    protected String tab3 = "      ";
    protected String ltab = "   ";
    protected Map labelNames;
    private int valueNumber = 0;

    public Textifier() {
        this(262144);
    }

    protected Textifier(int n) {
        super(n);
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        int n2 = 2;
        boolean bl = true;
        if (stringArray.length < 1 || stringArray.length > 2) {
            bl = false;
        }
        if (bl && "-debug".equals(stringArray[0])) {
            n = 1;
            n2 = 0;
            if (stringArray.length != 2) {
                bl = false;
            }
        }
        if (!bl) {
            System.err.println("Prints a disassembled view of the given class.");
            System.err.println("Usage: Textifier [-debug] <fully qualified class name or class file name>");
            return;
        }
        ClassReader classReader = stringArray[n].endsWith(".class") || stringArray[n].indexOf(92) > -1 || stringArray[n].indexOf(47) > -1 ? new ClassReader(new FileInputStream(stringArray[n])) : new ClassReader(stringArray[n]);
        classReader.accept(new TraceClassVisitor(new PrintWriter(System.out)), n2);
    }

    public void visit(int n, int n2, String string2, String string3, String string4, String[] stringArray) {
        int n3 = n & 0xFFFF;
        int n4 = n >>> 16;
        this.buf.setLength(0);
        this.buf.append("// class version ").append(n3).append('.').append(n4).append(" (").append(n).append(")\n");
        if ((n2 & 0x20000) != 0) {
            this.buf.append("// DEPRECATED\n");
        }
        this.buf.append("// access flags 0x").append(Integer.toHexString(n2).toUpperCase()).append('\n');
        this.appendDescriptor(5, string3);
        if (string3 != null) {
            TraceSignatureVisitor traceSignatureVisitor = new TraceSignatureVisitor(n2);
            SignatureReader signatureReader = new SignatureReader(string3);
            signatureReader.accept(traceSignatureVisitor);
            this.buf.append("// declaration: ").append(string2).append(traceSignatureVisitor.getDeclaration()).append('\n');
        }
        this.appendAccess(n2 & 0xFFFFFFDF);
        if ((n2 & 0x2000) != 0) {
            this.buf.append("@interface ");
        } else if ((n2 & 0x200) != 0) {
            this.buf.append("interface ");
        } else if ((n2 & 0x4000) == 0) {
            this.buf.append("class ");
        }
        this.appendDescriptor(0, string2);
        if (string4 != null && !"java/lang/Object".equals(string4)) {
            this.buf.append(" extends ");
            this.appendDescriptor(0, string4);
            this.buf.append(' ');
        }
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append(" implements ");
            for (int j = 0; j < stringArray.length; ++j) {
                this.appendDescriptor(0, stringArray[j]);
                this.buf.append(' ');
            }
        }
        this.buf.append(" {\n\n");
        this.text.add(this.buf.toString());
    }

    public void visitSource(String string2, String string3) {
        this.buf.setLength(0);
        if (string2 != null) {
            this.buf.append(this.tab).append("// compiled from: ").append(string2).append('\n');
        }
        if (string3 != null) {
            this.buf.append(this.tab).append("// debug info: ").append(string3).append('\n');
        }
        if (this.buf.length() > 0) {
            this.text.add(this.buf.toString());
        }
    }

    public void visitOuterClass(String string2, String string3, String string4) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("OUTERCLASS ");
        this.appendDescriptor(0, string2);
        this.buf.append(' ');
        if (string3 != null) {
            this.buf.append(string3).append(' ');
        }
        this.appendDescriptor(3, string4);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public Textifier visitClassAnnotation(String string2, boolean bl) {
        this.text.add("\n");
        return this.visitAnnotation(string2, bl);
    }

    public void visitClassAttribute(Attribute attribute) {
        this.text.add("\n");
        this.visitAttribute(attribute);
    }

    public void visitInnerClass(String string2, String string3, String string4, int n) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("// access flags 0x");
        this.buf.append(Integer.toHexString(n & 0xFFFFFFDF).toUpperCase()).append('\n');
        this.buf.append(this.tab);
        this.appendAccess(n);
        this.buf.append("INNERCLASS ");
        this.appendDescriptor(0, string2);
        this.buf.append(' ');
        this.appendDescriptor(0, string3);
        this.buf.append(' ');
        this.appendDescriptor(0, string4);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public Textifier visitField(int n, String string2, String string3, String string4, Object object) {
        Object object2;
        this.buf.setLength(0);
        this.buf.append('\n');
        if ((n & 0x20000) != 0) {
            this.buf.append(this.tab).append("// DEPRECATED\n");
        }
        this.buf.append(this.tab).append("// access flags 0x").append(Integer.toHexString(n).toUpperCase()).append('\n');
        if (string4 != null) {
            this.buf.append(this.tab);
            this.appendDescriptor(2, string4);
            object2 = new TraceSignatureVisitor(0);
            SignatureReader signatureReader = new SignatureReader(string4);
            signatureReader.acceptType((SignatureVisitor)object2);
            this.buf.append(this.tab).append("// declaration: ").append(((TraceSignatureVisitor)object2).getDeclaration()).append('\n');
        }
        this.buf.append(this.tab);
        this.appendAccess(n);
        this.appendDescriptor(1, string3);
        this.buf.append(' ').append(string2);
        if (object != null) {
            this.buf.append(" = ");
            if (object instanceof String) {
                this.buf.append('\"').append(object).append('\"');
            } else {
                this.buf.append(object);
            }
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        object2 = this.createTextifier();
        this.text.add(((Printer)object2).getText());
        return object2;
    }

    public Textifier visitMethod(int n, String string2, String string3, String string4, String[] stringArray) {
        Object object;
        this.buf.setLength(0);
        this.buf.append('\n');
        if ((n & 0x20000) != 0) {
            this.buf.append(this.tab).append("// DEPRECATED\n");
        }
        this.buf.append(this.tab).append("// access flags 0x").append(Integer.toHexString(n).toUpperCase()).append('\n');
        if (string4 != null) {
            this.buf.append(this.tab);
            this.appendDescriptor(4, string4);
            object = new TraceSignatureVisitor(0);
            SignatureReader signatureReader = new SignatureReader(string4);
            signatureReader.accept((SignatureVisitor)object);
            String string5 = ((TraceSignatureVisitor)object).getDeclaration();
            String string6 = ((TraceSignatureVisitor)object).getReturnType();
            String string7 = ((TraceSignatureVisitor)object).getExceptions();
            this.buf.append(this.tab).append("// declaration: ").append(string6).append(' ').append(string2).append(string5);
            if (string7 != null) {
                this.buf.append(" throws ").append(string7);
            }
            this.buf.append('\n');
        }
        this.buf.append(this.tab);
        this.appendAccess(n);
        if ((n & 0x100) != 0) {
            this.buf.append("native ");
        }
        if ((n & 0x80) != 0) {
            this.buf.append("varargs ");
        }
        if ((n & 0x40) != 0) {
            this.buf.append("bridge ");
        }
        this.buf.append(string2);
        this.appendDescriptor(3, string3);
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append(" throws ");
            for (int j = 0; j < stringArray.length; ++j) {
                this.appendDescriptor(0, stringArray[j]);
                this.buf.append(' ');
            }
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        object = this.createTextifier();
        this.text.add(((Printer)object).getText());
        return object;
    }

    public void visitClassEnd() {
        this.text.add("}\n");
    }

    public void visit(String string2, Object object) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string2 != null) {
            this.buf.append(string2).append('=');
        }
        if (object instanceof String) {
            this.visitString((String)object);
        } else if (object instanceof Type) {
            this.visitType((Type)object);
        } else if (object instanceof Byte) {
            this.visitByte((Byte)object);
        } else if (object instanceof Boolean) {
            this.visitBoolean((Boolean)object);
        } else if (object instanceof Short) {
            this.visitShort((Short)object);
        } else if (object instanceof Character) {
            this.visitChar(((Character)object).charValue());
        } else if (object instanceof Integer) {
            this.visitInt((Integer)object);
        } else if (object instanceof Float) {
            this.visitFloat(((Float)object).floatValue());
        } else if (object instanceof Long) {
            this.visitLong((Long)object);
        } else if (object instanceof Double) {
            this.visitDouble((Double)object);
        } else if (object.getClass().isArray()) {
            this.buf.append('{');
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                for (int j = 0; j < byArray.length; ++j) {
                    this.appendComa(j);
                    this.visitByte(byArray[j]);
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                for (int j = 0; j < blArray.length; ++j) {
                    this.appendComa(j);
                    this.visitBoolean(blArray[j]);
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                for (int j = 0; j < sArray.length; ++j) {
                    this.appendComa(j);
                    this.visitShort(sArray[j]);
                }
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                for (int j = 0; j < cArray.length; ++j) {
                    this.appendComa(j);
                    this.visitChar(cArray[j]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                for (int j = 0; j < nArray.length; ++j) {
                    this.appendComa(j);
                    this.visitInt(nArray[j]);
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                for (int j = 0; j < lArray.length; ++j) {
                    this.appendComa(j);
                    this.visitLong(lArray[j]);
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                for (int j = 0; j < fArray.length; ++j) {
                    this.appendComa(j);
                    this.visitFloat(fArray[j]);
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                for (int j = 0; j < dArray.length; ++j) {
                    this.appendComa(j);
                    this.visitDouble(dArray[j]);
                }
            }
            this.buf.append('}');
        }
        this.text.add(this.buf.toString());
    }

    private void visitInt(int n) {
        this.buf.append(n);
    }

    private void visitLong(long l) {
        this.buf.append(l).append('L');
    }

    private void visitFloat(float f) {
        this.buf.append(f).append('F');
    }

    private void visitDouble(double d) {
        this.buf.append(d).append('D');
    }

    private void visitChar(char c) {
        this.buf.append("(char)").append((int)c);
    }

    private void visitShort(short s2) {
        this.buf.append("(short)").append(s2);
    }

    private void visitByte(byte by) {
        this.buf.append("(byte)").append(by);
    }

    private void visitBoolean(boolean bl) {
        this.buf.append(bl);
    }

    private void visitString(String string2) {
        Textifier.appendString(this.buf, string2);
    }

    private void visitType(Type type2) {
        this.buf.append(type2.getClassName()).append(".class");
    }

    public void visitEnum(String string2, String string3, String string4) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string2 != null) {
            this.buf.append(string2).append('=');
        }
        this.appendDescriptor(1, string3);
        this.buf.append('.').append(string4);
        this.text.add(this.buf.toString());
    }

    public Textifier visitAnnotation(String string2, String string3) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string2 != null) {
            this.buf.append(string2).append('=');
        }
        this.buf.append('@');
        this.appendDescriptor(1, string3);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        this.text.add(")");
        return textifier;
    }

    public Textifier visitArray(String string2) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string2 != null) {
            this.buf.append(string2).append('=');
        }
        this.buf.append('{');
        this.text.add(this.buf.toString());
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        this.text.add("}");
        return textifier;
    }

    public void visitAnnotationEnd() {
    }

    public Textifier visitFieldAnnotation(String string2, boolean bl) {
        return this.visitAnnotation(string2, bl);
    }

    public void visitFieldAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitFieldEnd() {
    }

    public Textifier visitAnnotationDefault() {
        this.text.add(this.tab2 + "default=");
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        this.text.add("\n");
        return textifier;
    }

    public Textifier visitMethodAnnotation(String string2, boolean bl) {
        return this.visitAnnotation(string2, bl);
    }

    public Textifier visitParameterAnnotation(int n, String string2, boolean bl) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append('@');
        this.appendDescriptor(1, string2);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        this.text.add(bl ? ") // parameter " : ") // invisible, parameter ");
        this.text.add(new Integer(n));
        this.text.add("\n");
        return textifier;
    }

    public void visitMethodAttribute(Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        if (attribute instanceof Textifiable) {
            ((Textifiable)((Object)attribute)).textify(this.buf, this.labelNames);
        } else {
            this.buf.append(" : unknown\n");
        }
        this.text.add(this.buf.toString());
    }

    public void visitCode() {
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.buf.setLength(0);
        this.buf.append(this.ltab);
        this.buf.append("FRAME ");
        switch (n) {
            case -1: 
            case 0: {
                this.buf.append("FULL [");
                this.appendFrameTypes(n2, objectArray);
                this.buf.append("] [");
                this.appendFrameTypes(n3, objectArray2);
                this.buf.append(']');
                break;
            }
            case 1: {
                this.buf.append("APPEND [");
                this.appendFrameTypes(n2, objectArray);
                this.buf.append(']');
                break;
            }
            case 2: {
                this.buf.append("CHOP ").append(n2);
                break;
            }
            case 3: {
                this.buf.append("SAME");
                break;
            }
            case 4: {
                this.buf.append("SAME1 ");
                this.appendFrameTypes(1, objectArray2);
            }
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitInsn(int n) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitIntInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ').append(n == 188 ? TYPES[n2] : Integer.toString(n2)).append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitVarInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ').append(n2).append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitTypeInsn(int n, String string2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendDescriptor(0, string2);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitFieldInsn(int n, String string2, String string3, String string4) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendDescriptor(0, string2);
        this.buf.append('.').append(string3).append(" : ");
        this.appendDescriptor(1, string4);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitMethodInsn(int n, String string2, String string3, String string4) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendDescriptor(0, string2);
        this.buf.append('.').append(string3).append(' ');
        this.appendDescriptor(3, string4);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitInvokeDynamicInsn(String string2, String string3, Handle handle, Object ... objectArray) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("INVOKEDYNAMIC").append(' ');
        this.buf.append(string2);
        this.appendDescriptor(3, string3);
        this.buf.append(" [");
        this.appendHandle(handle);
        this.buf.append(this.tab3).append("// arguments:");
        if (objectArray.length == 0) {
            this.buf.append(" none");
        } else {
            this.buf.append('\n').append(this.tab3);
            for (int j = 0; j < objectArray.length; ++j) {
                Object object = objectArray[j];
                if (object instanceof String) {
                    Printer.appendString(this.buf, (String)object);
                } else if (object instanceof Type) {
                    this.buf.append(((Type)object).getDescriptor()).append(".class");
                } else if (object instanceof Handle) {
                    this.appendHandle((Handle)object);
                } else {
                    this.buf.append(object);
                }
                this.buf.append(", ");
            }
            this.buf.setLength(this.buf.length() - 2);
        }
        this.buf.append('\n');
        this.buf.append(this.tab2).append("]\n");
        this.text.add(this.buf.toString());
    }

    public void visitJumpInsn(int n, Label label) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.buf.append(this.ltab);
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitLdcInsn(Object object) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LDC ");
        if (object instanceof String) {
            Printer.appendString(this.buf, (String)object);
        } else if (object instanceof Type) {
            this.buf.append(((Type)object).getDescriptor()).append(".class");
        } else {
            this.buf.append(object);
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitIincInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("IINC ").append(n).append(' ').append(n2).append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TABLESWITCH\n");
        for (int j = 0; j < labelArray.length; ++j) {
            this.buf.append(this.tab3).append(n + j).append(": ");
            this.appendLabel(labelArray[j]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOOKUPSWITCH\n");
        for (int j = 0; j < labelArray.length; ++j) {
            this.buf.append(this.tab3).append(nArray[j]).append(": ");
            this.appendLabel(labelArray[j]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitMultiANewArrayInsn(String string2, int n) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MULTIANEWARRAY ");
        this.appendDescriptor(1, string2);
        this.buf.append(' ').append(n).append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TRYCATCHBLOCK ");
        this.appendLabel(label);
        this.buf.append(' ');
        this.appendLabel(label2);
        this.buf.append(' ');
        this.appendLabel(label3);
        this.buf.append(' ');
        this.appendDescriptor(0, string2);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitLocalVariable(String string2, String string3, String string4, Label label, Label label2, int n) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOCALVARIABLE ").append(string2).append(' ');
        this.appendDescriptor(1, string3);
        this.buf.append(' ');
        this.appendLabel(label);
        this.buf.append(' ');
        this.appendLabel(label2);
        this.buf.append(' ').append(n).append('\n');
        if (string4 != null) {
            this.buf.append(this.tab2);
            this.appendDescriptor(2, string4);
            TraceSignatureVisitor traceSignatureVisitor = new TraceSignatureVisitor(0);
            SignatureReader signatureReader = new SignatureReader(string4);
            signatureReader.acceptType(traceSignatureVisitor);
            this.buf.append(this.tab2).append("// declaration: ").append(traceSignatureVisitor.getDeclaration()).append('\n');
        }
        this.text.add(this.buf.toString());
    }

    public void visitLineNumber(int n, Label label) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LINENUMBER ").append(n).append(' ');
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitMaxs(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXSTACK = ").append(n).append('\n');
        this.text.add(this.buf.toString());
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXLOCALS = ").append(n2).append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitMethodEnd() {
    }

    public Textifier visitAnnotation(String string2, boolean bl) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append('@');
        this.appendDescriptor(1, string2);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        this.text.add(bl ? ")\n" : ") // invisible\n");
        return textifier;
    }

    public void visitAttribute(Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        if (attribute instanceof Textifiable) {
            ((Textifiable)((Object)attribute)).textify(this.buf, null);
        } else {
            this.buf.append(" : unknown\n");
        }
        this.text.add(this.buf.toString());
    }

    protected Textifier createTextifier() {
        return new Textifier();
    }

    protected void appendDescriptor(int n, String string2) {
        if (n == 5 || n == 2 || n == 4) {
            if (string2 != null) {
                this.buf.append("// signature ").append(string2).append('\n');
            }
        } else {
            this.buf.append(string2);
        }
    }

    protected void appendLabel(Label label) {
        String string2;
        if (this.labelNames == null) {
            this.labelNames = new HashMap();
        }
        if ((string2 = (String)this.labelNames.get(label)) == null) {
            string2 = "L" + this.labelNames.size();
            this.labelNames.put(label, string2);
        }
        this.buf.append(string2);
    }

    protected void appendHandle(Handle handle) {
        this.buf.append('\n').append(this.tab3);
        int n = handle.getTag();
        this.buf.append("// handle kind 0x").append(Integer.toHexString(n)).append(" : ");
        switch (n) {
            case 1: {
                this.buf.append("GETFIELD");
                break;
            }
            case 2: {
                this.buf.append("GETSTATIC");
                break;
            }
            case 3: {
                this.buf.append("PUTFIELD");
                break;
            }
            case 4: {
                this.buf.append("PUTSTATIC");
                break;
            }
            case 9: {
                this.buf.append("INVOKEINTERFACE");
                break;
            }
            case 7: {
                this.buf.append("INVOKESPECIAL");
                break;
            }
            case 6: {
                this.buf.append("INVOKESTATIC");
                break;
            }
            case 5: {
                this.buf.append("INVOKEVIRTUAL");
                break;
            }
            case 8: {
                this.buf.append("NEWINVOKESPECIAL");
            }
        }
        this.buf.append('\n');
        this.buf.append(this.tab3);
        this.appendDescriptor(0, handle.getOwner());
        this.buf.append('.');
        this.buf.append(handle.getName());
        this.buf.append('(');
        this.appendDescriptor(9, handle.getDesc());
        this.buf.append(')').append('\n');
    }

    private void appendAccess(int n) {
        if ((n & 1) != 0) {
            this.buf.append("public ");
        }
        if ((n & 2) != 0) {
            this.buf.append("private ");
        }
        if ((n & 4) != 0) {
            this.buf.append("protected ");
        }
        if ((n & 0x10) != 0) {
            this.buf.append("final ");
        }
        if ((n & 8) != 0) {
            this.buf.append("static ");
        }
        if ((n & 0x20) != 0) {
            this.buf.append("synchronized ");
        }
        if ((n & 0x40) != 0) {
            this.buf.append("volatile ");
        }
        if ((n & 0x80) != 0) {
            this.buf.append("transient ");
        }
        if ((n & 0x400) != 0) {
            this.buf.append("abstract ");
        }
        if ((n & 0x800) != 0) {
            this.buf.append("strictfp ");
        }
        if ((n & 0x4000) != 0) {
            this.buf.append("enum ");
        }
    }

    private void appendComa(int n) {
        if (n != 0) {
            this.buf.append(", ");
        }
    }

    private void appendFrameTypes(int n, Object[] objectArray) {
        for (int j = 0; j < n; ++j) {
            if (j > 0) {
                this.buf.append(' ');
            }
            if (objectArray[j] instanceof String) {
                String string2 = (String)objectArray[j];
                if (string2.startsWith("[")) {
                    this.appendDescriptor(1, string2);
                    continue;
                }
                this.appendDescriptor(0, string2);
                continue;
            }
            if (objectArray[j] instanceof Integer) {
                switch ((Integer)objectArray[j]) {
                    case 0: {
                        this.appendDescriptor(1, "T");
                        break;
                    }
                    case 1: {
                        this.appendDescriptor(1, "I");
                        break;
                    }
                    case 2: {
                        this.appendDescriptor(1, "F");
                        break;
                    }
                    case 3: {
                        this.appendDescriptor(1, "D");
                        break;
                    }
                    case 4: {
                        this.appendDescriptor(1, "J");
                        break;
                    }
                    case 5: {
                        this.appendDescriptor(1, "N");
                        break;
                    }
                    case 6: {
                        this.appendDescriptor(1, "U");
                    }
                }
                continue;
            }
            this.appendLabel((Label)objectArray[j]);
        }
    }
}

