/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.scriptengines.jruby;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScriptEngineFactoryLookup {
    private static final boolean DEBUG = false;

    ScriptEngineFactoryLookup() {
    }

    static HashSet<ScriptEngineFactory> lookup(ClassLoader loader, String name) {
        HashSet<ScriptEngineFactory> factories = new HashSet<ScriptEngineFactory>();
        try {
            Enumeration<URL> urls = loader.getResources(name);
            while (urls.hasMoreElements()) {
                String line;
                URL url = urls.nextElement();
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    if ((line = ScriptEngineFactoryLookup.trim(line)) == null) continue;
                    try {
                        Class<?> clazz = Class.forName(line, true, loader);
                        ScriptEngineFactory factory = (ScriptEngineFactory)clazz.newInstance();
                        factories.add(factory);
                    }
                    catch (UnsupportedClassVersionError error) {}
                }
            }
        }
        catch (IOException ex) {
            throw new ScriptException(ex);
        }
        finally {
            return factories;
        }
    }

    private static String trim(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(line, "#");
        return ((String)st.nextElement()).trim();
    }
}

