/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyThread;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ThreadService {
    private Ruby runtime;
    private ThreadContext mainContext;
    private ThreadLocal<SoftReference<ThreadContext>> localContext;
    private ThreadGroup rubyThreadGroup;
    private final Map<Object, RubyThread> rubyThreadMap;
    private final ReentrantLock criticalLock = new ReentrantLock();

    public ThreadService(Ruby runtime) {
        this.runtime = runtime;
        this.localContext = new ThreadLocal();
        try {
            this.rubyThreadGroup = new ThreadGroup("Ruby Threads#" + runtime.hashCode());
        }
        catch (SecurityException e) {
            this.rubyThreadGroup = Thread.currentThread().getThreadGroup();
        }
        this.rubyThreadMap = Collections.synchronizedMap(new WeakHashMap());
    }

    public void disposeCurrentThread() {
        this.localContext.set(null);
        this.rubyThreadMap.remove(Thread.currentThread());
    }

    public void initMainThread() {
        this.mainContext = ThreadContext.newContext(this.runtime);
        this.localContext.set(new SoftReference<ThreadContext>(this.mainContext));
    }

    public ThreadContext getCurrentContext() {
        SoftReference sr = null;
        ThreadContext context = null;
        while (context == null) {
            sr = this.localContext.get();
            if (sr == null) {
                sr = this.adoptCurrentThread();
                context = (ThreadContext)sr.get();
            } else {
                context = sr.get();
            }
            if (context != null) continue;
            this.localContext.set(null);
        }
        return context;
    }

    public void setCurrentContext(ThreadContext context) {
        this.localContext.set(new SoftReference<ThreadContext>(context));
    }

    private SoftReference adoptCurrentThread() {
        Thread current2 = Thread.currentThread();
        RubyThread.adopt(this.runtime.getThread(), current2);
        return this.localContext.get();
    }

    public RubyThread getMainThread() {
        return this.mainContext.getThread();
    }

    public void setMainThread(Thread thread2, RubyThread rubyThread) {
        this.mainContext.setThread(rubyThread);
        this.rubyThreadMap.put(thread2, rubyThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RubyThread[] getActiveRubyThreads() {
        Map<Object, RubyThread> map = this.rubyThreadMap;
        synchronized (map) {
            ArrayList<RubyThread> rtList = new ArrayList<RubyThread>(this.rubyThreadMap.size());
            for (Map.Entry<Object, RubyThread> entry : this.rubyThreadMap.entrySet()) {
                Future f;
                Thread t;
                Object key2 = entry.getKey();
                if (key2 == null || (key2 instanceof Thread ? !(t = (Thread)key2).isAlive() : key2 instanceof Future && ((f = (Future)key2).isDone() || f.isCancelled()))) continue;
                rtList.add(entry.getValue());
            }
            RubyThread[] rubyThreads = new RubyThread[rtList.size()];
            rtList.toArray(rubyThreads);
            return rubyThreads;
        }
    }

    public ThreadGroup getRubyThreadGroup() {
        return this.rubyThreadGroup;
    }

    public ThreadContext getThreadContextForThread(RubyThread thread2) {
        return thread2.getContext();
    }

    public synchronized ThreadContext registerNewThread(RubyThread thread2) {
        ThreadContext context = ThreadContext.newContext(this.runtime);
        this.localContext.set(new SoftReference<ThreadContext>(context));
        context.setThread(thread2);
        return context;
    }

    public synchronized void associateThread(Object threadOrFuture, RubyThread rubyThread) {
        this.rubyThreadMap.put(threadOrFuture, rubyThread);
    }

    public synchronized void dissociateThread(Object threadOrFuture) {
        this.rubyThreadMap.remove(threadOrFuture);
    }

    public synchronized void unregisterThread(RubyThread thread2) {
        this.rubyThreadMap.remove(Thread.currentThread());
        this.getCurrentContext().setThread(null);
        this.localContext.set(null);
    }

    public void setCritical(boolean critical2) {
        if (critical2 && !this.criticalLock.isHeldByCurrentThread()) {
            this.acquireCritical();
        } else if (!critical2 && this.criticalLock.isHeldByCurrentThread()) {
            this.releaseCritical();
        }
    }

    private void acquireCritical() {
        this.criticalLock.lock();
    }

    private void releaseCritical() {
        this.criticalLock.unlock();
    }

    public boolean getCritical() {
        return this.criticalLock.isHeldByCurrentThread();
    }

    public synchronized void deliverEvent(Event event) {
        event.sender.checkMail(this.getCurrentContext());
        event.target.receiveMail(event);
    }

    public Map<Object, RubyThread> getRubyThreadMap() {
        return this.rubyThreadMap;
    }

    public static class Event {
        public final RubyThread sender;
        public final RubyThread target;
        public final Type type;
        public final IRubyObject exception;

        public Event(RubyThread sender, RubyThread target, Type type2) {
            this(sender, target, type2, null);
        }

        public Event(RubyThread sender, RubyThread target, Type type2, IRubyObject exception2) {
            this.sender = sender;
            this.target = target;
            this.type = type2;
            this.exception = exception2;
        }

        public static enum Type {
            KILL,
            RAISE,
            WAKEUP;

        }
    }
}

