/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.specialized.OneArgOperandAttrAssignInstr;
import org.jruby.ir.operands.MethAddr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AttrAssignInstr
extends NoResultCallInstr {
    public AttrAssignInstr(Operand obj, MethAddr attr2, Operand[] args2) {
        super(Operation.ATTR_ASSIGN, CallType.UNKNOWN, attr2, obj, args2, null);
    }

    public AttrAssignInstr(AttrAssignInstr instr) {
        this(instr.getReceiver(), instr.getMethodAddr(), instr.getCallArgs());
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new AttrAssignInstr(this.receiver.cloneForInlining(ii), (MethAddr)this.getMethodAddr().cloneForInlining(ii), this.cloneCallArgs(ii));
    }

    @Override
    public CallBase specializeForInterpretation() {
        Operand[] callArgs = this.getCallArgs();
        if (AttrAssignInstr.containsSplat(callArgs)) {
            return this;
        }
        switch (callArgs.length) {
            case 1: {
                return new OneArgOperandAttrAssignInstr(this);
            }
        }
        return this;
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope dynamicScope, IRubyObject self, Object[] temp, Block block) {
        IRubyObject object = (IRubyObject)this.receiver.retrieve(context, self, dynamicScope, temp);
        IRubyObject[] values2 = this.prepareArguments(context, self, this.getCallArgs(), dynamicScope, temp);
        CallType callType = self == object ? CallType.FUNCTIONAL : CallType.NORMAL;
        RuntimeHelpers.invoke(context, object, this.getMethodAddr().getName(), values2, callType, Block.NULL_BLOCK);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.AttrAssignInstr(this);
    }
}

