/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRClosure;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.parser.IRStaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ZSuperInstr
extends UnresolvedSuperInstr {
    public ZSuperInstr(Variable result2, Operand receiver2, Operand closure) {
        super(Operation.ZSUPER, result2, receiver2, closure);
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new ZSuperInstr(ii.getRenamedVariable(this.result), this.getReceiver().cloneForInlining(ii), this.closure == null ? null : this.closure.cloneForInlining(ii));
    }

    @Override
    public Operand[] getOperands() {
        Operand[] operandArray;
        if (this.closure == null) {
            operandArray = EMPTY_OPERANDS;
        } else {
            Operand[] operandArray2 = new Operand[1];
            operandArray = operandArray2;
            operandArray2[0] = this.closure;
        }
        return operandArray;
    }

    @Override
    protected IRubyObject[] prepareArguments(ThreadContext context, IRubyObject self, Operand[] arguments, DynamicScope dynamicScope, Object[] temp) {
        return ZSuperInstr.containsSplat(arguments) ? this.prepareArgumentsComplex(context, self, arguments, dynamicScope, temp) : this.prepareArgumentsSimple(context, self, arguments, dynamicScope, temp);
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block aBlock) {
        DynamicScope argsDynScope = currDynScope;
        while (!argsDynScope.getStaticScope().isArgumentScope()) {
            argsDynScope = argsDynScope.getNextCapturedScope();
        }
        IRScope argsIRScope = ((IRStaticScope)argsDynScope.getStaticScope()).getIRScope();
        Operand[] superArgs = argsIRScope instanceof IRMethod ? ((IRMethod)argsIRScope).getCallArgs() : ((IRClosure)argsIRScope).getBlockArgs();
        IRubyObject[] args2 = this.prepareArguments(context, self, superArgs, argsDynScope, temp);
        Block block = this.prepareBlock(context, self, currDynScope, temp);
        if (block == null || !block.isGiven()) {
            block = context.getFrameBlock();
        }
        return this.interpretSuper(context, self, args2, block);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ZSuperInstr(this);
    }
}

