/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import java.lang.invoke.TypeDescriptor;
import java.math.BigInteger;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.JumpException;
import org.jruby.ext.ffi.jffi.DefaultMethod;
import org.jruby.ext.ffi.jffi.InvokeDynamic;
import org.jruby.ext.ffi.jffi.JITNativeInvoker;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.AttrReaderMethod;
import org.jruby.internal.runtime.methods.AttrWriterMethod;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.Framing;
import org.jruby.internal.runtime.methods.JittedMethod;
import org.jruby.internal.runtime.methods.ProfilingDynamicMethod;
import org.jruby.internal.runtime.methods.Scoping;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.java.invokers.SingletonMethodInvoker;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.runtime.invokedynamic.JRubyCallSite;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InvocationLinker {
    private static final Logger LOG = LoggerFactory.getLogger("InvocationLinker");
    private static final MethodHandle BLOCK_ESCAPE = InvokeDynamicSupport.findStatic(InvocationLinker.class, "blockEscape", MethodType.methodType(Void.TYPE, Block.class));
    private static final MethodHandle HANDLE_BREAK_JUMP = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "handleBreakJump", MethodType.methodType(IRubyObject.class, JumpException.BreakJump.class, ThreadContext.class));
    private static final MethodHandle IS_JAVA_SUBCLASS = InvokeDynamicSupport.findStatic(InvocationLinker.class, "subclassProxyTest", MethodType.methodType(Boolean.TYPE, Object.class));
    private static final MethodHandle GETMETHOD;
    private static final MethodHandle PGC;
    private static final MethodHandle TEST_GENERATION;
    private static final MethodHandle TEST_METACLASS;
    private static final MethodHandle TEST;
    private static final MethodHandle TEST_CLASS;
    private static final MethodHandle TARGET_0;
    private static final MethodHandle FALLBACK_0;
    private static final MethodHandle FAIL_0;
    private static final MethodHandle TARGET_1;
    private static final MethodHandle FALLBACK_1;
    private static final MethodHandle FAIL_1;
    private static final MethodHandle TARGET_2;
    private static final MethodHandle FALLBACK_2;
    private static final MethodHandle FAIL_2;
    private static final MethodHandle TARGET_3;
    private static final MethodHandle FALLBACK_3;
    private static final MethodHandle FAIL_3;
    private static final MethodHandle TARGET_N;
    private static final MethodHandle FALLBACK_N;
    private static final MethodHandle FAIL_N;
    private static final MethodHandle TARGET_0_B;
    private static final MethodHandle FALLBACK_0_B;
    private static final MethodHandle FAIL_0_B;
    private static final MethodHandle TARGET_1_B;
    private static final MethodHandle FALLBACK_1_B;
    private static final MethodHandle FAIL_1_B;
    private static final MethodHandle TARGET_2_B;
    private static final MethodHandle FALLBACK_2_B;
    private static final MethodHandle FAIL_2_B;
    private static final MethodHandle TARGET_3_B;
    private static final MethodHandle FALLBACK_3_B;
    private static final MethodHandle FAIL_3_B;
    private static final MethodHandle TARGET_N_B;
    private static final MethodHandle FALLBACK_N_B;
    private static final MethodHandle FAIL_N_B;
    private static final MethodHandle[] FALLBACKS;
    private static final MethodHandle[] FAILS;
    private static final MethodHandle[] FALLBACKS_B;
    private static final MethodHandle[] FAILS_B;
    private static final MethodType STANDARD_NATIVE_TYPE;
    private static final MethodType STANDARD_NATIVE_TYPE_1ARG;
    private static final MethodType STANDARD_NATIVE_TYPE_2ARG;
    private static final MethodType STANDARD_NATIVE_TYPE_3ARG;
    private static final MethodType STANDARD_NATIVE_TYPE_NARG;
    private static final MethodType[] STANDARD_NATIVE_TYPES;
    private static final MethodType STANDARD_NATIVE_TYPE_BLOCK;
    private static final MethodType STANDARD_NATIVE_TYPE_1ARG_BLOCK;
    private static final MethodType STANDARD_NATIVE_TYPE_2ARG_BLOCK;
    private static final MethodType STANDARD_NATIVE_TYPE_3ARG_BLOCK;
    private static final MethodType STANDARD_NATIVE_TYPE_NARG_BLOCK;
    private static final MethodType[] STANDARD_NATIVE_TYPES_BLOCK;
    private static final MethodType TARGET_SELF;
    private static final MethodType TARGET_SELF_1ARG;
    private static final MethodType TARGET_SELF_2ARG;
    private static final MethodType TARGET_SELF_3ARG;
    private static final MethodType TARGET_SELF_NARG;
    private static final MethodType[] TARGET_SELF_ARGS;
    private static final MethodType TARGET_SELF_BLOCK;
    private static final MethodType TARGET_SELF_1ARG_BLOCK;
    private static final MethodType TARGET_SELF_2ARG_BLOCK;
    private static final MethodType TARGET_SELF_3ARG_BLOCK;
    private static final MethodType TARGET_SELF_NARG_BLOCK;
    private static final MethodType[] TARGET_SELF_ARGS_BLOCK;
    private static final MethodType TARGET_SELF_TC;
    private static final MethodType TARGET_SELF_TC_1ARG;
    private static final MethodType TARGET_SELF_TC_2ARG;
    private static final MethodType TARGET_SELF_TC_3ARG;
    private static final MethodType TARGET_SELF_TC_NARG;
    private static final MethodType[] TARGET_SELF_TC_ARGS;
    private static final MethodType TARGET_SELF_TC_BLOCK;
    private static final MethodType TARGET_SELF_TC_1ARG_BLOCK;
    private static final MethodType TARGET_SELF_TC_2ARG_BLOCK;
    private static final MethodType TARGET_SELF_TC_3ARG_BLOCK;
    private static final MethodType TARGET_SELF_TC_NARG_BLOCK;
    private static final MethodType[] TARGET_SELF_TC_ARGS_BLOCK;
    private static final MethodType TARGET_TC_SELF;
    private static final MethodType TARGET_TC_SELF_1ARG;
    private static final MethodType TARGET_TC_SELF_2ARG;
    private static final MethodType TARGET_TC_SELF_3ARG;
    private static final MethodType TARGET_TC_SELF_NARG;
    private static final MethodType[] TARGET_TC_SELF_ARGS;
    private static final MethodType TARGET_TC_SELF_BLOCK;
    private static final MethodType TARGET_TC_SELF_1ARG_BLOCK;
    private static final MethodType TARGET_TC_SELF_2ARG_BLOCK;
    private static final MethodType TARGET_TC_SELF_3ARG_BLOCK;
    private static final MethodType TARGET_TC_SELF_NARG_BLOCK;
    private static final MethodType[] TARGET_TC_SELF_ARGS_BLOCK;
    private static final int[] SELF_TC_PERMUTE;
    private static final int[] SELF_TC_1ARG_PERMUTE;
    private static final int[] SELF_TC_2ARG_PERMUTE;
    private static final int[] SELF_TC_3ARG_PERMUTE;
    private static final int[] SELF_TC_NARG_PERMUTE;
    private static final int[][] SELF_TC_ARGS_PERMUTES;
    private static final int[] SELF_PERMUTE;
    private static final int[] SELF_1ARG_PERMUTE;
    private static final int[] SELF_2ARG_PERMUTE;
    private static final int[] SELF_3ARG_PERMUTE;
    private static final int[] SELF_NARG_PERMUTE;
    private static final int[][] SELF_ARGS_PERMUTES;
    private static final int[] SELF_TC_BLOCK_PERMUTE;
    private static final int[] SELF_TC_1ARG_BLOCK_PERMUTE;
    private static final int[] SELF_TC_2ARG_BLOCK_PERMUTE;
    private static final int[] SELF_TC_3ARG_BLOCK_PERMUTE;
    private static final int[] SELF_TC_NARG_BLOCK_PERMUTE;
    private static final int[][] SELF_TC_ARGS_BLOCK_PERMUTES;
    private static final int[] SELF_BLOCK_PERMUTE;
    private static final int[] SELF_1ARG_BLOCK_PERMUTE;
    private static final int[] SELF_2ARG_BLOCK_PERMUTE;
    private static final int[] SELF_3ARG_BLOCK_PERMUTE;
    private static final int[] SELF_NARG_BLOCK_PERMUTE;
    private static final int[][] SELF_ARGS_BLOCK_PERMUTES;
    private static final int[] TC_SELF_PERMUTE;
    private static final int[] TC_SELF_1ARG_PERMUTE;
    private static final int[] TC_SELF_2ARG_PERMUTE;
    private static final int[] TC_SELF_3ARG_PERMUTE;
    private static final int[] TC_SELF_NARG_PERMUTE;
    private static final int[][] TC_SELF_ARGS_PERMUTES;
    private static final int[] TC_SELF_BLOCK_PERMUTE;
    private static final int[] TC_SELF_1ARG_BLOCK_PERMUTE;
    private static final int[] TC_SELF_2ARG_BLOCK_PERMUTE;
    private static final int[] TC_SELF_3ARG_BLOCK_PERMUTE;
    private static final int[] TC_SELF_NARG_BLOCK_PERMUTE;
    private static final int[][] TC_SELF_ARGS_BLOCK_PERMUTES;
    private static final int[] TC_SELF_BLOCK_PERMUTE_1;
    private static final int[] TC_SELF_BLOCK_PERMUTE_2;
    private static final int[] TC_SELF_BLOCK_PERMUTE_3;
    private static final int[] TC_SELF_BLOCK_PERMUTE_N;
    private static final int[][] TC_SELF_BLOCK_PERMUTES;

    public static CallSite invocationBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String file2, int line) throws NoSuchMethodException, IllegalAccessException {
        JRubyCallSite site;
        String[] names2 = name2.split(":");
        String operation = names2[0];
        if (name2.equals("yieldSpecific")) {
            MethodHandle target = lookup.findStatic(InvocationLinker.class, "yieldSpecificFallback", type2);
            return new ConstantCallSite(target);
        }
        String method2 = JavaNameMangler.demangleMethodName(names2[1]);
        if (operation.equals("call")) {
            site = new JRubyCallSite(lookup, type2, CallType.NORMAL, file2, line, method2, false, false, true);
        } else if (operation.equals("fcall")) {
            site = new JRubyCallSite(lookup, type2, CallType.FUNCTIONAL, file2, line, method2, false, false, true);
        } else if (operation.equals("vcall")) {
            site = new JRubyCallSite(lookup, type2, CallType.VARIABLE, file2, line, method2, false, false, true);
        } else if (operation.equals("callIter")) {
            site = new JRubyCallSite(lookup, type2, CallType.NORMAL, file2, line, method2, false, true, true);
        } else if (operation.equals("fcallIter")) {
            site = new JRubyCallSite(lookup, type2, CallType.FUNCTIONAL, file2, line, method2, false, true, true);
        } else if (operation.equals("vcallIter")) {
            site = new JRubyCallSite(lookup, type2, CallType.VARIABLE, file2, line, method2, false, true, true);
        } else if (operation.equals("attrAssign")) {
            site = new JRubyCallSite(lookup, type2, CallType.NORMAL, file2, line, method2, true, false, false);
        } else if (operation.equals("attrAssignSelf")) {
            site = new JRubyCallSite(lookup, type2, CallType.VARIABLE, file2, line, method2, true, false, false);
        } else if (operation.equals("attrAssignExpr")) {
            site = new JRubyCallSite(lookup, type2, CallType.NORMAL, file2, line, method2, true, false, true);
        } else if (operation.equals("attrAssignSelfExpr")) {
            site = new JRubyCallSite(lookup, type2, CallType.VARIABLE, file2, line, method2, true, false, true);
        } else {
            throw new RuntimeException("wrong invokedynamic target: " + name2);
        }
        MethodType fallbackType = type2.insertParameterTypes(0, JRubyCallSite.class);
        MethodHandle myFallback = MethodHandles.insertArguments(lookup.findStatic(InvocationLinker.class, "invocationFallback", fallbackType), 0, site);
        site.setInitialTarget(myFallback);
        return site;
    }

    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String method2 = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, method2);
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, method2, entry, 0);
        target = InvocationLinker.updateInvocationTarget(target, site, self, selfClass, method2, entry, switchPoint, false, 0);
        return (IRubyObject)target.invokeWithArguments(context, caller2, self);
    }

    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String method2 = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method2, caller2)) {
            IRubyObject mmResult = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, method2, arg0);
            return site.isAttrAssign() ? arg0 : mmResult;
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, method2, entry, 1);
        target = InvocationLinker.updateInvocationTarget(target, site, self, selfClass, method2, entry, switchPoint, false, 1);
        return (IRubyObject)target.invokeWithArguments(context, caller2, self, arg0);
    }

    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, IRubyObject arg1) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String method2 = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method2, caller2)) {
            IRubyObject mmResult = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, method2, arg0, arg1);
            return site.isAttrAssign() ? arg1 : mmResult;
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, method2, entry, 2);
        target = InvocationLinker.updateInvocationTarget(target, site, self, selfClass, method2, entry, switchPoint, false, 2);
        return (IRubyObject)target.invokeWithArguments(context, caller2, self, arg0, arg1);
    }

    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String method2 = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method2, caller2)) {
            IRubyObject mmResult = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, method2, arg0, arg1, arg2);
            return site.isAttrAssign() ? arg2 : mmResult;
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, method2, entry, 3);
        target = InvocationLinker.updateInvocationTarget(target, site, self, selfClass, method2, entry, switchPoint, false, 3);
        return (IRubyObject)target.invokeWithArguments(context, caller2, self, arg0, arg1, arg2);
    }

    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject[] args2) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String method2 = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method2, caller2)) {
            IRubyObject mmResult = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, method2, args2);
            return site.isAttrAssign() ? args2[args2.length - 1] : mmResult;
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, method2, entry, -1);
        target = InvocationLinker.updateInvocationTarget(target, site, self, selfClass, method2, entry, switchPoint, false, 4);
        return (IRubyObject)target.invokeWithArguments(context, caller2, self, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String method2 = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method2, caller2)) {
            try {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, method2, block);
                return iRubyObject;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
                return iRubyObject;
            }
            catch (JumpException.RetryJump rj) {
                IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
                return iRubyObject;
            }
            finally {
                if (site.isIterator()) {
                    block.escape();
                }
            }
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, method2, entry, 0);
        target = InvocationLinker.updateInvocationTarget(target, site, self, selfClass, method2, entry, switchPoint, true, 0);
        return (IRubyObject)target.invokeWithArguments(context, caller2, self, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String method2 = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method2, caller2)) {
            try {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, method2, arg0, block);
                return iRubyObject;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
                return iRubyObject;
            }
            catch (JumpException.RetryJump rj) {
                IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
                return iRubyObject;
            }
            finally {
                if (site.isIterator()) {
                    block.escape();
                }
            }
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, method2, entry, 1);
        target = InvocationLinker.updateInvocationTarget(target, site, self, selfClass, method2, entry, switchPoint, true, 1);
        return (IRubyObject)target.invokeWithArguments(context, caller2, self, arg0, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String method2 = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method2, caller2)) {
            try {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, method2, arg0, arg1, block);
                return iRubyObject;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
                return iRubyObject;
            }
            catch (JumpException.RetryJump rj) {
                IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
                return iRubyObject;
            }
            finally {
                if (site.isIterator()) {
                    block.escape();
                }
            }
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, method2, entry, 2);
        target = InvocationLinker.updateInvocationTarget(target, site, self, selfClass, method2, entry, switchPoint, true, 2);
        return (IRubyObject)target.invokeWithArguments(context, caller2, self, arg0, arg1, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String method2 = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method2, caller2)) {
            try {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, method2, arg0, arg1, arg2, block);
                return iRubyObject;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
                return iRubyObject;
            }
            catch (JumpException.RetryJump rj) {
                IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
                return iRubyObject;
            }
            finally {
                if (site.isIterator()) {
                    block.escape();
                }
            }
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, method2, entry, 3);
        target = InvocationLinker.updateInvocationTarget(target, site, self, selfClass, method2, entry, switchPoint, true, 3);
        return (IRubyObject)target.invokeWithArguments(context, caller2, self, arg0, arg1, arg2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String method2 = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method2, caller2)) {
            try {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, method2, args2, block);
                return iRubyObject;
            }
            catch (JumpException.BreakJump bj) {
                IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
                return iRubyObject;
            }
            catch (JumpException.RetryJump rj) {
                IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
                return iRubyObject;
            }
            finally {
                if (site.isIterator()) {
                    block.escape();
                }
            }
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, method2, entry, -1);
        target = InvocationLinker.updateInvocationTarget(target, site, self, selfClass, method2, entry, switchPoint, true, 4);
        return (IRubyObject)target.invokeWithArguments(context, caller2, self, args2, block);
    }

    private static MethodHandle updateInvocationTarget(MethodHandle target, JRubyCallSite site, IRubyObject self, RubyModule selfClass, String name2, CacheEntry entry, SwitchPoint switchPoint, boolean block, int arity2) {
        if (target == null || site.clearCount() > RubyInstanceConfig.MAX_FAIL_COUNT || !site.hasSeenType(selfClass.id) && site.seenTypesCount() > RubyInstanceConfig.MAX_POLY_COUNT) {
            target = InvocationLinker.createFail((block ? FAILS_B : FAILS)[arity2], site, name2, entry.method);
            site.setTarget(target);
        } else {
            boolean curry;
            MethodHandle fallback;
            target = InvocationLinker.postProcess(site, target);
            if (site.seenTypesCount() > 0 && site.getTarget() != null && !site.hasSeenType(selfClass.id)) {
                if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
                    LOG.info(name2 + "\tadded to PIC " + InvocationLinker.logMethod(entry.method), new Object[0]);
                }
                fallback = site.getTarget();
                curry = false;
            } else {
                String bind2;
                String string2 = bind2 = site.boundOnce() ? "rebind" : "bind";
                if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
                    LOG.info(name2 + "\ttriggered site #" + site.siteID() + " " + bind2 + " (" + site.file() + ":" + site.line() + ")", new Object[0]);
                }
                fallback = (block ? FALLBACKS_B : FALLBACKS)[arity2];
                site.clearTypes();
                curry = true;
            }
            site.addType(selfClass.id);
            Ruby runtime = selfClass.getRuntime();
            MethodHandle test2 = self instanceof RubySymbol || self instanceof RubyFixnum || self instanceof RubyFloat || self instanceof RubyNil || self instanceof RubyBoolean.True || self instanceof RubyBoolean.False ? Binder.from(site.type().changeReturnType(Boolean.TYPE)).permute(2).insert(1, self.getClass()).cast(Boolean.TYPE, Object.class, Class.class).invoke(TEST_CLASS) : Binder.from(site.type().changeReturnType(Boolean.TYPE)).permute(2).insert(0, RubyInstanceConfig.INVOKEDYNAMIC_INVOCATION_SWITCHPOINT ? selfClass : Integer.valueOf(entry.token)).cast(Boolean.TYPE, RubyClass.class, IRubyObject.class).invoke(TEST);
            MethodHandle gwt = InvocationLinker.createGWT(test2, target, fallback, entry, site, curry);
            if (RubyInstanceConfig.INVOKEDYNAMIC_INVOCATION_SWITCHPOINT) {
                gwt = switchPoint.guardWithTest(gwt, curry ? MethodHandles.insertArguments(fallback, 0, site) : fallback);
            }
            site.setTarget(gwt);
        }
        return target;
    }

    public static IRubyObject yieldSpecificFallback(Block block, ThreadContext context) throws Throwable {
        return block.yieldSpecific(context);
    }

    public static IRubyObject yieldSpecificFallback(Block block, ThreadContext context, IRubyObject arg0) throws Throwable {
        return block.yieldSpecific(context, arg0);
    }

    public static IRubyObject yieldSpecificFallback(Block block, ThreadContext context, IRubyObject arg0, IRubyObject arg1) throws Throwable {
        return block.yieldSpecific(context, arg0, arg1);
    }

    public static IRubyObject yieldSpecificFallback(Block block, ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) throws Throwable {
        return block.yieldSpecific(context, arg0, arg1, arg2);
    }

    private static MethodHandle createFail(MethodHandle fail, JRubyCallSite site, String name2, DynamicMethod method2) {
        if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
            LOG.info(name2 + "\tbound to inline cache failed " + InvocationLinker.logMethod(method2), new Object[0]);
        }
        MethodHandle myFail = MethodHandles.insertArguments(fail, 0, site);
        myFail = InvocationLinker.postProcess(site, myFail);
        return myFail;
    }

    private static MethodHandle createGWT(MethodHandle test2, MethodHandle target, MethodHandle fallback, CacheEntry entry, JRubyCallSite site, boolean curryFallback) {
        MethodHandle myFallback = curryFallback ? MethodHandles.insertArguments(fallback, 0, site) : fallback;
        MethodHandle guardWithTest = MethodHandles.guardWithTest(test2, target, myFallback);
        return guardWithTest;
    }

    private static MethodHandle tryDispatchDirect(JRubyCallSite site, String name2, RubyClass cls, DynamicMethod method2) {
        org.jruby.internal.runtime.methods.DefaultMethod defaultMethod;
        while (method2 instanceof AliasMethod) {
            name2 = ((AliasMethod)method2).getOldName();
            method2 = method2.getRealMethod();
        }
        while (method2 instanceof WrapperMethod) {
            method2 = method2.getRealMethod();
        }
        if (method2 instanceof ProfilingDynamicMethod) {
            throw new IndirectBindingException("profiling active");
        }
        if (method2 instanceof org.jruby.internal.runtime.methods.DefaultMethod && (defaultMethod = (org.jruby.internal.runtime.methods.DefaultMethod)method2).getMethodForCaching() instanceof JittedMethod) {
            method2 = defaultMethod.getMethodForCaching();
        }
        DynamicMethod.NativeCall nativeCall = method2.getNativeCall();
        int siteArgCount = InvocationLinker.getSiteCount(site.type().parameterArray());
        if (method2 instanceof AttrReaderMethod) {
            if (!RubyInstanceConfig.INVOKEDYNAMIC_ATTR) {
                throw new IndirectBindingException("direct attribute dispatch not enabled");
            }
            if (siteArgCount != 0) {
                throw new IndirectBindingException("attr reader with > 0 args");
            }
        } else if (method2 instanceof AttrWriterMethod) {
            if (!RubyInstanceConfig.INVOKEDYNAMIC_ATTR) {
                throw new IndirectBindingException("direct attribute dispatch not enabled");
            }
            if (siteArgCount != 1) {
                throw new IndirectBindingException("attr writer with > 1 args");
            }
        } else if (method2 instanceof DefaultMethod || method2 instanceof JITNativeInvoker) {
            if (method2.getCallConfig() != CallConfiguration.FrameNoneScopeNone) {
                throw new IndirectBindingException("frame or scope required: " + (Object)((Object)method2.getCallConfig()));
            }
            if (!method2.getArity().isFixed()) {
                throw new IndirectBindingException("fixed arity required: " + method2.getArity());
            }
            if (method2.getArity().getValue() != siteArgCount) {
                throw new IndirectBindingException("arity mismatch");
            }
            if (method2.getArity().getValue() > 6) {
                throw new IndirectBindingException("target args > 6");
            }
            if (site.type().parameterType(site.type().parameterCount() - 1) == Block.class) {
                throw new IndirectBindingException("callback block supplied");
            }
        } else if (nativeCall != null) {
            if (nativeCall.isJava()) {
                if (!RubyInstanceConfig.INVOKEDYNAMIC_JAVA) {
                    throw new IndirectBindingException("direct Java dispatch not enabled");
                }
                if (nativeCall.getNativeSignature().length != siteArgCount || siteArgCount > 3 || site.isIterator() || !cls.getJavaProxy()) {
                    throw new IndirectBindingException("Java call arity mismatch or > 3 args");
                }
            } else {
                int nativeArgCount;
                int n = nativeArgCount = method2 instanceof CompiledMethod || method2 instanceof JittedMethod ? InvocationLinker.getRubyArgCount(nativeCall.getNativeSignature()) : InvocationLinker.getArgCount(nativeCall.getNativeSignature(), nativeCall.isStatic());
                if (nativeArgCount != siteArgCount) {
                    throw new IndirectBindingException("arity mismatch or varargs at call site: " + nativeArgCount + " != " + siteArgCount);
                }
            }
        } else {
            throw new IndirectBindingException("no direct path available for " + method2.getClass().getName());
        }
        return InvocationLinker.handleForMethod(site, name2, cls, method2);
    }

    private static MethodHandle getTarget(JRubyCallSite site, RubyClass cls, String name2, CacheEntry entry, int arity2) {
        try {
            return InvocationLinker.tryDispatchDirect(site, name2, cls, entry.method);
        }
        catch (IndirectBindingException _ibe) {
            IndirectBindingException ibe = _ibe;
            if (!RubyInstanceConfig.INVOKEDYNAMIC_INDIRECT) {
                if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
                    LOG.info(name2 + "\tfailed to bind to " + InvocationLinker.logMethod(entry.method) + ": " + ibe.getMessage(), new Object[0]);
                }
                return null;
            }
            if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
                LOG.info(name2 + "\tbound indirectly to " + InvocationLinker.logMethod(entry.method) + ": " + ibe.getMessage(), new Object[0]);
            }
            MethodHandle dynMethodTarget = InvocationLinker.getDynamicMethodTarget(site.type(), arity2, entry.method);
            dynMethodTarget = MethodHandles.insertArguments(dynMethodTarget, 4, name2);
            dynMethodTarget = MethodHandles.insertArguments(dynMethodTarget, 0, entry);
            return dynMethodTarget;
        }
    }

    private static MethodHandle handleForMethod(JRubyCallSite site, String name2, RubyClass cls, DynamicMethod method2) {
        MethodHandle nativeTarget = null;
        if (method2 instanceof AttrReaderMethod) {
            if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
                LOG.info(name2 + "\tbound as attr reader " + InvocationLinker.logMethod(method2) + ":" + ((AttrReaderMethod)method2).getVariableName(), new Object[0]);
            }
            nativeTarget = InvocationLinker.createAttrReaderHandle(site, cls, method2);
        } else if (method2 instanceof AttrWriterMethod) {
            if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
                LOG.info(name2 + "\tbound as attr writer " + InvocationLinker.logMethod(method2) + ":" + ((AttrWriterMethod)method2).getVariableName(), new Object[0]);
            }
            nativeTarget = InvocationLinker.createAttrWriterHandle(site, cls, method2);
        } else if (method2 instanceof JITNativeInvoker || method2 instanceof DefaultMethod) {
            nativeTarget = InvocationLinker.createFFIHandle(site, method2);
        } else if (method2.getNativeCall() != null) {
            DynamicMethod.NativeCall nativeCall = method2.getNativeCall();
            if (nativeCall.isJava()) {
                if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
                    LOG.info(name2 + "\tbound to Java method " + InvocationLinker.logMethod(method2) + ": " + nativeCall, new Object[0]);
                }
                nativeTarget = InvocationLinker.createJavaHandle(site, method2);
            } else if (method2 instanceof CompiledMethod || method2 instanceof JittedMethod) {
                if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
                    LOG.info(name2 + "\tbound to Ruby method " + InvocationLinker.logMethod(method2) + ": " + nativeCall, new Object[0]);
                }
                nativeTarget = InvocationLinker.createRubyHandle(site, method2, name2);
            } else {
                if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
                    LOG.info(name2 + "\tbound to native method " + InvocationLinker.logMethod(method2) + ": " + nativeCall, new Object[0]);
                }
                nativeTarget = InvocationLinker.createNativeHandle(site, method2, name2);
            }
        }
        if (nativeTarget != null) {
            if (site.type().parameterCount() > 0 && site.type().parameterArray()[site.type().parameterCount() - 1] != Block.class && nativeTarget.type().parameterCount() > 0 && nativeTarget.type().parameterType(nativeTarget.type().parameterCount() - 1) == Block.class) {
                nativeTarget = MethodHandles.insertArguments(nativeTarget, nativeTarget.type().parameterCount() - 1, Block.NULL_BLOCK);
            } else if (site.type().parameterCount() > 0 && site.type().parameterArray()[site.type().parameterCount() - 1] == Block.class && nativeTarget.type().parameterCount() > 0 && nativeTarget.type().parameterType(nativeTarget.type().parameterCount() - 1) != Block.class) {
                nativeTarget = MethodHandles.dropArguments(nativeTarget, nativeTarget.type().parameterCount(), new Class[]{Block.class});
            }
        }
        return nativeTarget;
    }

    public static boolean testGeneration(int token, IRubyObject self) {
        return token == ((RubyBasicObject)self).getMetaClass().getGeneration();
    }

    public static boolean testMetaclass(RubyClass metaclass, IRubyObject self) {
        return metaclass == ((RubyBasicObject)self).getMetaClass();
    }

    public static boolean testRealClass(int id2, IRubyObject self) {
        return id2 == ((RubyBasicObject)self).getMetaClass().getRealClass().id;
    }

    public static boolean testClass(Object object, Class clazz) {
        return object.getClass() == clazz;
    }

    public static IRubyObject getLast(IRubyObject[] args2) {
        return args2[args2.length - 1];
    }

    public static void blockEscape(Block block) {
        block.escape();
    }

    private static MethodHandle postProcess(JRubyCallSite site, MethodHandle target) {
        if (site.isIterator()) {
            MethodHandle breakHandler = MethodHandles.permuteArguments(HANDLE_BREAK_JUMP, site.type().insertParameterTypes(0, JumpException.BreakJump.class), 0, 1);
            target = MethodHandles.catchException(target, JumpException.BreakJump.class, breakHandler);
            target = Binder.from(target.type()).tryFinally(MethodHandles.permuteArguments(BLOCK_ESCAPE, site.type().changeReturnType(Void.TYPE), site.type().parameterCount() - 1)).invoke(target);
        }
        if (site.isAttrAssign() && site.isExpression()) {
            MethodHandle newTarget = MethodHandles.identity(IRubyObject.class);
            if (site.type().parameterArray()[site.type().parameterCount() - 1] == IRubyObject[].class) {
                newTarget = MethodHandles.filterArguments(newTarget, 0, InvokeDynamicSupport.findStatic(InvocationLinker.class, "getLast", MethodType.methodType(IRubyObject.class, IRubyObject[].class)));
            }
            newTarget = MethodHandles.dropArguments(newTarget, 0, IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
            MethodType dropped = target.type().dropParameterTypes(0, 3);
            if (dropped.parameterCount() > 1) {
                Object[] drops = new Class[dropped.parameterCount() - 1];
                Arrays.fill(drops, IRubyObject.class);
                newTarget = MethodHandles.dropArguments(newTarget, 4, drops);
            }
            target = MethodHandles.foldArguments(newTarget, target);
        }
        return target;
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self, selfClass, name2);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2);
        }
        site.entry = entry;
        return entry.method.call(context, self, selfClass, name2);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0);
        }
        site.entry = entry;
        return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, IRubyObject arg1) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1);
        }
        site.entry = entry;
        return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1, arg2);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1, arg2);
        }
        site.entry = entry;
        return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1, arg2);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject[] args2) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self, (RubyModule)selfClass, name2, args2);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, args2);
        }
        site.entry = entry;
        return entry.method.call(context, self, (RubyModule)selfClass, name2, args2);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self, (RubyModule)selfClass, name2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, block);
        }
        site.entry = entry;
        return entry.method.call(context, self, (RubyModule)selfClass, name2, block);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, block);
        }
        site.entry = entry;
        return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, block);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1, block);
        }
        site.entry = entry;
        return entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1, block);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self, selfClass, name2, arg0, arg1, arg2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1, arg2, block);
        }
        site.entry = entry;
        return entry.method.call(context, self, selfClass, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self, (RubyModule)selfClass, name2, args2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, args2, block);
        }
        site.entry = entry;
        return entry.method.call(context, self, (RubyModule)selfClass, name2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject failIter(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        try {
            if (entry.typeOk(selfClass)) {
                IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, block);
                return iRubyObject;
            }
            entry = selfClass.searchWithCache(name2);
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, block);
                return iRubyObject;
            }
            site.entry = entry;
            IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject failIter(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        try {
            if (entry.typeOk(selfClass)) {
                IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, block);
                return iRubyObject;
            }
            entry = selfClass.searchWithCache(name2);
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, block);
                return iRubyObject;
            }
            site.entry = entry;
            IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject failIter(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, IRubyObject arg1, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        try {
            if (entry.typeOk(selfClass)) {
                IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1, block);
                return iRubyObject;
            }
            entry = selfClass.searchWithCache(name2);
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1, block);
                return iRubyObject;
            }
            site.entry = entry;
            IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, arg0, arg1, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject failIter(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        try {
            if (entry.typeOk(selfClass)) {
                IRubyObject iRubyObject = entry.method.call(context, self, selfClass, name2, arg0, arg1, arg2, block);
                return iRubyObject;
            }
            entry = selfClass.searchWithCache(name2);
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, arg0, arg1, arg2, block);
                return iRubyObject;
            }
            site.entry = entry;
            IRubyObject iRubyObject = entry.method.call(context, self, selfClass, name2, arg0, arg1, arg2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject failIter(JRubyCallSite site, ThreadContext context, IRubyObject caller2, IRubyObject self, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        try {
            if (entry.typeOk(selfClass)) {
                IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, args2, block);
                return iRubyObject;
            }
            entry = selfClass.searchWithCache(name2);
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller2)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self, name2, args2, block);
                return iRubyObject;
            }
            site.entry = entry;
            IRubyObject iRubyObject = entry.method.call(context, self, (RubyModule)selfClass, name2, args2, block);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.handleBreakJump(context, bj);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            IRubyObject iRubyObject = InvokeDynamicSupport.retryJumpError(context);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    private static MethodHandle getDynamicMethodTarget(MethodType callType, int arity2, DynamicMethod method2) {
        MethodHandle target = null;
        TypeDescriptor.OfField lastParam = callType.parameterType(callType.parameterCount() - 1);
        boolean block = lastParam == Block.class;
        switch (arity2) {
            case 0: {
                target = block ? TARGET_0_B : TARGET_0;
                break;
            }
            case 1: {
                target = block ? TARGET_1_B : TARGET_1;
                break;
            }
            case 2: {
                target = block ? TARGET_2_B : TARGET_2;
                break;
            }
            case 3: {
                target = block ? TARGET_3_B : TARGET_3;
                break;
            }
            default: {
                target = block ? TARGET_N_B : TARGET_N;
            }
        }
        return target;
    }

    private static MethodHandle createJavaHandle(CallSite site, DynamicMethod method2) {
        MethodHandle nativeTarget = (MethodHandle)method2.getHandle();
        if (nativeTarget != null) {
            return nativeTarget;
        }
        MethodHandle returnFilter = null;
        Ruby runtime = method2.getImplementationClass().getRuntime();
        DynamicMethod.NativeCall nativeCall = method2.getNativeCall();
        boolean isStatic = nativeCall.isStatic();
        Class[] signature = nativeCall.getNativeSignature();
        if (signature.length > 0 && signature[signature.length - 1].isArray()) {
            return null;
        }
        if (method2 instanceof SingletonMethodInvoker) {
            return null;
        }
        MethodType apparentType = MethodType.methodType(nativeCall.getNativeReturn(), nativeCall.getNativeSignature());
        nativeTarget = isStatic ? InvokeDynamicSupport.findStatic(nativeCall.getNativeTarget(), nativeCall.getNativeName(), apparentType) : InvokeDynamicSupport.findVirtual(nativeCall.getNativeTarget(), nativeCall.getNativeName(), apparentType);
        MethodType nativeType = nativeTarget.type();
        Class<?>[] nativeParams = nativeType.parameterArray();
        TypeDescriptor.OfField nativeReturn = nativeType.returnType();
        MethodHandle[] argConverters = new MethodHandle[nativeType.parameterCount()];
        for (int i2 = 0; i2 < argConverters.length; ++i2) {
            MethodHandle converter = !isStatic && i2 == 0 ? Binder.from(nativeParams[0], IRubyObject.class, new Class[0]).cast(Object.class, IRubyObject.class).invokeStaticQuiet(MethodHandles.lookup(), JavaUtil.class, "objectFromJavaProxy") : Binder.from(nativeParams[i2], IRubyObject.class, new Class[0]).insert(1, nativeParams[i2]).cast(Object.class, IRubyObject.class, Class.class).invokeVirtualQuiet(MethodHandles.lookup(), "toJava");
            argConverters[i2] = converter;
        }
        nativeTarget = MethodHandles.filterArguments(nativeTarget, 0, argConverters);
        Class[] convertedParams = CodegenUtils.params(IRubyObject.class, nativeTarget.type().parameterCount());
        if (nativeReturn == Byte.TYPE || nativeReturn == Short.TYPE || nativeReturn == Character.TYPE || nativeReturn == Integer.TYPE || nativeReturn == Long.TYPE) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Long.TYPE, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyFixnum.class, "newFixnum", MethodType.methodType(RubyFixnum.class, Ruby.class, Long.TYPE)), 0, runtime);
        } else if (nativeReturn == Byte.class || nativeReturn == Short.class || nativeReturn == Character.class || nativeReturn == Integer.class || nativeReturn == Long.class) {
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(InvocationLinker.class, "fixnumOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, new Class[]{nativeReturn})), 0, runtime);
        } else if (nativeReturn == Float.TYPE || nativeReturn == Double.TYPE) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Double.TYPE, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyFloat.class, "newFloat", MethodType.methodType(RubyFloat.class, Ruby.class, Double.TYPE)), 0, runtime);
        } else if (nativeReturn == Float.class || nativeReturn == Double.class) {
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(InvocationLinker.class, "floatOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, new Class[]{nativeReturn})), 0, runtime);
        } else if (nativeReturn == Boolean.TYPE) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Boolean.TYPE, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyBoolean.class, "newBoolean", MethodType.methodType(RubyBoolean.class, Ruby.class, Boolean.TYPE)), 0, runtime);
        } else if (nativeReturn == Boolean.class) {
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(InvocationLinker.class, "booleanOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, Boolean.class)), 0, runtime);
        } else if (CharSequence.class.isAssignableFrom((Class<?>)nativeReturn)) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(CharSequence.class, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(InvocationLinker.class, "stringOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, CharSequence.class)), 0, runtime);
        } else if (nativeReturn == Void.TYPE) {
            returnFilter = MethodHandles.constant(IRubyObject.class, runtime.getNil());
        } else if (nativeReturn != ByteList.class && nativeReturn != BigInteger.class) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Object.class, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(JavaUtil.class, "convertJavaToUsableRubyObject", MethodType.methodType(IRubyObject.class, Ruby.class, Object.class)), 0, runtime);
        }
        if (returnFilter != null) {
            Class[] newNativeParams = nativeTarget.type().parameterArray();
            TypeDescriptor.OfField newNativeReturn = nativeTarget.type().returnType();
            Binder exBinder = Binder.from((Class)newNativeReturn, Throwable.class, newNativeParams).drop(1, newNativeParams.length).insert(0, runtime);
            if (nativeReturn != Void.TYPE) {
                exBinder = exBinder.filterReturn(Binder.from((Class)newNativeReturn).constant(InvocationLinker.nullValue((Class)newNativeReturn)));
            }
            nativeTarget = Binder.from(site.type()).drop(0, isStatic ? 3 : 2).filterReturn(returnFilter).invoke(nativeTarget);
            method2.setHandle(nativeTarget);
            return nativeTarget;
        }
        return null;
    }

    public static boolean subclassProxyTest(Object target) {
        return target instanceof InternalJavaProxy;
    }

    private static Object nullValue(Class type2) {
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            return false;
        }
        if (type2 == Byte.TYPE || type2 == Byte.class) {
            return (byte)0;
        }
        if (type2 == Short.TYPE || type2 == Short.class) {
            return (short)0;
        }
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            return 0;
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            return 0L;
        }
        if (type2 == Float.TYPE || type2 == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            return 0.0;
        }
        return null;
    }

    public static IRubyObject fixnumOrNil(Ruby runtime, Byte b) {
        return b == null ? runtime.getNil() : RubyFixnum.newFixnum(runtime, b.byteValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime, Short s2) {
        return s2 == null ? runtime.getNil() : RubyFixnum.newFixnum(runtime, s2.shortValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime, Character c) {
        return c == null ? runtime.getNil() : RubyFixnum.newFixnum(runtime, c.charValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime, Integer i2) {
        return i2 == null ? runtime.getNil() : RubyFixnum.newFixnum(runtime, i2.intValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime, Long l) {
        return l == null ? runtime.getNil() : RubyFixnum.newFixnum(runtime, l);
    }

    public static IRubyObject floatOrNil(Ruby runtime, Float f) {
        return f == null ? runtime.getNil() : RubyFloat.newFloat(runtime, f.floatValue());
    }

    public static IRubyObject floatOrNil(Ruby runtime, Double d) {
        return d == null ? runtime.getNil() : RubyFloat.newFloat(runtime, d);
    }

    public static IRubyObject booleanOrNil(Ruby runtime, Boolean b) {
        return b == null ? runtime.getNil() : RubyBoolean.newBoolean(runtime, b);
    }

    public static IRubyObject stringOrNil(Ruby runtime, CharSequence cs) {
        return cs == null ? runtime.getNil() : RubyString.newUnicodeString(runtime, cs);
    }

    private static MethodHandle createNativeHandle(JRubyCallSite site, DynamicMethod method2, String name2) {
        int[] permute;
        MethodType convert2;
        MethodHandle nativeTarget = (MethodHandle)method2.getHandle();
        if (nativeTarget != null) {
            return nativeTarget;
        }
        DynamicMethod.NativeCall nativeCall = method2.getNativeCall();
        Class[] nativeSig = nativeCall.getNativeSignature();
        boolean isStatic = nativeCall.isStatic();
        try {
            nativeTarget = isStatic ? site.lookup().findStatic(nativeCall.getNativeTarget(), nativeCall.getNativeName(), MethodType.methodType(nativeCall.getNativeReturn(), nativeCall.getNativeSignature())) : site.lookup().findVirtual(nativeCall.getNativeTarget(), nativeCall.getNativeName(), MethodType.methodType(nativeCall.getNativeReturn(), nativeCall.getNativeSignature()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int argCount = InvocationLinker.getArgCount(nativeCall.getNativeSignature(), isStatic);
        MethodType inboundType = STANDARD_NATIVE_TYPES_BLOCK[argCount];
        if (nativeSig.length > 0 && nativeSig[0] == ThreadContext.class) {
            if (nativeSig[nativeSig.length - 1] == Block.class) {
                convert2 = isStatic ? TARGET_TC_SELF_ARGS_BLOCK[argCount] : TARGET_SELF_TC_ARGS_BLOCK[argCount];
                permute = isStatic ? TC_SELF_ARGS_BLOCK_PERMUTES[argCount] : SELF_TC_ARGS_BLOCK_PERMUTES[argCount];
            } else {
                convert2 = isStatic ? TARGET_TC_SELF_ARGS[argCount] : TARGET_SELF_TC_ARGS[argCount];
                permute = isStatic ? TC_SELF_ARGS_PERMUTES[argCount] : SELF_TC_ARGS_PERMUTES[argCount];
            }
        } else if (nativeSig.length > 0 && nativeSig[nativeSig.length - 1] == Block.class) {
            convert2 = TARGET_SELF_ARGS_BLOCK[argCount];
            permute = SELF_ARGS_BLOCK_PERMUTES[argCount];
        } else {
            convert2 = TARGET_SELF_ARGS[argCount];
            permute = SELF_ARGS_PERMUTES[argCount];
        }
        nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, convert2);
        nativeTarget = MethodHandles.permuteArguments(nativeTarget, inboundType, permute);
        nativeTarget = InvocationLinker.wrapWithFraming(method2, name2, nativeTarget, null, argCount);
        method2.setHandle(nativeTarget);
        return nativeTarget;
    }

    private static MethodHandle createFFIHandle(JRubyCallSite site, DynamicMethod method2) {
        if (site.type().parameterType(site.type().parameterCount() - 1) == Block.class) {
            return null;
        }
        MethodHandle nativeTarget = (MethodHandle)method2.getHandle();
        if (nativeTarget != null) {
            return nativeTarget;
        }
        nativeTarget = InvokeDynamic.getMethodHandle(site, method2);
        if (nativeTarget != null) {
            method2.setHandle(nativeTarget);
            return nativeTarget;
        }
        return null;
    }

    private static MethodHandle createAttrReaderHandle(JRubyCallSite site, RubyClass cls, DynamicMethod method2) {
        MethodHandle nativeTarget = (MethodHandle)method2.getHandle();
        if (nativeTarget != null) {
            return nativeTarget;
        }
        AttrReaderMethod attrReader = (AttrReaderMethod)method2;
        String varName = attrReader.getVariableName();
        RubyClass.VariableAccessor accessor = cls.getRealClass().getVariableAccessorForWrite(varName);
        MethodHandle filter = Binder.from(IRubyObject.class, IRubyObject.class, new Class[0]).insert(1, cls.getRuntime().getNil()).cast(IRubyObject.class, IRubyObject.class, IRubyObject.class).invokeStaticQuiet(MethodHandles.lookup(), InvocationLinker.class, "valueOrNil");
        nativeTarget = Binder.from(site.type()).permute(2).filterReturn(filter).insert(1, accessor.getIndex()).cast(Object.class, IRubyObject.class, Integer.TYPE).invokeVirtualQuiet(MethodHandles.lookup(), "getVariable");
        return nativeTarget;
    }

    public static IRubyObject valueOrNil(IRubyObject value2, IRubyObject nil) {
        return value2 == null ? nil : value2;
    }

    private static MethodHandle createAttrWriterHandle(JRubyCallSite site, RubyClass cls, DynamicMethod method2) {
        MethodHandle nativeTarget = (MethodHandle)method2.getHandle();
        if (nativeTarget != null) {
            return nativeTarget;
        }
        AttrWriterMethod attrWriter = (AttrWriterMethod)method2;
        String varName = attrWriter.getVariableName();
        RubyClass.VariableAccessor accessor = cls.getRealClass().getVariableAccessorForWrite(varName);
        MethodHandle filter = Binder.from(IRubyObject.class, Object.class, new Class[0]).drop(0).constant(cls.getRuntime().getNil());
        nativeTarget = Binder.from(site.type()).permute(2, 3).filterReturn(filter).insert(1, accessor.getIndex()).cast(Void.TYPE, IRubyObject.class, Integer.TYPE, Object.class).invokeVirtualQuiet(MethodHandles.lookup(), "setVariable");
        return nativeTarget;
    }

    private static MethodHandle createRubyHandle(JRubyCallSite site, DynamicMethod method2, String name2) {
        MethodHandle nativeTarget = (MethodHandle)method2.getHandle();
        if (nativeTarget != null) {
            return nativeTarget;
        }
        DynamicMethod.NativeCall nativeCall = method2.getNativeCall();
        try {
            Object scriptObject;
            StaticScope scope = null;
            if (method2 instanceof CompiledMethod) {
                scriptObject = ((CompiledMethod)method2).getScriptObject();
                scope = ((CompiledMethod)method2).getStaticScope();
            } else if (method2 instanceof JittedMethod) {
                scriptObject = ((JittedMethod)method2).getScriptObject();
                scope = ((JittedMethod)method2).getStaticScope();
            } else {
                throw new RuntimeException("invalid method for ruby handle: " + method2);
            }
            int argCount = InvocationLinker.getRubyArgCount(nativeCall.getNativeSignature());
            nativeTarget = Binder.from(STANDARD_NATIVE_TYPES_BLOCK[Math.abs(argCount)]).permute(TC_SELF_ARGS_BLOCK_PERMUTES[Math.abs(argCount)]).insert(0, scriptObject).invokeStaticQuiet(site.lookup(), nativeCall.getNativeTarget(), nativeCall.getNativeName());
            nativeTarget = InvocationLinker.wrapWithFraming(method2, name2, nativeTarget, scope, argCount);
            method2.setHandle(nativeTarget);
            return nativeTarget;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static MethodHandle wrapWithFraming(DynamicMethod method2, String name2, MethodHandle nativeTarget, StaticScope scope, int argCount) {
        MethodHandle framePre = InvocationLinker.getFramePre(method2, name2, argCount, scope);
        if (framePre != null) {
            boolean framed;
            MethodHandle framePost = InvocationLinker.getFramePost(method2, argCount);
            CallConfiguration callConfig = method2.getCallConfig();
            boolean heapScoped = callConfig.scoping() != Scoping.None;
            boolean bl = framed = callConfig.framing() != Framing.None;
            if (framed || heapScoped) {
                nativeTarget = MethodHandles.catchException(nativeTarget, JumpException.ReturnJump.class, Binder.from(nativeTarget.type().insertParameterTypes(0, JumpException.ReturnJump.class)).permute(0, 1).invokeStaticQuiet(MethodHandles.lookup(), InvocationLinker.class, "handleReturn"));
            }
            if (framed) {
                nativeTarget = MethodHandles.catchException(nativeTarget, JumpException.RedoJump.class, Binder.from(nativeTarget.type().insertParameterTypes(0, JumpException.RedoJump.class)).permute(0, 1).invokeStaticQuiet(MethodHandles.lookup(), InvocationLinker.class, "handleRedo"));
            }
            nativeTarget = Binder.from(nativeTarget.type()).tryFinally(framePost).invoke(nativeTarget);
            nativeTarget = MethodHandles.foldArguments(nativeTarget, framePre);
            nativeTarget = Binder.from(nativeTarget.type()).fold(Binder.from(nativeTarget.type().changeReturnType(Void.TYPE)).permute(0).invokeStaticQuiet(MethodHandles.lookup(), ThreadContext.class, "callThreadPoll")).invoke(nativeTarget);
        }
        return nativeTarget;
    }

    public static IRubyObject handleReturn(JumpException.ReturnJump rj, ThreadContext context) {
        if (rj.getTarget() == context.getFrameJumpTarget()) {
            return (IRubyObject)rj.getValue();
        }
        throw rj;
    }

    public static IRubyObject handleRedo(JumpException.RedoJump rj, ThreadContext context) {
        throw context.runtime.newLocalJumpError(RubyLocalJumpError.Reason.REDO, context.runtime.getNil(), "unexpected redo");
    }

    private static MethodHandle getFramePre(DynamicMethod method2, String name2, int argCount, StaticScope scope) {
        MethodHandle framePre = null;
        switch (method2.getCallConfig()) {
            case FrameFullScopeFull: {
                framePre = Binder.from(STANDARD_NATIVE_TYPES_BLOCK[Math.abs(argCount)].changeReturnType(Void.TYPE)).permute(TC_SELF_BLOCK_PERMUTES[Math.abs(argCount)]).insert(1, new Class[]{RubyModule.class, String.class}, new Object[]{method2.getImplementationClass(), name2}).insert(5, new Class[]{StaticScope.class}, new Object[]{scope}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodFrameAndScope");
                break;
            }
            case FrameFullScopeDummy: {
                framePre = Binder.from(STANDARD_NATIVE_TYPES_BLOCK[Math.abs(argCount)].changeReturnType(Void.TYPE)).permute(TC_SELF_BLOCK_PERMUTES[Math.abs(argCount)]).insert(1, new Class[]{RubyModule.class, String.class}, new Object[]{method2.getImplementationClass(), name2}).insert(5, new Class[]{StaticScope.class}, new Object[]{scope}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodFrameAndDummyScope");
                break;
            }
            case FrameFullScopeNone: {
                framePre = Binder.from(STANDARD_NATIVE_TYPES_BLOCK[Math.abs(argCount)].changeReturnType(Void.TYPE)).permute(TC_SELF_BLOCK_PERMUTES[Math.abs(argCount)]).insert(1, new Class[]{RubyModule.class, String.class}, new Object[]{method2.getImplementationClass(), name2}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodFrameOnly");
                break;
            }
            case FrameNoneScopeFull: {
                framePre = Binder.from(STANDARD_NATIVE_TYPES_BLOCK[Math.abs(argCount)].changeReturnType(Void.TYPE)).permute(0).insert(1, new Class[]{RubyModule.class, StaticScope.class}, new Object[]{method2.getImplementationClass(), scope}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodScopeOnly");
                break;
            }
            case FrameNoneScopeDummy: {
                framePre = Binder.from(STANDARD_NATIVE_TYPES_BLOCK[Math.abs(argCount)].changeReturnType(Void.TYPE)).permute(0).insert(1, new Class[]{RubyModule.class, StaticScope.class}, new Object[]{method2.getImplementationClass(), scope}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodNoFrameAndDummyScope");
            }
        }
        return framePre;
    }

    private static MethodHandle getFramePost(DynamicMethod method2, int argCount) {
        switch (method2.getCallConfig()) {
            case FrameFullScopeFull: {
                return Binder.from(STANDARD_NATIVE_TYPES_BLOCK[Math.abs(argCount)].changeReturnType(Void.TYPE)).permute(0).invokeVirtualQuiet(MethodHandles.lookup(), "postMethodFrameAndScope");
            }
            case FrameFullScopeDummy: {
                return Binder.from(STANDARD_NATIVE_TYPES_BLOCK[Math.abs(argCount)].changeReturnType(Void.TYPE)).permute(0).invokeVirtualQuiet(MethodHandles.lookup(), "postMethodFrameAndScope");
            }
            case FrameFullScopeNone: {
                return Binder.from(STANDARD_NATIVE_TYPES_BLOCK[Math.abs(argCount)].changeReturnType(Void.TYPE)).permute(0).invokeVirtualQuiet(MethodHandles.lookup(), "postMethodFrameOnly");
            }
            case FrameNoneScopeFull: {
                return Binder.from(STANDARD_NATIVE_TYPES_BLOCK[Math.abs(argCount)].changeReturnType(Void.TYPE)).permute(0).invokeVirtualQuiet(MethodHandles.lookup(), "postMethodScopeOnly");
            }
            case FrameNoneScopeDummy: {
                return Binder.from(STANDARD_NATIVE_TYPES_BLOCK[Math.abs(argCount)].changeReturnType(Void.TYPE)).permute(0).invokeVirtualQuiet(MethodHandles.lookup(), "postMethodScopeOnly");
            }
        }
        return null;
    }

    private static int getArgCount(Class[] args2, boolean isStatic) {
        int length2 = args2.length;
        boolean hasContext = false;
        if (isStatic) {
            if (args2.length > 1 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            assert (args2.length >= 1);
            --length2;
            if (args2.length > 1 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[2] == IRubyObject[].class) {
                    length2 = 4;
                } else if (args2[1] == IRubyObject[].class) {
                    length2 = 4;
                }
            }
        } else {
            if (args2.length > 0 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            if (args2.length > 0 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[1] == IRubyObject[].class) {
                    length2 = 4;
                } else if (args2[0] == IRubyObject[].class) {
                    length2 = 4;
                }
            }
        }
        return length2;
    }

    private static int getRubyArgCount(Class[] args2) {
        int length2 = args2.length;
        boolean hasContext = false;
        --length2;
        if (args2.length > 2 && args2[1] == ThreadContext.class) {
            --length2;
            hasContext = true;
        }
        assert (args2.length >= 2);
        --length2;
        if (args2.length > 2 && args2[args2.length - 1] == Block.class) {
            --length2;
        }
        if (length2 == 1) {
            if (hasContext && args2[3] == IRubyObject[].class) {
                length2 = 4;
            } else if (args2[2] == IRubyObject[].class) {
                length2 = 4;
            }
        }
        return length2;
    }

    private static int getSiteCount(Class[] args2) {
        if (args2[args2.length - 1] == Block.class) {
            if (args2[args2.length - 2] == IRubyObject[].class) {
                return 4;
            }
            return args2.length - 4;
        }
        if (args2[args2.length - 1] == IRubyObject[].class) {
            return 4;
        }
        return args2.length - 3;
    }

    private static String logMethod(DynamicMethod method2) {
        return "[#" + method2.getSerialNumber() + " " + method2.getImplementationClass() + "]";
    }

    public static DynamicMethod getMethod(CacheEntry entry) {
        return entry.method;
    }

    private static MethodHandle dropNameAndArgs(MethodHandle original, int index2, int count2, boolean block) {
        switch (count2) {
            case -1: {
                if (block) {
                    return MethodHandles.dropArguments(original, index2, String.class, IRubyObject[].class, Block.class);
                }
                return MethodHandles.dropArguments(original, index2, new Class[]{String.class, IRubyObject[].class});
            }
            case 0: {
                if (block) {
                    return MethodHandles.dropArguments(original, index2, new Class[]{String.class, Block.class});
                }
                return MethodHandles.dropArguments(original, index2, new Class[]{String.class});
            }
            case 1: {
                if (block) {
                    return MethodHandles.dropArguments(original, index2, String.class, IRubyObject.class, Block.class);
                }
                return MethodHandles.dropArguments(original, index2, new Class[]{String.class, IRubyObject.class});
            }
            case 2: {
                if (block) {
                    return MethodHandles.dropArguments(original, index2, String.class, IRubyObject.class, IRubyObject.class, Block.class);
                }
                return MethodHandles.dropArguments(original, index2, String.class, IRubyObject.class, IRubyObject.class);
            }
            case 3: {
                if (block) {
                    return MethodHandles.dropArguments(original, index2, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class);
                }
                return MethodHandles.dropArguments(original, index2, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class);
            }
        }
        throw new RuntimeException("Invalid arg count (" + count2 + ") while preparing method handle:\n\t" + original);
    }

    private static MethodHandle dropArgs(MethodHandle original, int index2, int count2, boolean block) {
        switch (count2) {
            case -1: {
                if (block) {
                    return MethodHandles.dropArguments(original, index2, new Class[]{IRubyObject[].class, Block.class});
                }
                return MethodHandles.dropArguments(original, index2, new Class[]{IRubyObject[].class});
            }
            case 0: {
                if (block) {
                    return MethodHandles.dropArguments(original, index2, new Class[]{Block.class});
                }
                return MethodHandles.dropArguments(original, index2, new Class[0]);
            }
            case 1: {
                if (block) {
                    return MethodHandles.dropArguments(original, index2, new Class[]{IRubyObject.class, Block.class});
                }
                return MethodHandles.dropArguments(original, index2, new Class[]{IRubyObject.class});
            }
            case 2: {
                if (block) {
                    return MethodHandles.dropArguments(original, index2, IRubyObject.class, IRubyObject.class, Block.class);
                }
                return MethodHandles.dropArguments(original, index2, new Class[]{IRubyObject.class, IRubyObject.class});
            }
            case 3: {
                if (block) {
                    return MethodHandles.dropArguments(original, index2, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class);
                }
                return MethodHandles.dropArguments(original, index2, IRubyObject.class, IRubyObject.class, IRubyObject.class);
            }
        }
        throw new RuntimeException("Invalid arg count (" + count2 + ") while preparing method handle:\n\t" + original);
    }

    static {
        MethodHandle getMethod = InvokeDynamicSupport.findStatic(InvocationLinker.class, "getMethod", MethodType.methodType(DynamicMethod.class, CacheEntry.class));
        getMethod = MethodHandles.dropArguments(getMethod, 0, new Class[]{RubyClass.class});
        GETMETHOD = getMethod = MethodHandles.dropArguments(getMethod, 2, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        PGC = Binder.from(RubyClass.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class).permute(1, 3).invokeStaticQuiet(MethodHandles.lookup(), InvokeDynamicSupport.class, "pollAndGetClass");
        TEST_GENERATION = Binder.from(Boolean.TYPE, Integer.TYPE, IRubyObject.class).invokeStaticQuiet(MethodHandles.lookup(), InvocationLinker.class, "testGeneration");
        TEST_METACLASS = Binder.from(Boolean.TYPE, RubyClass.class, IRubyObject.class).invokeStaticQuiet(MethodHandles.lookup(), InvocationLinker.class, "testMetaclass");
        TEST = RubyInstanceConfig.INVOKEDYNAMIC_INVOCATION_SWITCHPOINT ? TEST_METACLASS : TEST_GENERATION;
        TEST_CLASS = Binder.from(Boolean.TYPE, Object.class, Class.class).invokeStaticQuiet(MethodHandles.lookup(), InvocationLinker.class, "testClass");
        TARGET_0 = Binder.from(IRubyObject.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class).fold(InvocationLinker.dropNameAndArgs(PGC, 4, 0, false)).fold(InvocationLinker.dropNameAndArgs(GETMETHOD, 5, 0, false)).permute(0, 3, 5, 1, 6).cast(IRubyObject.class, DynamicMethod.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class).invokeVirtualQuiet(MethodHandles.lookup(), "call");
        FALLBACK_0 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
        FAIL_0 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
        TARGET_1 = Binder.from(IRubyObject.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class).fold(InvocationLinker.dropNameAndArgs(PGC, 4, 1, false)).fold(InvocationLinker.dropNameAndArgs(GETMETHOD, 5, 1, false)).permute(0, 3, 5, 1, 6, 7).cast(IRubyObject.class, DynamicMethod.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class).invokeVirtualQuiet(MethodHandles.lookup(), "call");
        FALLBACK_1 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
        FAIL_1 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
        TARGET_2 = Binder.from(IRubyObject.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class).fold(InvocationLinker.dropNameAndArgs(PGC, 4, 2, false)).fold(InvocationLinker.dropNameAndArgs(GETMETHOD, 5, 2, false)).permute(0, 3, 5, 1, 6, 7, 8).cast(IRubyObject.class, DynamicMethod.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class).invokeVirtualQuiet(MethodHandles.lookup(), "call");
        FALLBACK_2 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
        FAIL_2 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
        TARGET_3 = Binder.from(IRubyObject.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class).fold(InvocationLinker.dropNameAndArgs(PGC, 4, 3, false)).fold(InvocationLinker.dropNameAndArgs(GETMETHOD, 5, 3, false)).permute(0, 3, 5, 1, 6, 7, 8, 9).cast(IRubyObject.class, DynamicMethod.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class).invokeVirtualQuiet(MethodHandles.lookup(), "call");
        FALLBACK_3 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
        FAIL_3 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
        TARGET_N = Binder.from(IRubyObject.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject[].class).fold(InvocationLinker.dropNameAndArgs(PGC, 4, -1, false)).fold(InvocationLinker.dropNameAndArgs(GETMETHOD, 5, -1, false)).permute(0, 3, 5, 1, 6, 7).cast(IRubyObject.class, DynamicMethod.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class).invokeVirtualQuiet(MethodHandles.lookup(), "call");
        FALLBACK_N = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
        FAIL_N = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
        TARGET_0_B = Binder.from(IRubyObject.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, Block.class).fold(InvocationLinker.dropNameAndArgs(PGC, 4, 0, true)).fold(InvocationLinker.dropNameAndArgs(GETMETHOD, 5, 0, true)).permute(0, 3, 5, 1, 6, 7).cast(IRubyObject.class, DynamicMethod.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, Block.class).invokeVirtualQuiet(MethodHandles.lookup(), "call");
        FALLBACK_0_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class));
        FAIL_0_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class));
        TARGET_1_B = Binder.from(IRubyObject.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, Block.class).fold(InvocationLinker.dropNameAndArgs(PGC, 4, 1, true)).fold(InvocationLinker.dropNameAndArgs(GETMETHOD, 5, 1, true)).permute(0, 3, 5, 1, 6, 7, 8).cast(IRubyObject.class, DynamicMethod.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, Block.class).invokeVirtualQuiet(MethodHandles.lookup(), "call");
        FALLBACK_1_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
        FAIL_1_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
        TARGET_2_B = Binder.from(IRubyObject.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, Block.class).fold(InvocationLinker.dropNameAndArgs(PGC, 4, 2, true)).fold(InvocationLinker.dropNameAndArgs(GETMETHOD, 5, 2, true)).permute(0, 3, 5, 1, 6, 7, 8, 9).cast(IRubyObject.class, DynamicMethod.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, Block.class).invokeVirtualQuiet(MethodHandles.lookup(), "call");
        FALLBACK_2_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
        FAIL_2_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
        TARGET_3_B = Binder.from(IRubyObject.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class).fold(InvocationLinker.dropNameAndArgs(PGC, 4, 3, true)).fold(InvocationLinker.dropNameAndArgs(GETMETHOD, 5, 3, true)).permute(0, 3, 5, 1, 6, 7, 8, 9, 10).cast(IRubyObject.class, DynamicMethod.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class).invokeVirtualQuiet(MethodHandles.lookup(), "call");
        FALLBACK_3_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
        FAIL_3_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
        TARGET_N_B = Binder.from(IRubyObject.class, CacheEntry.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject[].class, Block.class).fold(InvocationLinker.dropNameAndArgs(PGC, 4, -1, true)).fold(InvocationLinker.dropNameAndArgs(GETMETHOD, 5, -1, true)).permute(0, 3, 5, 1, 6, 7, 8).cast(IRubyObject.class, DynamicMethod.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class).invokeVirtualQuiet(MethodHandles.lookup(), "call");
        FALLBACK_N_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, Block.class));
        FAIL_N_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", MethodType.methodType(IRubyObject.class, JRubyCallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, Block.class));
        FALLBACKS = new MethodHandle[]{FALLBACK_0, FALLBACK_1, FALLBACK_2, FALLBACK_3, FALLBACK_N};
        FAILS = new MethodHandle[]{FAIL_0, FAIL_1, FAIL_2, FAIL_3, FAIL_N};
        FALLBACKS_B = new MethodHandle[]{FALLBACK_0_B, FALLBACK_1_B, FALLBACK_2_B, FALLBACK_3_B, FALLBACK_N_B};
        FAILS_B = new MethodHandle[]{FAIL_0_B, FAIL_1_B, FAIL_2_B, FAIL_3_B, FAIL_N_B};
        STANDARD_NATIVE_TYPE = MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        STANDARD_NATIVE_TYPE_1ARG = STANDARD_NATIVE_TYPE.appendParameterTypes(IRubyObject.class);
        STANDARD_NATIVE_TYPE_2ARG = STANDARD_NATIVE_TYPE_1ARG.appendParameterTypes(IRubyObject.class);
        STANDARD_NATIVE_TYPE_3ARG = STANDARD_NATIVE_TYPE_2ARG.appendParameterTypes(IRubyObject.class);
        STANDARD_NATIVE_TYPE_NARG = STANDARD_NATIVE_TYPE.appendParameterTypes(IRubyObject[].class);
        STANDARD_NATIVE_TYPES = new MethodType[]{STANDARD_NATIVE_TYPE, STANDARD_NATIVE_TYPE_1ARG, STANDARD_NATIVE_TYPE_2ARG, STANDARD_NATIVE_TYPE_3ARG, STANDARD_NATIVE_TYPE_NARG};
        STANDARD_NATIVE_TYPE_BLOCK = STANDARD_NATIVE_TYPE.appendParameterTypes(Block.class);
        STANDARD_NATIVE_TYPE_1ARG_BLOCK = STANDARD_NATIVE_TYPE_1ARG.appendParameterTypes(Block.class);
        STANDARD_NATIVE_TYPE_2ARG_BLOCK = STANDARD_NATIVE_TYPE_2ARG.appendParameterTypes(Block.class);
        STANDARD_NATIVE_TYPE_3ARG_BLOCK = STANDARD_NATIVE_TYPE_3ARG.appendParameterTypes(Block.class);
        STANDARD_NATIVE_TYPE_NARG_BLOCK = STANDARD_NATIVE_TYPE_NARG.appendParameterTypes(Block.class);
        STANDARD_NATIVE_TYPES_BLOCK = new MethodType[]{STANDARD_NATIVE_TYPE_BLOCK, STANDARD_NATIVE_TYPE_1ARG_BLOCK, STANDARD_NATIVE_TYPE_2ARG_BLOCK, STANDARD_NATIVE_TYPE_3ARG_BLOCK, STANDARD_NATIVE_TYPE_NARG_BLOCK};
        TARGET_SELF = MethodType.methodType(IRubyObject.class, IRubyObject.class);
        TARGET_SELF_1ARG = TARGET_SELF.appendParameterTypes(IRubyObject.class);
        TARGET_SELF_2ARG = TARGET_SELF_1ARG.appendParameterTypes(IRubyObject.class);
        TARGET_SELF_3ARG = TARGET_SELF_2ARG.appendParameterTypes(IRubyObject.class);
        TARGET_SELF_NARG = TARGET_SELF.appendParameterTypes(IRubyObject[].class);
        TARGET_SELF_ARGS = new MethodType[]{TARGET_SELF, TARGET_SELF_1ARG, TARGET_SELF_2ARG, TARGET_SELF_3ARG, TARGET_SELF_NARG};
        TARGET_SELF_BLOCK = TARGET_SELF.appendParameterTypes(Block.class);
        TARGET_SELF_1ARG_BLOCK = TARGET_SELF_1ARG.appendParameterTypes(Block.class);
        TARGET_SELF_2ARG_BLOCK = TARGET_SELF_2ARG.appendParameterTypes(Block.class);
        TARGET_SELF_3ARG_BLOCK = TARGET_SELF_3ARG.appendParameterTypes(Block.class);
        TARGET_SELF_NARG_BLOCK = TARGET_SELF_NARG.appendParameterTypes(Block.class);
        TARGET_SELF_ARGS_BLOCK = new MethodType[]{TARGET_SELF_BLOCK, TARGET_SELF_1ARG_BLOCK, TARGET_SELF_2ARG_BLOCK, TARGET_SELF_3ARG_BLOCK, TARGET_SELF_NARG_BLOCK};
        TARGET_SELF_TC = TARGET_SELF.appendParameterTypes(ThreadContext.class);
        TARGET_SELF_TC_1ARG = TARGET_SELF_TC.appendParameterTypes(IRubyObject.class);
        TARGET_SELF_TC_2ARG = TARGET_SELF_TC_1ARG.appendParameterTypes(IRubyObject.class);
        TARGET_SELF_TC_3ARG = TARGET_SELF_TC_2ARG.appendParameterTypes(IRubyObject.class);
        TARGET_SELF_TC_NARG = TARGET_SELF_TC.appendParameterTypes(IRubyObject[].class);
        TARGET_SELF_TC_ARGS = new MethodType[]{TARGET_SELF_TC, TARGET_SELF_TC_1ARG, TARGET_SELF_TC_2ARG, TARGET_SELF_TC_3ARG, TARGET_SELF_TC_NARG};
        TARGET_SELF_TC_BLOCK = TARGET_SELF_TC.appendParameterTypes(Block.class);
        TARGET_SELF_TC_1ARG_BLOCK = TARGET_SELF_TC_1ARG.appendParameterTypes(Block.class);
        TARGET_SELF_TC_2ARG_BLOCK = TARGET_SELF_TC_2ARG.appendParameterTypes(Block.class);
        TARGET_SELF_TC_3ARG_BLOCK = TARGET_SELF_TC_3ARG.appendParameterTypes(Block.class);
        TARGET_SELF_TC_NARG_BLOCK = TARGET_SELF_TC_NARG.appendParameterTypes(Block.class);
        TARGET_SELF_TC_ARGS_BLOCK = new MethodType[]{TARGET_SELF_TC_BLOCK, TARGET_SELF_TC_1ARG_BLOCK, TARGET_SELF_TC_2ARG_BLOCK, TARGET_SELF_TC_3ARG_BLOCK, TARGET_SELF_TC_NARG_BLOCK};
        TARGET_TC_SELF = MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class);
        TARGET_TC_SELF_1ARG = TARGET_TC_SELF.appendParameterTypes(IRubyObject.class);
        TARGET_TC_SELF_2ARG = TARGET_TC_SELF_1ARG.appendParameterTypes(IRubyObject.class);
        TARGET_TC_SELF_3ARG = TARGET_TC_SELF_2ARG.appendParameterTypes(IRubyObject.class);
        TARGET_TC_SELF_NARG = TARGET_TC_SELF.appendParameterTypes(IRubyObject[].class);
        TARGET_TC_SELF_ARGS = new MethodType[]{TARGET_TC_SELF, TARGET_TC_SELF_1ARG, TARGET_TC_SELF_2ARG, TARGET_TC_SELF_3ARG, TARGET_TC_SELF_NARG};
        TARGET_TC_SELF_BLOCK = TARGET_TC_SELF.appendParameterTypes(Block.class);
        TARGET_TC_SELF_1ARG_BLOCK = TARGET_TC_SELF_1ARG.appendParameterTypes(Block.class);
        TARGET_TC_SELF_2ARG_BLOCK = TARGET_TC_SELF_2ARG.appendParameterTypes(Block.class);
        TARGET_TC_SELF_3ARG_BLOCK = TARGET_TC_SELF_3ARG.appendParameterTypes(Block.class);
        TARGET_TC_SELF_NARG_BLOCK = TARGET_TC_SELF_NARG.appendParameterTypes(Block.class);
        TARGET_TC_SELF_ARGS_BLOCK = new MethodType[]{TARGET_TC_SELF_BLOCK, TARGET_TC_SELF_1ARG_BLOCK, TARGET_TC_SELF_2ARG_BLOCK, TARGET_TC_SELF_3ARG_BLOCK, TARGET_TC_SELF_NARG_BLOCK};
        SELF_TC_PERMUTE = new int[]{2, 0};
        SELF_TC_1ARG_PERMUTE = new int[]{2, 0, 3};
        SELF_TC_2ARG_PERMUTE = new int[]{2, 0, 3, 4};
        SELF_TC_3ARG_PERMUTE = new int[]{2, 0, 3, 4, 5};
        SELF_TC_NARG_PERMUTE = new int[]{2, 0, 3};
        SELF_TC_ARGS_PERMUTES = new int[][]{SELF_TC_PERMUTE, SELF_TC_1ARG_PERMUTE, SELF_TC_2ARG_PERMUTE, SELF_TC_3ARG_PERMUTE, SELF_TC_NARG_PERMUTE};
        SELF_PERMUTE = new int[]{2};
        SELF_1ARG_PERMUTE = new int[]{2, 3};
        SELF_2ARG_PERMUTE = new int[]{2, 3, 4};
        SELF_3ARG_PERMUTE = new int[]{2, 3, 4, 5};
        SELF_NARG_PERMUTE = new int[]{2, 3};
        SELF_ARGS_PERMUTES = new int[][]{SELF_PERMUTE, SELF_1ARG_PERMUTE, SELF_2ARG_PERMUTE, SELF_3ARG_PERMUTE, SELF_NARG_PERMUTE};
        SELF_TC_BLOCK_PERMUTE = new int[]{2, 0, 3};
        SELF_TC_1ARG_BLOCK_PERMUTE = new int[]{2, 0, 3, 4};
        SELF_TC_2ARG_BLOCK_PERMUTE = new int[]{2, 0, 3, 4, 5};
        SELF_TC_3ARG_BLOCK_PERMUTE = new int[]{2, 0, 3, 4, 5, 6};
        SELF_TC_NARG_BLOCK_PERMUTE = new int[]{2, 0, 3, 4};
        SELF_TC_ARGS_BLOCK_PERMUTES = new int[][]{SELF_TC_BLOCK_PERMUTE, SELF_TC_1ARG_BLOCK_PERMUTE, SELF_TC_2ARG_BLOCK_PERMUTE, SELF_TC_3ARG_BLOCK_PERMUTE, SELF_TC_NARG_BLOCK_PERMUTE};
        SELF_BLOCK_PERMUTE = new int[]{2, 3};
        SELF_1ARG_BLOCK_PERMUTE = new int[]{2, 3, 4};
        SELF_2ARG_BLOCK_PERMUTE = new int[]{2, 3, 4, 5};
        SELF_3ARG_BLOCK_PERMUTE = new int[]{2, 3, 4, 5, 6};
        SELF_NARG_BLOCK_PERMUTE = new int[]{2, 3, 4};
        SELF_ARGS_BLOCK_PERMUTES = new int[][]{SELF_BLOCK_PERMUTE, SELF_1ARG_BLOCK_PERMUTE, SELF_2ARG_BLOCK_PERMUTE, SELF_3ARG_BLOCK_PERMUTE, SELF_NARG_BLOCK_PERMUTE};
        TC_SELF_PERMUTE = new int[]{0, 2};
        TC_SELF_1ARG_PERMUTE = new int[]{0, 2, 3};
        TC_SELF_2ARG_PERMUTE = new int[]{0, 2, 3, 4};
        TC_SELF_3ARG_PERMUTE = new int[]{0, 2, 3, 4, 5};
        TC_SELF_NARG_PERMUTE = new int[]{0, 2, 3};
        TC_SELF_ARGS_PERMUTES = new int[][]{TC_SELF_PERMUTE, TC_SELF_1ARG_PERMUTE, TC_SELF_2ARG_PERMUTE, TC_SELF_3ARG_PERMUTE, TC_SELF_NARG_PERMUTE};
        TC_SELF_BLOCK_PERMUTE = new int[]{0, 2, 3};
        TC_SELF_1ARG_BLOCK_PERMUTE = new int[]{0, 2, 3, 4};
        TC_SELF_2ARG_BLOCK_PERMUTE = new int[]{0, 2, 3, 4, 5};
        TC_SELF_3ARG_BLOCK_PERMUTE = new int[]{0, 2, 3, 4, 5, 6};
        TC_SELF_NARG_BLOCK_PERMUTE = new int[]{0, 2, 3, 4};
        TC_SELF_ARGS_BLOCK_PERMUTES = new int[][]{TC_SELF_BLOCK_PERMUTE, TC_SELF_1ARG_BLOCK_PERMUTE, TC_SELF_2ARG_BLOCK_PERMUTE, TC_SELF_3ARG_BLOCK_PERMUTE, TC_SELF_NARG_BLOCK_PERMUTE};
        TC_SELF_BLOCK_PERMUTE_1 = new int[]{0, 2, 4};
        TC_SELF_BLOCK_PERMUTE_2 = new int[]{0, 2, 5};
        TC_SELF_BLOCK_PERMUTE_3 = new int[]{0, 2, 6};
        TC_SELF_BLOCK_PERMUTE_N = new int[]{0, 2, 4};
        TC_SELF_BLOCK_PERMUTES = new int[][]{TC_SELF_BLOCK_PERMUTE, TC_SELF_BLOCK_PERMUTE_1, TC_SELF_BLOCK_PERMUTE_2, TC_SELF_BLOCK_PERMUTE_3, TC_SELF_BLOCK_PERMUTE_N};
    }

    private static class IndirectBindingException
    extends RuntimeException {
        public IndirectBindingException(String reason2) {
            super(reason2);
        }
    }
}

