/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.executors.impl;

import java.lang.reflect.Method;
import java.util.AbstractQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.executors.ExecutorFactory;
import org.apache.servicemix.executors.impl.ExecutorConfig;
import org.apache.servicemix.executors.impl.ExecutorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorFactoryImpl
implements ExecutorFactory {
    private ExecutorConfig defaultConfig = new ExecutorConfig();
    private Map<String, ExecutorConfig> configs = new HashMap<String, ExecutorConfig>();

    @Override
    public Executor createExecutor(String id) {
        ExecutorConfig config = this.getConfig(id);
        return new ExecutorImpl(this.createService(id, config), config.getShutdownDelay());
    }

    protected ExecutorConfig getConfig(String id) {
        ExecutorConfig config = null;
        if (this.configs != null) {
            config = this.configs.get(id);
            while (config == null && id.indexOf(46) > 0) {
                id = id.substring(0, id.lastIndexOf(46));
                config = this.configs.get(id);
            }
        }
        if (config == null) {
            config = this.defaultConfig;
        }
        return config;
    }

    protected ThreadPoolExecutor createService(String id, ExecutorConfig config) {
        if (config.getQueueSize() != 0 && config.getCorePoolSize() == 0) {
            throw new IllegalArgumentException("CorePoolSize must be > 0 when using a capacity queue");
        }
        AbstractQueue queue = config.getQueueSize() == 0 ? new SynchronousQueue() : (config.getQueueSize() < 0 || config.getQueueSize() == Integer.MAX_VALUE ? new LinkedBlockingQueue() : new ArrayBlockingQueue(config.getQueueSize()));
        DefaultThreadFactory factory = new DefaultThreadFactory(id, config.isThreadDaemon(), config.getThreadPriority());
        ThreadPoolExecutor.CallerRunsPolicy handler = new ThreadPoolExecutor.CallerRunsPolicy();
        ThreadPoolExecutor service = new ThreadPoolExecutor(config.getCorePoolSize(), config.getMaximumPoolSize() < 0 ? Integer.MAX_VALUE : config.getMaximumPoolSize(), config.getKeepAliveTime(), TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)queue), factory, handler);
        if (config.isAllowCoreThreadsTimeout()) {
            try {
                Method mth = service.getClass().getMethod("allowCoreThreadTimeOut", Boolean.TYPE);
                mth.invoke((Object)service, Boolean.TRUE);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return service;
    }

    public Map<String, ExecutorConfig> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<String, ExecutorConfig> configs) {
        this.configs = configs;
    }

    public ExecutorConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(ExecutorConfig defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        final boolean daemon;
        final int priority;

        DefaultThreadFactory(String id, boolean daemon, int priority) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + id + "-thread-";
            this.daemon = daemon;
            this.priority = priority;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon() != this.daemon) {
                t.setDaemon(this.daemon);
            }
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
            return t;
        }
    }
}

