/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jdbc.JDBCAdapter;
import org.apache.servicemix.jdbc.JDBCAdapterFactory;
import org.apache.servicemix.jdbc.Statements;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreFactory;
import org.apache.servicemix.store.jdbc.JdbcStore;

public class JdbcStoreFactory
implements StoreFactory {
    private boolean transactional;
    private boolean clustered;
    private DataSource dataSource;
    private IdGenerator idGenerator = new IdGenerator();
    private Map<String, JdbcStore> stores = new HashMap<String, JdbcStore>();
    private String tableName = "SM_STORE";
    private boolean createDataBase = true;
    private JDBCAdapter adapter;
    private Statements statements;

    public synchronized Store open(String name) throws IOException {
        JdbcStore store;
        if (this.adapter == null) {
            Connection connection = null;
            try {
                connection = this.getDataSource().getConnection();
                this.adapter = JDBCAdapterFactory.getAdapter(connection);
                if (this.statements == null) {
                    this.statements = new Statements();
                    this.statements.setStoreTableName(this.tableName);
                }
                this.adapter.setStatements(this.statements);
                if (this.createDataBase) {
                    this.adapter.doCreateTables(connection);
                }
                connection.commit();
            }
            catch (SQLException e) {
                throw (IOException)new IOException("Exception while creating database").initCause(e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        if ((store = this.stores.get(name)) == null) {
            store = new JdbcStore(this, name);
            this.stores.put(name, store);
        }
        return store;
    }

    public synchronized void close(Store store) throws IOException {
        this.stores.remove(store);
    }

    public JDBCAdapter getAdapter() {
        return this.adapter;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isCreateDataBase() {
        return this.createDataBase;
    }

    public void setCreateDataBase(boolean createDataBase) {
        this.createDataBase = createDataBase;
    }
}

