/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.servicemix.components.util.MessageTransformer;
import org.apache.servicemix.jbi.jaxp.BytesSource;
import org.apache.servicemix.jbi.jaxp.ResourceSource;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.xml.sax.SAXException;

public class CopyTransformer
implements MessageTransformer {
    private static final CopyTransformer INSTANCE = new CopyTransformer();
    private SourceTransformer sourceTransformer = new SourceTransformer();
    private boolean copyProperties = true;
    private boolean copyAttachments = true;
    private boolean copySecuritySubject = true;

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public void setCopyAttachments(boolean copyAttachments) {
        this.copyAttachments = copyAttachments;
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }

    public boolean isCopySecuritySubject() {
        return this.copySecuritySubject;
    }

    public void setCopySecuritySubject(boolean copySecuritySubject) {
        this.copySecuritySubject = copySecuritySubject;
    }

    public static CopyTransformer getInstance() {
        return INSTANCE;
    }

    public boolean transform(MessageExchange exchange, NormalizedMessage from, NormalizedMessage to) throws MessagingException {
        Source content;
        if (this.copyProperties) {
            CopyTransformer.copyProperties(from, to);
        }
        if (!(!((content = from.getContent()) instanceof StreamSource) && !(content instanceof SAXSource) || content instanceof StringSource || content instanceof BytesSource || content instanceof ResourceSource)) {
            try {
                content = this.sourceTransformer.toDOMSource(from);
            }
            catch (TransformerException e) {
                throw new MessagingException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new MessagingException((Throwable)e);
            }
            catch (IOException e) {
                throw new MessagingException((Throwable)e);
            }
            catch (SAXException e) {
                throw new MessagingException((Throwable)e);
            }
        }
        to.setContent(content);
        if (this.copyAttachments) {
            CopyTransformer.copyAttachments(from, to);
        }
        if (this.copySecuritySubject) {
            CopyTransformer.copySecuritySubject(from, to);
        }
        return true;
    }

    public static void copyProperties(NormalizedMessage from, NormalizedMessage to) {
        for (String name : from.getPropertyNames()) {
            if ("org.apache.servicemix.body".equals(name)) continue;
            Object value = from.getProperty(name);
            to.setProperty(name, value);
        }
    }

    public static void copyAttachments(NormalizedMessage from, NormalizedMessage to) throws MessagingException {
        for (String name : from.getAttachmentNames()) {
            DataHandler value = from.getAttachment(name);
            to.addAttachment(name, value);
        }
    }

    public static void copySecuritySubject(NormalizedMessage from, NormalizedMessage to) throws MessagingException {
        to.setSecuritySubject(from.getSecuritySubject());
    }
}

