/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.components.util.BinaryFileMarshaler;
import org.apache.servicemix.jbi.util.FileUtil;
import org.apache.servicemix.jbi.util.StreamDataSource;

public class CustomFileMarshaler
extends BinaryFileMarshaler {
    private String attachment = "content";
    private String contentType;

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void readMessage(MessageExchange exchange, NormalizedMessage message, InputStream in, String path) throws IOException, JBIException {
        StreamDataSource ds = new StreamDataSource(in, this.contentType);
        DataHandler handler = new DataHandler((DataSource)ds);
        message.addAttachment(this.attachment, handler);
        message.setProperty("org.apache.servicemix.file.name", (Object)new File(path).getName());
        message.setProperty("org.apache.servicemix.file.path", (Object)path);
    }

    public void writeMessage(MessageExchange exchange, NormalizedMessage message, OutputStream out, String path) throws IOException, JBIException {
        DataHandler handler = message.getAttachment(this.attachment);
        if (handler == null) {
            throw new MessagingException("Could not find attachment: " + this.attachment);
        }
        InputStream is = handler.getInputStream();
        FileUtil.copyInputStream(is, out);
    }
}

