/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.servicemix.components.util.ContentConverter;

public class DateConverter
implements ContentConverter {
    public static final String DEFAULT_OUTPUT_FORMATSTRING = "yyyy-MM-dd'T'HH:mm:ss'.'SSS";
    private DateFormat inputformat;
    private DateFormat outputformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS");
    private boolean blankValueIsNull = true;

    public DateConverter(DateFormat inputformat) {
        this.inputformat = inputformat;
    }

    public DateConverter(DateFormat inputformat, DateFormat outputformat) {
        this.inputformat = inputformat;
        this.outputformat = outputformat;
    }

    public DateConverter(String inputformat) {
        this.inputformat = new SimpleDateFormat(inputformat);
    }

    public DateConverter(String inputformat, String outputformat) {
        this.inputformat = new SimpleDateFormat(inputformat);
        this.outputformat = new SimpleDateFormat(outputformat);
    }

    public String convertToXml(String contents) {
        if (contents != null) {
            if (StringUtils.isNotBlank((String)contents)) {
                try {
                    return this.outputformat.format(this.inputformat.parse(contents));
                }
                catch (ParseException e) {
                    return contents;
                }
            }
            if (this.blankValueIsNull) {
                return "";
            }
            return contents;
        }
        return null;
    }

    public String convertToFlatFileContent(String contents) {
        if (contents != null) {
            try {
                return this.inputformat.format(this.outputformat.parse(contents));
            }
            catch (ParseException e) {
                return contents;
            }
        }
        return null;
    }

    public final void setInputformat(String format) {
        this.inputformat = new SimpleDateFormat(format);
    }

    public final void setOutpuformat(String format) {
        this.outputformat = new SimpleDateFormat(format);
    }

    public boolean isBlankValueIsNull() {
        return this.blankValueIsNull;
    }

    public void setBlankValueIsNull(boolean blankValueIsNull) {
        this.blankValueIsNull = blankValueIsNull;
    }
}

