/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.io.IOException;
import java.net.URI;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.servicemix.MessageExchangeListener;
import org.apache.servicemix.components.util.ComponentSupport;
import org.apache.servicemix.components.util.CopyTransformer;
import org.apache.servicemix.jbi.util.MessageUtil;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreFactory;
import org.apache.servicemix.store.memory.MemoryStoreFactory;

public abstract class TransformComponentSupport
extends ComponentSupport
implements MessageExchangeListener {
    private String correlation;
    private boolean copyProperties = true;
    private boolean copyAttachments = true;
    private StoreFactory storeFactory;
    private Store store;

    protected TransformComponentSupport() {
    }

    protected TransformComponentSupport(QName service, String endpoint) {
        super(service, endpoint);
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
        if (exchange.getRole() == MessageExchange.Role.CONSUMER || exchange.getProperty(this.correlation) != null) {
            this.processOngoingExchange(exchange);
        } else if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            this.processFirstExchange(exchange);
        }
    }

    protected void processFirstExchange(MessageExchange exchange) {
        block17: {
            try {
                NormalizedMessage out;
                MessageExchange outExchange = null;
                NormalizedMessage in = this.getInMessage(exchange);
                if (this.isInAndOut(exchange)) {
                    out = exchange.createMessage();
                } else {
                    URI pattern = exchange.getPattern();
                    outExchange = this.getExchangeFactory().createExchange(pattern);
                    outExchange.setProperty("org.apache.servicemix.senderEndpoint", (Object)(this.getService() + ":" + this.getEndpoint()));
                    outExchange.setProperty(this.correlation, (Object)exchange.getExchangeId());
                    exchange.setProperty(this.correlation, (Object)outExchange.getExchangeId());
                    String processCorrelationId = (String)exchange.getProperty("org.apache.servicemix.correlationId");
                    if (processCorrelationId != null) {
                        outExchange.setProperty("org.apache.servicemix.correlationId", (Object)processCorrelationId);
                    }
                    out = outExchange.createMessage();
                }
                boolean txSync = exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
                this.copyPropertiesAndAttachments(exchange, in, out);
                if (this.transform(exchange, in, out)) {
                    if (this.isInAndOut(exchange)) {
                        exchange.setMessage(out, "out");
                        if (txSync) {
                            this.sendSync(exchange);
                        } else {
                            this.send(exchange);
                        }
                        break block17;
                    }
                    outExchange.setMessage(out, "in");
                    if (txSync) {
                        this.sendSync(outExchange);
                        if (outExchange.getStatus() == ExchangeStatus.DONE) {
                            this.done(exchange);
                            break block17;
                        }
                        if (outExchange.getStatus() == ExchangeStatus.ERROR) {
                            this.fail(exchange, outExchange.getError());
                            break block17;
                        }
                        if (outExchange.getFault() != null) {
                            Fault fault = MessageUtil.copyFault(outExchange);
                            this.done(outExchange);
                            MessageUtil.transferToFault(fault, exchange);
                            this.sendSync(exchange);
                            break block17;
                        }
                        this.done(outExchange);
                        throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no Out nor Fault message");
                    }
                    this.store.store(exchange.getExchangeId(), (Object)exchange);
                    try {
                        this.send(outExchange);
                        break block17;
                    }
                    catch (Exception e) {
                        this.store.load(exchange.getExchangeId());
                        throw e;
                    }
                }
                exchange.setStatus(ExchangeStatus.DONE);
                this.send(exchange);
            }
            catch (Exception e) {
                try {
                    this.fail(exchange, e);
                }
                catch (Exception e2) {
                    this.logger.warn((Object)("Unable to handle error: " + e2), (Throwable)e2);
                    if (!this.logger.isDebugEnabled()) break block17;
                    this.logger.debug((Object)("Original error: " + e), (Throwable)e);
                }
            }
        }
    }

    protected void processOngoingExchange(MessageExchange exchange) {
        block12: {
            MessageExchange original = null;
            String id = null;
            try {
                id = (String)exchange.getProperty(this.correlation);
                original = (MessageExchange)this.store.load(id);
            }
            catch (Exception e) {
                return;
            }
            try {
                if (exchange.getStatus() == ExchangeStatus.DONE) {
                    this.done(original);
                    break block12;
                }
                if (exchange.getStatus() == ExchangeStatus.ERROR) {
                    this.fail(original, exchange.getError());
                    break block12;
                }
                if (exchange.getFault() != null) {
                    this.store.store(exchange.getExchangeId(), (Object)exchange);
                    try {
                        MessageUtil.transferTo(exchange, original, "fault");
                        this.send(original);
                        break block12;
                    }
                    catch (Exception e) {
                        this.store.load(exchange.getExchangeId());
                        throw e;
                    }
                }
                if (exchange.getMessage("out") != null) {
                    this.store.store(exchange.getExchangeId(), (Object)exchange);
                    try {
                        MessageUtil.transferTo(exchange, original, "out");
                        this.send(original);
                        break block12;
                    }
                    catch (Exception e) {
                        this.store.load(exchange.getExchangeId());
                        throw e;
                    }
                }
                throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no Out nor Fault message");
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block12;
                this.logger.debug((Object)("Original error: " + e), (Throwable)e);
            }
        }
    }

    protected abstract boolean transform(MessageExchange var1, NormalizedMessage var2, NormalizedMessage var3) throws Exception;

    protected void init() throws JBIException {
        super.init();
        if (this.store == null) {
            if (this.storeFactory == null) {
                this.storeFactory = new MemoryStoreFactory();
            }
            try {
                this.store = this.storeFactory.open(this.getService().toString() + this.getEndpoint());
            }
            catch (IOException e) {
                throw new JBIException("Unable to open storeFactory" + e.getMessage(), (Throwable)e);
            }
        }
        this.correlation = "TransformComponentSupport.Correlation." + this.getService() + "." + this.getEndpoint();
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
        if (this.getMessageTransformer() instanceof CopyTransformer) {
            ((CopyTransformer)this.getMessageTransformer()).setCopyProperties(copyProperties);
        }
    }

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public void setCopyAttachments(boolean copyAttachments) {
        this.copyAttachments = copyAttachments;
        if (this.getMessageTransformer() instanceof CopyTransformer) {
            ((CopyTransformer)this.getMessageTransformer()).setCopyAttachments(copyAttachments);
        }
    }

    protected void copyPropertiesAndAttachments(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        if (this.isCopyProperties()) {
            CopyTransformer.copyProperties(in, out);
        }
        if (this.isCopyAttachments()) {
            CopyTransformer.copyAttachments(in, out);
        }
    }

    public StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public void setStoreFactory(StoreFactory storeFactory) {
        this.storeFactory = storeFactory;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }
}

