/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.expression;

import java.io.IOException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.expression.MessageVariableResolver;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.util.MessageUtil;
import org.springframework.beans.factory.InitializingBean;
import org.xml.sax.SAXException;

public class JAXPXPathExpression
implements Expression,
InitializingBean {
    private String xpath;
    private boolean useMessageContent = true;
    private SourceTransformer transformer = new SourceTransformer();
    private MessageVariableResolver variableResolver = new MessageVariableResolver();
    private XPathExpression xPathExpression;
    private XPathFunctionResolver functionResolver;
    private NamespaceContext namespaceContext;
    private XPathFactory factory;

    public JAXPXPathExpression() {
    }

    public JAXPXPathExpression(String xpath) {
        this.xpath = xpath;
    }

    public void afterPropertiesSet() throws XPathExpressionException {
        if (this.xPathExpression == null) {
            if (this.xpath == null) {
                throw new IllegalArgumentException("You must specify the xpath property");
            }
            if (this.factory == null) {
                this.factory = XPathFactory.newInstance();
            }
            XPath xpathObject = this.factory.newXPath();
            xpathObject.setXPathVariableResolver(this.variableResolver);
            if (this.functionResolver != null) {
                xpathObject.setXPathFunctionResolver(this.functionResolver);
            }
            if (this.namespaceContext != null) {
                xpathObject.setNamespaceContext(this.namespaceContext);
            }
            this.xPathExpression = xpathObject.compile(this.xpath);
        }
    }

    public Object evaluate(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        return this.evaluate(exchange, message, XPathConstants.STRING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(MessageExchange exchange, NormalizedMessage message, QName returnType) throws MessagingException {
        try {
            this.afterPropertiesSet();
            Object object = this.getXMLNode(exchange, message);
            JAXPXPathExpression jAXPXPathExpression = this;
            synchronized (jAXPXPathExpression) {
                this.variableResolver.setExchange(exchange);
                this.variableResolver.setMessage(message);
                return this.evaluateXPath(object, returnType);
            }
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (XPathExpressionException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MessagingException((Throwable)e);
        }
    }

    public String getXPath() {
        return this.xpath;
    }

    public void setXPath(String xp) {
        this.xpath = xp;
    }

    public boolean isUseMessageContent() {
        return this.useMessageContent;
    }

    public void setUseMessageContent(boolean useMessageContent) {
        this.useMessageContent = useMessageContent;
    }

    public SourceTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(SourceTransformer transformer) {
        this.transformer = transformer;
    }

    public MessageVariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(MessageVariableResolver variableResolver) {
        this.variableResolver = variableResolver;
    }

    public XPathFactory getFactory() {
        return this.factory;
    }

    public void setFactory(XPathFactory factory) {
        this.factory = factory;
    }

    public XPathFunctionResolver getFunctionResolver() {
        return this.functionResolver;
    }

    public void setFunctionResolver(XPathFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    protected Object evaluateXPath(Object object) throws XPathExpressionException {
        return this.xPathExpression.evaluate(object);
    }

    protected Object evaluateXPath(Object object, QName returnType) throws XPathExpressionException {
        return this.xPathExpression.evaluate(object, returnType);
    }

    protected XPathExpression getXPathExpression() {
        return this.xPathExpression;
    }

    protected Object getXMLNode(MessageExchange exchange, NormalizedMessage message) throws TransformerException, MessagingException, ParserConfigurationException, IOException, SAXException {
        if (this.useMessageContent) {
            MessageUtil.enableContentRereadability(message);
        }
        return this.transformer.toDOMNode(message);
    }
}

