/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.container;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import org.apache.servicemix.components.util.ComponentAdaptor;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.DeploySupport;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.xbean.spring.context.impl.NamespaceHelper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;

public class SpringJBIContainer
extends JBIContainer
implements InitializingBean,
DisposableBean,
BeanFactoryAware,
ApplicationContextAware {
    private String[] componentNames;
    private ActivationSpec[] activationSpecs;
    private BeanFactory beanFactory;
    private ApplicationContext applicationContext;
    private String[] deployArchives;
    private DeploySupport[] deployments;
    private Runnable onShutDown;
    private Semaphore block = new Semaphore(0);
    private Map components;
    private Map endpoints;

    public void afterPropertiesSet() throws Exception {
        int i;
        this.init();
        if (this.componentNames != null) {
            for (i = 0; i < this.componentNames.length; ++i) {
                String componentName = this.componentNames[i];
                this.activateComponent(new ActivationSpec(componentName, this.lookupBean(componentName)));
            }
        }
        if (this.activationSpecs != null) {
            for (i = 0; i < this.activationSpecs.length; ++i) {
                ActivationSpec activationSpec = this.activationSpecs[i];
                this.activateComponent(activationSpec);
            }
        }
        if (this.deployArchives != null) {
            for (i = 0; i < this.deployArchives.length; ++i) {
                String archive = this.deployArchives[i];
                this.installArchive(archive);
            }
        }
        if (this.components != null) {
            for (Map.Entry e : this.components.entrySet()) {
                if (!(e.getKey() instanceof String)) {
                    throw new JBIException("Component must have a non null string name");
                }
                if (!(e.getValue() instanceof Component)) {
                    throw new JBIException("Component is not a known component");
                }
                String name = (String)e.getKey();
                this.activateComponent((Component)e.getValue(), name);
                this.getComponent(name).init();
            }
        }
        if (this.endpoints != null) {
            this.initEndpoints();
        }
        if (this.deployments != null) {
            for (DeploySupport deployment : this.deployments) {
                deployment.deploy(this);
            }
        }
        this.start();
    }

    private void initEndpoints() throws Exception {
        if (this.components == null) {
            this.components = new LinkedHashMap();
        }
        Class<?> componentClass = Class.forName("org.apache.servicemix.common.DefaultComponent");
        Class<?> endpointClass = Class.forName("org.apache.servicemix.common.Endpoint");
        Method addEndpointMethod = componentClass.getDeclaredMethod("addEndpoint", endpointClass);
        addEndpointMethod.setAccessible(true);
        Method getEndpointClassesMethod = componentClass.getDeclaredMethod("getEndpointClasses", null);
        getEndpointClassesMethod.setAccessible(true);
        for (Map.Entry e : this.endpoints.entrySet()) {
            String key = (String)e.getKey();
            List l = (List)e.getValue();
            for (Object endpoint : l) {
                Component c = null;
                if (key.length() > 0) {
                    Component comp = (Component)this.components.get(key);
                    if (comp == null) {
                        throw new JBIException("Could not find component '" + key + "' specified for endpoint");
                    }
                    c = comp;
                } else {
                    for (Component comp : this.components.values()) {
                        Class[] endpointClasses = (Class[])getEndpointClassesMethod.invoke((Object)comp, null);
                        if (!this.isKnownEndpoint(endpoint, endpointClasses)) continue;
                        c = comp;
                        break;
                    }
                    if (c == null && (c = this.getComponentForEndpoint(getEndpointClassesMethod, endpoint)) == null) {
                        throw new JBIException("Unable to find a component for endpoint class: " + endpoint.getClass());
                    }
                }
                addEndpointMethod.invoke((Object)c, endpoint);
            }
        }
    }

    private Component getComponentForEndpoint(Method getEndpointClassesMethod, Object endpoint) throws Exception {
        Properties namespaces = PropertiesLoaderUtils.loadAllProperties((String)"META-INF/spring.handlers");
        for (String string : namespaces.keySet()) {
            Class compClass;
            Component comp;
            Class[] endpointClasses;
            String uri = NamespaceHelper.createDiscoveryPathName((String)string);
            Properties props = PropertiesLoaderUtils.loadAllProperties((String)uri);
            String compClassName = props.getProperty("component");
            if (compClassName == null || !this.isKnownEndpoint(endpoint, endpointClasses = (Class[])getEndpointClassesMethod.invoke((Object)(comp = (Component)BeanUtils.instantiateClass((Class)(compClass = ClassUtils.forName((String)compClassName)))), null))) continue;
            String name = this.chooseComponentName(comp);
            this.activateComponent(comp, name);
            this.components.put(name, comp);
            return comp;
        }
        return null;
    }

    private String chooseComponentName(Object c) {
        String className = c.getClass().getName();
        if (className.startsWith("org.apache.servicemix.")) {
            int idx1 = className.lastIndexOf(46);
            int idx0 = className.lastIndexOf(46, idx1 - 1);
            String name = "servicemix-" + className.substring(idx0 + 1, idx1);
            if (this.registry.getComponent(name) == null) {
                return name;
            }
        }
        return this.createComponentID();
    }

    private boolean isKnownEndpoint(Object endpoint, Class[] knownClasses) {
        if (knownClasses != null) {
            for (int i = 0; i < knownClasses.length; ++i) {
                if (!knownClasses[i].isInstance(endpoint)) continue;
                return true;
            }
        }
        return false;
    }

    public void stop() throws JBIException {
        if (this.beanFactory instanceof DisposableBean) {
            DisposableBean disposable = (DisposableBean)this.beanFactory;
            try {
                disposable.destroy();
            }
            catch (Exception e) {
                throw new JBIException("Failed to dispose of the Spring BeanFactory due to: " + e, (Throwable)e);
            }
        }
        super.stop();
    }

    public Object getBean(String id) {
        Component bean;
        ComponentMBeanImpl component = this.getComponent(id);
        Component component2 = bean = component != null ? component.getComponent() : null;
        if (bean instanceof ComponentAdaptor) {
            bean = ((ComponentAdaptor)bean).getLifeCycle();
        }
        return bean;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public String[] getComponentNames() {
        return this.componentNames;
    }

    public void setComponentNames(String[] componentNames) {
        this.componentNames = componentNames;
    }

    public ActivationSpec[] getActivationSpecs() {
        return this.activationSpecs;
    }

    public void setActivationSpecs(ActivationSpec[] activationSpecs) throws JBIException {
        this.activationSpecs = activationSpecs;
    }

    public String[] getDeployArchives() {
        return this.deployArchives;
    }

    public void setDeployArchives(String[] deployArchives) {
        this.deployArchives = deployArchives;
    }

    public DeploySupport[] getDeployments() {
        return this.deployments;
    }

    public void setDeployments(DeploySupport[] deployments) {
        this.deployments = deployments;
    }

    protected Object lookupBean(String componentName) {
        Object bean = this.beanFactory.getBean(componentName);
        if (bean == null) {
            throw new IllegalArgumentException("Component name: " + componentName + " is not found in the Spring BeanFactory");
        }
        return bean;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        super.shutDown();
        this.block.release();
    }

    public void shutDown() throws JBIException {
        if (this.onShutDown != null) {
            this.onShutDown.run();
        } else {
            super.shutDown();
        }
    }

    public void block() throws InterruptedException {
        this.block.acquire();
    }

    public void onShutDown(Runnable runnable) {
        this.onShutDown = runnable;
    }

    public Map getComponents() {
        return this.components;
    }

    public void setComponents(Map components) {
        this.components = components;
    }

    public Map getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Map endpoints) {
        this.endpoints = endpoints;
    }
}

